/*
 * Decompiled with CFR 0.152.
 */
package sidplay.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidutils.CBMCodeUtils;
import sidplay.player.PSid64DetectedTuneInfo;

public final class PSid64Detection {
    public static PSid64DetectedTuneInfo detectPSid64TuneInfo(byte[] ram, int videoScreenAddress) {
        boolean detected = false;
        CPUClock cpuClock = null;
        ArrayList<ChipModel> chipModels = new ArrayList<ChipModel>();
        int stereoAddress = 0;
        int row = 2;
        int col = 6;
        if (PSid64Detection.checkScreenMessage(ram, videoScreenAddress, "PSID64", row, col)) {
            detected = true;
            row = 12;
            col = 10;
            if (PSid64Detection.checkScreenMessage(ram, videoScreenAddress, "NTSC", row, col)) {
                cpuClock = CPUClock.NTSC;
                ++col;
            } else {
                cpuClock = CPUClock.PAL;
            }
            String chipModel = PSid64Detection.detectChipModel6581or8580(ram, videoScreenAddress, row, col + 5);
            if (chipModel != null) {
                chipModels.add(PSid64Detection.toChipModel(chipModel));
            }
            if (chipModel != null && chipModel.length() == "MOSXXXX".length()) {
                col += 3;
            }
            if ((chipModel = PSid64Detection.detectChipModel6581or8580(ram, videoScreenAddress, row, col + 11)) != null) {
                chipModels.add(PSid64Detection.toChipModel(chipModel));
            }
            if (chipModel != null && chipModel.length() == "MOSXXXX".length()) {
                col += 3;
            }
            stereoAddress = PSid64Detection.detectStereoAddress(ram, videoScreenAddress, row, col + 19);
        }
        return new PSid64DetectedTuneInfo(detected, cpuClock, chipModels, stereoAddress);
    }

    private static String detectChipModel6581or8580(byte[] ram, int videoScreenAddress, int row, int column) {
        for (String chipModelAsString : Arrays.asList("MOS8580", "MOS6581", "8580", "6581")) {
            if (!PSid64Detection.checkScreenMessage(ram, videoScreenAddress, chipModelAsString, row, column)) continue;
            return chipModelAsString;
        }
        return null;
    }

    private static int detectStereoAddress(byte[] ram, int videoScreenAddress, int row, int column) {
        if (PSid64Detection.checkScreenMessage(ram, videoScreenAddress, "$", row, column)) {
            return PSid64Detection.getStereoAdress(ram, videoScreenAddress, row, column);
        }
        return 0;
    }

    private static int getStereoAdress(byte[] ram, int videoScreenAddress, int row, int column) {
        int stereoAddress = PSid64Detection.getDigit(ram, videoScreenAddress, row, column + 1) << 12 | PSid64Detection.getDigit(ram, videoScreenAddress, row, column + 2) << 8 | PSid64Detection.getDigit(ram, videoScreenAddress, row, column + 3) << 4 | PSid64Detection.getDigit(ram, videoScreenAddress, row, column + 4);
        return stereoAddress;
    }

    private static int getDigit(byte[] ram, int videoScreenAddress, int row, int column) {
        int offset = (row - 1) * 40 + column - 1;
        int ch = ram[videoScreenAddress + offset] & 0xFF;
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return 10 + (ch - 65);
        }
        return 0;
    }

    private static boolean checkScreenMessage(byte[] ram, int videoScreenAddress, String expected, int row, int column) {
        byte[] expectedScreenCodes = CBMCodeUtils.petsciiToScreenRam(expected.toLowerCase(Locale.US));
        int offset = (row - 1) * 40 + column - 1;
        for (int i = 0; i < expected.length(); ++i) {
            if (ram[videoScreenAddress + offset + i] == expectedScreenCodes[i]) continue;
            return false;
        }
        return true;
    }

    private static ChipModel toChipModel(String chipModelAsString) {
        if (chipModelAsString.equals("MOS8580") || chipModelAsString.equals("8580")) {
            return ChipModel.MOS8580;
        }
        return ChipModel.MOS6581;
    }
}

