/*
 * Decompiled with CFR 0.152.
 */
package ui;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Application;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import libsidplay.components.c1541.C1541;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.IOUtils;
import sidplay.Player;
import sidplay.fingerprinting.FingerprintJsonClient;
import sidplay.ini.converter.FileToStringConverter;
import sidplay.player.DebugUtil;
import ui.JSidPlay2;
import ui.common.Convenience;
import ui.entities.config.Configuration;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.WhatsSidSection;
import ui.entities.config.service.ConfigService;

public class JSidPlay2Main
extends Application
implements Function<SidTune, String> {
    private JSIDPlay2MainParameters parameters = new JSIDPlay2MainParameters();
    protected JSidPlay2 jSidplay2;
    private ConfigService configService;
    private Player player;
    private Consumer<Player> menuHook = player -> {
        if (player.getTune() != SidTune.RESET) {
            String path;
            SidTuneInfo info = player.getTune().getInfo();
            Iterator<String> detail = info.getInfoString().iterator();
            System.out.print("Playing: ");
            while (detail.hasNext()) {
                System.out.print(detail.next());
                if (!detail.hasNext()) continue;
                System.out.print(", ");
            }
            if (info.getSongs() > 1) {
                System.out.print(", sub-song: ");
                System.out.print(info.getCurrentSong());
            }
            if ((path = player.getSidDatabaseInfo(db -> db.getPath(player.getTune()), "")).length() > 0) {
                System.out.print(", ");
                System.out.print(path);
            }
            System.out.println();
        }
    };

    public void start(Stage primaryStage) {
        try {
            Configuration configuration = this.getConfigurationFromCommandLineArgs();
            SidPlay2Section sidplay2Section = configuration.getSidplay2Section();
            WhatsSidSection whatsSidSection = configuration.getWhatsSidSection();
            String url = whatsSidSection.getUrl();
            String username = whatsSidSection.getUsername();
            String password = whatsSidSection.getPassword();
            int connectionTimeout = whatsSidSection.getConnectionTimeout();
            this.player = new Player(configuration);
            this.player.setFirstPlayListEntryIsOne(sidplay2Section.isPlayListStartsWithOne());
            this.player.setMenuHook(this.menuHook);
            this.player.setRecordingFilenameProvider(this);
            this.player.setFingerPrintMatcher(new FingerprintJsonClient(url, username, password, connectionTimeout));
            this.autostartFilenames();
            this.jSidplay2 = new JSidPlay2(primaryStage, this.player);
            Scene scene = primaryStage.getScene();
            if (scene != null) {
                Window window = scene.getWindow();
                window.setX(sidplay2Section.getFrameX());
                sidplay2Section.frameXProperty().bind((ObservableValue)window.xProperty());
                window.setY(sidplay2Section.getFrameY());
                sidplay2Section.frameYProperty().bind((ObservableValue)window.yProperty());
                window.setWidth(sidplay2Section.getFrameWidth());
                sidplay2Section.frameWidthProperty().bind((ObservableValue)window.widthProperty());
                window.setHeight(sidplay2Section.getFrameHeight());
                sidplay2Section.frameHeightProperty().bind((ObservableValue)window.heightProperty());
                this.jSidplay2.open();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void stop() {
        this.player.stopC64();
        for (C1541 floppy : this.player.getFloppies()) {
            try {
                floppy.getDiskController().ejectDisk();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            this.player.getDatasette().ejectTape();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        this.configService.save((Configuration)this.player.getConfig());
        this.configService.close();
        System.exit(0);
    }

    @Override
    public String apply(SidTune tune) {
        String defaultName = "jsidplay2";
        if (tune == SidTune.RESET) {
            return new File(this.player.getConfig().getSidplay2Section().getTmpDir(), defaultName).getAbsolutePath();
        }
        SidTuneInfo info = tune.getInfo();
        Iterator<String> infos = info.getInfoString().iterator();
        String name = infos.hasNext() ? infos.next().replaceAll("[:\\\\/*?|<>]", "_") : defaultName;
        String filename = new File(this.player.getConfig().getSidplay2Section().getTmpDir(), IOUtils.getFilenameWithoutSuffix(name)).getAbsolutePath();
        if (info.getSongs() > 1) {
            filename = filename + String.format("-%02d", info.getCurrentSong());
        }
        return filename;
    }

    private Configuration getConfigurationFromCommandLineArgs() {
        try {
            Application.Parameters javafxParameters = this.getParameters();
            if (javafxParameters != null) {
                String[] args = javafxParameters.getRaw().toArray(new String[0]);
                JCommander commander = JCommander.newBuilder().addObject((Object)this.parameters).programName(this.getClass().getName()).build();
                commander.parse(args);
                if (this.parameters.help.booleanValue()) {
                    commander.usage();
                    System.out.println("Press <enter> to exit!");
                    System.in.read();
                    System.exit(0);
                }
            }
        }
        catch (ParameterException | IOException e) {
            System.err.println(e.getMessage());
        }
        return this.getConfiguration();
    }

    private Configuration getConfiguration() {
        this.configService = new ConfigService(this.parameters.configurationType);
        return this.configService.load();
    }

    private void autostartFilenames() {
        if (this.parameters.file != null) {
            try {
                new Convenience(this.player).autostart(this.parameters.file, Convenience.LEXICALLY_FIRST_MEDIA, null);
            }
            catch (IOException | SidTuneError e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        JSidPlay2Main.launch((String[])args);
    }

    static {
        DebugUtil.init();
    }

    @Parameters(resourceBundle="ui.JSidPlay2MainParameters")
    public static class JSIDPlay2MainParameters {
        @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true, order=0)
        private Boolean help = Boolean.FALSE;
        @Parameter(names={"--configurationType", "-c"}, descriptionKey="CONFIGURATION_TYPE", order=1)
        private ConfigService.ConfigurationType configurationType = ConfigService.ConfigurationType.XML;
        @Parameter(descriptionKey="FILE", converter=FileToStringConverter.class)
        private File file;
    }
}

