/*
 * Decompiled with CFR 0.152.
 */
package ui.common.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Locale;

public final class DocsFileFilter
implements FileFilter {
    private static final String[] DEFAULT_FILE_NAME_EXT = new String[]{".pdf"};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) return true;
        if (!Arrays.stream(DEFAULT_FILE_NAME_EXT).filter(file.getName().toLowerCase(Locale.ENGLISH)::endsWith).findFirst().isPresent()) return false;
        return true;
    }
}

