/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import javafx.beans.property.FloatProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.Id;
import libsidplay.config.IFilterSection;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.ShadowField;

@Entity
@Access(value=AccessType.PROPERTY)
public class FilterSection
implements IFilterSection {
    private ShadowField<StringProperty, String> name = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<FloatProperty, Number> filter8580CurvePosition = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> filter6581CurvePosition = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> attenuation = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> nonlinearity = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> voiceNonlinearity = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> baseresistance = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> offset = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> steepness = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> minimumfetresistance = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> k = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> b = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);
    private ShadowField<FloatProperty, Number> resonanceFactor = new ShadowField<FloatProperty, Integer>(number -> new SimpleFloatProperty(number.floatValue()), 0);

    public FilterSection() {
    }

    public FilterSection(IFilterSection f) {
        if (f.isReSIDFilter8580()) {
            this.setName(f.getName());
            this.setFilter8580CurvePosition(f.getFilter8580CurvePosition());
        } else if (f.isReSIDFilter6581()) {
            this.setName(f.getName());
            this.setFilter6581CurvePosition(f.getFilter6581CurvePosition());
        } else if (f.isReSIDfpFilter8580()) {
            this.setName(f.getName());
            this.setK(f.getK());
            this.setB(f.getB());
            this.setVoiceNonlinearity(f.getVoiceNonlinearity());
            this.setResonanceFactor(f.getResonanceFactor());
        } else if (f.isReSIDfpFilter6581()) {
            this.setName(f.getName());
            this.setAttenuation(f.getAttenuation());
            this.setNonlinearity(f.getNonlinearity());
            this.setVoiceNonlinearity(f.getVoiceNonlinearity());
            this.setBaseresistance(f.getBaseresistance());
            this.setOffset(f.getOffset());
            this.setSteepness(f.getSteepness());
            this.setMinimumfetresistance(f.getMinimumfetresistance());
            this.setResonanceFactor(f.getResonanceFactor());
        }
    }

    @Override
    @Id
    public String getName() {
        return this.name.get();
    }

    @Override
    public void setName(String name) {
        this.name.set(name);
    }

    public final StringProperty nameProperty() {
        return this.name.property();
    }

    @Override
    public float getFilter8580CurvePosition() {
        return this.filter8580CurvePosition.get().floatValue();
    }

    @Override
    public void setFilter8580CurvePosition(float filter8580CurvePosition) {
        this.filter8580CurvePosition.set(Float.valueOf(filter8580CurvePosition));
    }

    public final FloatProperty filter8580CurvePositionProperty() {
        return this.filter8580CurvePosition.property();
    }

    @Override
    public float getFilter6581CurvePosition() {
        return this.filter6581CurvePosition.get().floatValue();
    }

    @Override
    public void setFilter6581CurvePosition(float filter6581CurvePosition) {
        this.filter6581CurvePosition.set(Float.valueOf(filter6581CurvePosition));
    }

    public final FloatProperty filter6581CurvePositionProperty() {
        return this.filter6581CurvePosition.property();
    }

    @Override
    public float getAttenuation() {
        return this.attenuation.get().floatValue();
    }

    @Override
    public void setAttenuation(float attenuation) {
        this.attenuation.set(Float.valueOf(attenuation));
    }

    public final FloatProperty attenuationProperty() {
        return this.attenuation.property();
    }

    @Override
    public float getNonlinearity() {
        return this.nonlinearity.get().floatValue();
    }

    @Override
    public void setNonlinearity(float nonlinearity) {
        this.nonlinearity.set(Float.valueOf(nonlinearity));
    }

    public final FloatProperty nonlinearityProperty() {
        return this.nonlinearity.property();
    }

    @Override
    public float getVoiceNonlinearity() {
        return this.voiceNonlinearity.get().floatValue();
    }

    @Override
    public void setVoiceNonlinearity(float voiceNonlinearity) {
        this.voiceNonlinearity.set(Float.valueOf(voiceNonlinearity));
    }

    public final FloatProperty voiceNonlinearityProperty() {
        return this.voiceNonlinearity.property();
    }

    @Override
    public float getBaseresistance() {
        return this.baseresistance.get().floatValue();
    }

    @Override
    public void setBaseresistance(float baseresistance) {
        this.baseresistance.set(Float.valueOf(baseresistance));
    }

    public final FloatProperty baseresistanceProperty() {
        return this.baseresistance.property();
    }

    @Override
    public float getOffset() {
        return this.offset.get().floatValue();
    }

    @Override
    public void setOffset(float offset) {
        this.offset.set(Float.valueOf(offset));
    }

    public final FloatProperty offsetProperty() {
        return this.offset.property();
    }

    @Override
    public float getSteepness() {
        return this.steepness.get().floatValue();
    }

    @Override
    public void setSteepness(float steepness) {
        this.steepness.set(Float.valueOf(steepness));
    }

    public final FloatProperty steepnessProperty() {
        return this.steepness.property();
    }

    @Override
    public float getMinimumfetresistance() {
        return this.minimumfetresistance.get().floatValue();
    }

    @Override
    public void setMinimumfetresistance(float minimumfetresistance) {
        this.minimumfetresistance.set(Float.valueOf(minimumfetresistance));
    }

    public final FloatProperty minimumfetresistanceProperty() {
        return this.minimumfetresistance.property();
    }

    @Override
    public float getK() {
        return this.k.get().floatValue();
    }

    @Override
    public void setK(float k) {
        this.k.set(Float.valueOf(k));
    }

    public final FloatProperty kProperty() {
        return this.k.property();
    }

    @Override
    public float getB() {
        return this.b.get().floatValue();
    }

    @Override
    public void setB(float b) {
        this.b.set(Float.valueOf(b));
    }

    public final FloatProperty bProperty() {
        return this.b.property();
    }

    @Override
    public float getResonanceFactor() {
        return this.resonanceFactor.get().floatValue();
    }

    @Override
    public void setResonanceFactor(float resonanceFactor) {
        this.resonanceFactor.set(Float.valueOf(resonanceFactor));
    }

    public final FloatProperty resonanceFactorProperty() {
        return this.resonanceFactor.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

