/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.xml.bind.annotation.XmlTransient;
import libsidplay.components.keyboard.KeyTableEntry;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.ShadowField;

@Entity
@Access(value=AccessType.PROPERTY)
public class KeyTableEntity {
    private Integer id;
    private ShadowField<ObjectProperty<KeyTableEntry>, KeyTableEntry> entry = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<StringProperty, String> keyCodeName = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);

    public KeyTableEntity() {
    }

    public KeyTableEntity(KeyTableEntity keyTableEntity) {
        this(keyTableEntity.getKeyCodeName(), keyTableEntity.getEntry());
    }

    private KeyTableEntity(String keyCodeName, KeyTableEntry keyTableEntry) {
        this.setKeyCodeName(keyCodeName);
        this.setEntry(keyTableEntry);
    }

    public static final KeyTableEntity of(String keyCode, KeyTableEntry entry) {
        return new KeyTableEntity(keyCode, entry);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Enumerated(value=EnumType.STRING)
    public KeyTableEntry getEntry() {
        return this.entry.get();
    }

    public void setEntry(KeyTableEntry entry) {
        this.entry.set(entry);
    }

    public final ObjectProperty<KeyTableEntry> entryProperty() {
        return this.entry.property();
    }

    public String getKeyCodeName() {
        return this.keyCodeName.get();
    }

    public void setKeyCodeName(String keyCodeName) {
        this.keyCodeName.set(keyCodeName);
    }

    public final StringProperty keyCodeNameProperty() {
        return this.keyCodeName.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

