/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.debug.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.LogRecord;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import server.restful.common.Order;
import ui.entities.debug.DebugEntry;
import ui.entities.debug.DebugEntry_;

public class DebugService {
    private EntityManager em;

    public DebugService(EntityManager em) {
        this.em = em;
    }

    public void save(LogRecord record, Boolean tooMuchLogging) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                DebugEntry debugEntry = new DebugEntry();
                debugEntry.setInstant(Instant.ofEpochMilli(record.getMillis()));
                debugEntry.setSourceClassName(record.getSourceClassName());
                debugEntry.setSourceMethodName(record.getSourceMethodName());
                debugEntry.setLevel(record.getLevel().getName());
                debugEntry.setMessage(record.getMessage());
                debugEntry.setTooMuchLogging(tooMuchLogging);
                this.em.persist((Object)debugEntry);
                this.em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
    }

    public List<DebugEntry> findDebugEntries(Long instant, String sourceClassName, String sourceMethodName, String level, String message, int maxResults, Order order, Boolean tooMuchLogging) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaQuery query = cb.createQuery(DebugEntry.class);
                Root root = query.from(DebugEntry.class);
                Predicate where = this.whereClause(instant, sourceClassName, sourceMethodName, level, message, order, tooMuchLogging, cb, (Root<DebugEntry>)root);
                query.select((Selection)root).where((Expression)where);
                if (order == Order.ASC) {
                    query.orderBy(new javax.persistence.criteria.Order[]{cb.asc((Expression)root.get(DebugEntry_.instant))});
                } else {
                    query.orderBy(new javax.persistence.criteria.Order[]{cb.desc((Expression)root.get(DebugEntry_.instant))});
                }
                List result = this.em.createQuery(query).setMaxResults(maxResults).getResultList();
                this.em.getTransaction().commit();
                return result;
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return null;
    }

    public Long countDebugEntries(Long instant, String sourceClassName, String sourceMethodName, String level, String message, Order order, Boolean tooMuchLogging) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaQuery query = cb.createQuery(Long.class);
                Root root = query.from(DebugEntry.class);
                Predicate where = this.whereClause(instant, sourceClassName, sourceMethodName, level, message, order, tooMuchLogging, cb, (Root<DebugEntry>)root);
                query.select((Selection)cb.count((Expression)root)).where((Expression)where);
                Long result = (Long)this.em.createQuery(query).getSingleResult();
                this.em.getTransaction().commit();
                return result;
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return null;
    }

    private Predicate whereClause(Long instantAsEpochMillis, String sourceClassName, String sourceMethodName, String level, String message, Order order, Boolean tooMuchLogging, CriteriaBuilder cb, Root<DebugEntry> root) {
        Instant instant = Instant.ofEpochMilli(instantAsEpochMillis);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (order == Order.ASC) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(DebugEntry_.instant), (Comparable)instant));
        } else {
            predicates.add(cb.lessThanOrEqualTo((Expression)root.get(DebugEntry_.instant), (Comparable)instant));
        }
        Optional<Predicate> sourceClassNamePredicate = !sourceClassName.isEmpty() ? Optional.of(cb.like((Expression)root.get(DebugEntry_.sourceClassName), "%" + sourceClassName + "%")) : Optional.empty();
        sourceClassNamePredicate.ifPresent(predicates::add);
        Optional<Predicate> sourceMethodNamePredicate = !sourceMethodName.isEmpty() ? Optional.of(cb.like((Expression)root.get(DebugEntry_.sourceMethodName), "%" + sourceMethodName + "%")) : Optional.empty();
        sourceMethodNamePredicate.ifPresent(predicates::add);
        Optional<Predicate> levelPredicate = !level.isEmpty() ? Optional.of(cb.like((Expression)root.get(DebugEntry_.level), "%" + level + "%")) : Optional.empty();
        levelPredicate.ifPresent(predicates::add);
        Optional<Predicate> messagePredicate = !message.isEmpty() ? Optional.of(cb.like((Expression)root.get(DebugEntry_.message), "%" + message + "%")) : Optional.empty();
        messagePredicate.ifPresent(predicates::add);
        if (!tooMuchLogging.booleanValue()) {
            predicates.add(cb.equal((Expression)root.get(DebugEntry_.tooMuchLogging), (Object)tooMuchLogging));
        }
        return cb.and(predicates.toArray(new Predicate[predicates.size()]));
    }
}

