/*
 * Decompiled with CFR 0.152.
 */
package ui.ultimate64;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.util.Duration;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.Ultimate64;
import libsidplay.common.CPUClock;
import libsidplay.common.VICChipModel;
import libsidplay.components.mos656x.IPalette;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.config.IWhatsSidSection;
import libsidplay.sidtune.SidTune;
import libsidutils.fingerprinting.IFingerprintMatcher;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import sidplay.Player;
import sidplay.audio.AudioConfig;
import sidplay.audio.JavaSound;
import sidplay.fingerprinting.FingerprintJsonClient;
import sidplay.fingerprinting.WhatsSidSupport;
import ui.common.C64Window;
import ui.common.ImageQueue;
import ui.common.Toast;
import ui.common.converter.NumberToStringConverter;
import ui.entities.config.AudioSection;
import ui.entities.config.EmulationSection;
import ui.entities.config.SidPlay2Section;
import ui.entities.config.WhatsSidSection;
import ui.ultimate64.StreamingPlayer;

public class Ultimate64Window
extends C64Window
implements Ultimate64 {
    private static final int SCREEN_HEIGHT = 272;
    private static final int SCREEN_WIDTH = 384;
    private static final int FRAME_RATE = 48000;
    private static final int CHANNELS = 2;
    private static final int AUDIO_BUFFER_SIZE = 192;
    private StreamingPlayer audioPlayer = new StreamingPlayer(){
        private DatagramSocket serverSocket;
        private JavaSound javaSound = new JavaSound();
        private Thread whatsSidMatcherThread;

        @Override
        protected void open() throws IOException, LineUnavailableException, InterruptedException {
            AudioSection audioSection = Ultimate64Window.this.util.getConfig().getAudioSection();
            EmulationSection emulationSection = Ultimate64Window.this.util.getConfig().getEmulationSection();
            WhatsSidSection whatsSidSection = Ultimate64Window.this.util.getConfig().getWhatsSidSection();
            String url = whatsSidSection.getUrl();
            String username = whatsSidSection.getUsername();
            String password = whatsSidSection.getPassword();
            int connectionTimeout = whatsSidSection.getConnectionTimeout();
            AudioConfig audioConfig = new AudioConfig(48000, 2, (Integer)Ultimate64Window.this.audioBufferSize.getValue());
            this.javaSound.open(audioConfig, JavaSound.getDeviceInfo(audioSection));
            Ultimate64Window.this.whatsSidEnabled = whatsSidSection.isEnable();
            Ultimate64Window.this.whatsSidSupport = new WhatsSidSupport(48000.0, whatsSidSection.getCaptureTime(), whatsSidSection.getMinimumRelativeConfidence());
            Ultimate64Window.this.whatsSidSupport.reset();
            Ultimate64Window.this.fingerPrintMatcher = new FingerprintJsonClient(url, username, password, connectionTimeout);
            this.serverSocket = new DatagramSocket(emulationSection.getUltimate64StreamingAudioPort());
            this.serverSocket.setSoTimeout(5000);
            Ultimate64Window.this.startStreaming(emulationSection, Ultimate64.SocketStreamingCommand.SOCKET_CMD_AUDIOSTREAM_ON, emulationSection.getUltimate64StreamingTarget() + ":" + emulationSection.getUltimate64StreamingAudioPort(), 0);
        }

        @Override
        protected void play() throws IOException, InterruptedException {
            WhatsSidSection whatsSidSection = Ultimate64Window.this.util.getConfig().getWhatsSidSection();
            byte[] receiveData = new byte[770];
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            this.serverSocket.receive(receivePacket);
            ShortBuffer shortBuffer = ByteBuffer.wrap(receiveData, 2, receiveData.length - 2).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            while (shortBuffer.hasRemaining()) {
                short valL = shortBuffer.get();
                short valR = shortBuffer.get();
                this.javaSound.buffer().putShort(valL);
                if (!this.javaSound.buffer().putShort(valR).hasRemaining()) {
                    this.javaSound.write();
                    ((Buffer)this.javaSound.buffer()).clear();
                }
                if (!Ultimate64Window.this.whatsSidEnabled || !Ultimate64Window.this.whatsSidSupport.output(valL, valR)) continue;
                this.matchTune(whatsSidSection);
            }
        }

        private void matchTune(IWhatsSidSection whatsSidSection) {
            if (this.whatsSidMatcherThread == null || !this.whatsSidMatcherThread.isAlive()) {
                this.whatsSidMatcherThread = new Thread(() -> {
                    try {
                        MusicInfoWithConfidenceBean result = Ultimate64Window.this.whatsSidSupport.match(Ultimate64Window.this.fingerPrintMatcher);
                        if (result != null) {
                            Platform.runLater(() -> {
                                System.out.println(result);
                                Toast.makeText("whatssid", (Node)Ultimate64Window.this.whatsSidPositioner, result.toString(), 5);
                            });
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.whatsSidMatcherThread.setPriority(1);
                this.whatsSidMatcherThread.start();
            }
        }

        @Override
        protected void close() {
            EmulationSection emulationSection = Ultimate64Window.this.util.getConfig().getEmulationSection();
            Ultimate64Window.this.stopStreaming(emulationSection, Ultimate64.SocketStreamingCommand.SOCKET_CMD_AUDIOSTREAM_OFF);
            this.javaSound.close();
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            Ultimate64Window.this.audioStreaming.setSelected(false);
            this.whatsSidMatcherThread = null;
        }
    };
    private StreamingPlayer videoPlayer = new StreamingPlayer(){
        private DatagramSocket serverSocket;
        private WritableImage image;
        private boolean frameStart;

        @Override
        protected void open() throws IOException, LineUnavailableException {
            SidPlay2Section sidplay2Section = Ultimate64Window.this.util.getConfig().getSidplay2Section();
            EmulationSection emulationSection = Ultimate64Window.this.util.getConfig().getEmulationSection();
            Ultimate64Window.this.palEmulation = new PALEmulation(VICChipModel.MOS6567R8);
            Ultimate64Window.this.palEmulation.setPalEmulationEnable(Ultimate64Window.this.enablePalEmulation.isSelected());
            IPalette palette = Ultimate64Window.this.palEmulation.getPalette();
            palette.setBrightness(sidplay2Section.getBrightness());
            palette.setContrast(sidplay2Section.getContrast());
            palette.setGamma(sidplay2Section.getGamma());
            palette.setSaturation(sidplay2Section.getSaturation());
            palette.setPhaseShift(sidplay2Section.getPhaseShift());
            palette.setOffset(sidplay2Section.getOffset());
            palette.setTint(sidplay2Section.getTint());
            palette.setLuminanceC(sidplay2Section.getBlur());
            palette.setDotCreep(sidplay2Section.getBleed());
            Ultimate64Window.this.palEmulation.updatePalette();
            this.serverSocket = new DatagramSocket(emulationSection.getUltimate64StreamingVideoPort());
            this.serverSocket.setSoTimeout(5000);
            this.image = new WritableImage(384, 272);
            Ultimate64Window.this.startStreaming(emulationSection, Ultimate64.SocketStreamingCommand.SOCKET_CMD_VICSTREAM_ON, emulationSection.getUltimate64StreamingTarget() + ":" + emulationSection.getUltimate64StreamingVideoPort(), 0);
            this.frameStart = false;
        }

        @Override
        protected void play() throws IOException, InterruptedException {
            byte[] receiveData = new byte[780];
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            this.serverSocket.receive(receivePacket);
            int lineNo = (receivePacket.getData()[5] & 0xFF) << 8 | receivePacket.getData()[4] & 0xFF;
            boolean isLastPacketOfFrame = (lineNo & 0x8000) != 0;
            lineNo &= lineNo & 0xFFFF7FFF;
            int pixelsPerLine = (receivePacket.getData()[7] & 0xFF) << 8 | receivePacket.getData()[6] & 0xFF;
            int linesPerPacket = receivePacket.getData()[8] & 0xFF;
            int bitsPerPixel = receivePacket.getData()[9] & 0xFF;
            int encodingType = (receivePacket.getData()[11] & 0xFF) << 8 | receivePacket.getData()[10] & 0xFF;
            byte[] pixelData = new byte[linesPerPacket * pixelsPerLine * bitsPerPixel / 8];
            System.arraycopy(receivePacket.getData(), 12, pixelData, 0, pixelData.length);
            assert (pixelsPerLine == 384);
            assert (linesPerPacket == 4);
            assert (bitsPerPixel == 4);
            assert (encodingType == 0);
            if (this.frameStart) {
                Ultimate64Window.this.palEmulation.reset();
                int graphicsDataBuffer = 0;
                int pixelDataOffset = 0;
                for (int y = 0; y < linesPerPacket; ++y) {
                    int rasterY = lineNo + y;
                    Ultimate64Window.this.palEmulation.determineCurrentPalette(rasterY, rasterY == 0);
                    for (int x = 0; x < pixelsPerLine; ++x) {
                        graphicsDataBuffer <<= 4;
                        graphicsDataBuffer |= pixelData[pixelDataOffset + x >> 1] >> ((x & 1) << 2) & 0xF;
                        if ((x + 1 & 7) != 0) continue;
                        Ultimate64Window.this.palEmulation.drawPixels(graphicsDataBuffer);
                    }
                    pixelDataOffset += pixelsPerLine;
                }
                this.image.getPixelWriter().setPixels(0, lineNo, pixelsPerLine, linesPerPacket, (PixelFormat)PixelFormat.getByteBgraPreInstance(), Ultimate64Window.this.palEmulation.getPixels().array(), 0, pixelsPerLine << 2);
                if (isLastPacketOfFrame) {
                    Ultimate64Window.this.imageQueue.push(this.copyImage());
                }
            }
            if (isLastPacketOfFrame) {
                this.frameStart = true;
            }
        }

        private WritableImage copyImage() {
            PixelReader pixelReader = this.image.getPixelReader();
            int width = (int)this.image.getWidth();
            int height = (int)this.image.getHeight();
            WritableImage writableImage = new WritableImage(width, height);
            PixelWriter pixelWriter = writableImage.getPixelWriter();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixelWriter.setColor(x, y, pixelReader.getColor(x, y));
                }
            }
            return writableImage;
        }

        @Override
        protected void close() {
            EmulationSection emulationSection = Ultimate64Window.this.util.getConfig().getEmulationSection();
            Ultimate64Window.this.imageQueue.clear();
            Ultimate64Window.this.stopStreaming(emulationSection, Ultimate64.SocketStreamingCommand.SOCKET_CMD_VICSTREAM_OFF);
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            Ultimate64Window.this.videoStreaming.setSelected(false);
        }
    };
    @FXML
    private ImageView screen;
    @FXML
    private ToggleButton audioStreaming;
    @FXML
    private ToggleButton videoStreaming;
    @FXML
    private ComboBox<Integer> audioBufferSize;
    @FXML
    private CheckBox enablePalEmulation;
    @FXML
    protected Label whatsSidPositioner;
    @FXML
    private Slider scaling;
    @FXML
    private Label scalingValue;
    private boolean whatsSidEnabled;
    private WhatsSidSupport whatsSidSupport;
    private IFingerprintMatcher fingerPrintMatcher;
    private PALEmulation palEmulation;
    private ImageQueue<Image> imageQueue;
    private PauseTransition pauseTransition;
    private SequentialTransition sequentialTransition;

    public Ultimate64Window() {
    }

    public Ultimate64Window(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
        EmulationSection emulationSection = this.util.getConfig().getEmulationSection();
        this.scaling.setLabelFormatter(new NumberToStringConverter(2));
        this.scaling.valueProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty());
        this.scalingValue.textProperty().bindBidirectional((Property)sidplay2Section.videoScalingProperty(), new NumberToStringConverter(2));
        this.scaling.valueProperty().addListener((observable, oldValue, newValue) -> this.updateScaling(sidplay2Section.getVideoScaling()));
        this.updateScaling(sidplay2Section.getVideoScaling());
        this.audioBufferSize.setValue((Object)AudioConfig.getDefaultBufferSize());
        this.enablePalEmulation.setSelected(true);
        this.pauseTransition = new PauseTransition();
        this.sequentialTransition = new SequentialTransition(new Animation[]{this.pauseTransition});
        this.pauseTransition.setOnFinished(evt -> {
            Image image = this.imageQueue.pull();
            if (image != null) {
                this.screen.setImage(image);
            }
        });
        this.sequentialTransition.setCycleCount(-1);
        this.imageQueue = new ImageQueue();
        SidTune tune = this.util.getPlayer().getTune();
        this.setupVideoScreen(CPUClock.getCPUClock(emulationSection, tune));
        this.sequentialTransition.playFromStart();
    }

    private void updateScaling(double scale) {
        this.screen.setScaleX(scale);
        this.screen.setScaleY(scale);
    }

    @FXML
    private void enableDisableAudioStreaming() {
        if (this.audioStreaming.isSelected()) {
            this.audioPlayer.start();
        } else {
            this.audioPlayer.stop();
        }
    }

    @FXML
    private void enableDisableVideoStreaming() {
        if (this.videoStreaming.isSelected()) {
            this.videoPlayer.start();
        } else {
            this.videoPlayer.stop();
        }
    }

    @FXML
    private void setAudioBufferSize() {
        if (this.audioStreaming.isSelected()) {
            this.audioPlayer.stop();
            this.audioPlayer.start();
            this.audioStreaming.setSelected(true);
        }
    }

    @FXML
    private void setEnablePalEmulation() {
        this.palEmulation.setPalEmulationEnable(this.enablePalEmulation.isSelected());
    }

    private void setupVideoScreen(CPUClock cpuClock) {
        this.pauseTransition.setDuration(Duration.millis((double)(1000.0 / cpuClock.getScreenRefresh())));
        this.screen.setFitWidth(384.0);
        this.screen.setFitHeight(272.0);
    }

    @Override
    public void doClose() {
        this.audioPlayer.stop();
        this.videoPlayer.stop();
    }
}

