/*
 * Decompiled with CFR 0.152.
 */
package ui.webview;

import java.net.URL;

public enum WebViewType {
    CSDB("https://csdb.dk/"),
    CODEBASE64("https://codebase64.org/"),
    REMIX_KWED_ORG("https://remix.kwed.org/"),
    FORUM64_DE("https://www.forum64.de/"),
    LEMON64_COM("https://www.lemon64.com/"),
    SOASC("https://www.6581-8580.com/"),
    JSIDPLAY2_SRC("https://sourceforge.net/p/jsidplay2/code/HEAD/tree/trunk/jsidplay2/"),
    JSIDPLAY2_JAVADOC("jar:file:/index.html"),
    USERGUIDE("jar:file:/doc/UserGuide.html");

    private String url;

    private WebViewType(String url) {
        this.url = url;
    }

    public String getUrl() {
        if (this.url.startsWith("jar:file:")) {
            if (this == JSIDPLAY2_JAVADOC) {
                String userGuideUrl = WebViewType.USERGUIDE.url.replace("jar:file:", "");
                URL resource = ((Object)((Object)this)).getClass().getResource(userGuideUrl);
                String result = resource != null ? resource.toExternalForm() : "";
                int occurrence = (result = result.replace(userGuideUrl, "/index.html")).lastIndexOf("/jsidplay2-");
                if (occurrence != -1) {
                    result = result.substring(0, occurrence) + result.substring(occurrence).replace("/jsidplay2-", "/jsidplay2_doc-");
                }
                result = result.replace("-ui.jar", "-javadoc.jar");
                return result;
            }
            URL resource = ((Object)((Object)this)).getClass().getResource(this.url.replace("jar:file:", ""));
            String result = resource != null ? resource.toExternalForm() : "";
            return result;
        }
        return this.url;
    }

    public static String toAbsoluteUrl(String url) {
        if (url.startsWith("images/")) {
            return "/doc/" + url;
        }
        return url;
    }

    static class Constants {
        static final String JAR_URL = "jar:file:";
        static final String DOC_RESOURCE_DIR = "/doc/";
        static final String DOC_IMAGES_DIR = "images/";
        static final String JAVADOC_RESOURCE_DIR = "/";

        Constants() {
        }
    }
}

