/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum CfgCommand {
    RESET_USBSID(32),
    READ_CONFIG(48),
    APPLY_CONFIG(49),
    SET_CONFIG(50),
    SAVE_CONFIG(51),
    SAVE_NORESET(52),
    RESET_CONFIG(53),
    WRITE_CONFIG(54),
    READ_SOCKETCFG(55),
    RELOAD_CONFIG(56),
    READ_NUMSIDS(57),
    READ_FMOPLSID(58),
    SINGLE_SID(64),
    DUAL_SID(65),
    QUAD_SID(66),
    TRIPLE_SID(67),
    TRIPLE_SID_TWO(68),
    MIRRORED_SID(69),
    DUAL_SOCKET1(70),
    DUAL_SOCKET2(71),
    SET_CLOCK(80),
    DETECT_SIDS(81),
    TEST_ALLSIDS(82),
    TEST_SID1(83),
    TEST_SID2(84),
    TEST_SID3(85),
    TEST_SID4(86),
    GET_CLOCK(87),
    LOCK_CLOCK(88),
    STOP_TESTS(89),
    LOAD_MIDI_STATE(96),
    SAVE_MIDI_STATE(97),
    RESET_MIDI_STATE(99),
    USBSID_VERSION(128),
    US_PCB_VERSION(129),
    RESTART_BUS(133),
    RESTART_BUS_CLK(134),
    SYNC_PIOS(135),
    TOGGLE_AUDIO(136),
    SET_AUDIO(137);

    private int cmd;
    private static final Map<Integer, CfgCommand> lookup;

    private CfgCommand(int cmd) {
        this.cmd = cmd;
    }

    public int getCfgCommand() {
        return this.cmd;
    }

    public static CfgCommand get(int cmd) {
        return lookup.get(cmd);
    }

    static {
        lookup = Collections.unmodifiableMap(Arrays.asList(CfgCommand.values()).stream().collect(Collectors.toMap(CfgCommand::getCfgCommand, Function.identity())));
    }
}

