/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbPipe;

public class Device {
    private static byte US_CFG = 1;
    private static byte US_ITF = 1;
    private static byte US_EPOUT = (byte)2;
    private static byte US_EPIN = (byte)-126;
    private static short VENDOR_ID = (short)-13570;
    private static short PRODUCT_ID = (short)16401;
    private static boolean us_isOpen = false;
    private static UsbPipe pipe = null;
    public static UsbDevice device = null;
    private static UsbConfiguration configuration = null;
    private static UsbInterface iface = null;
    private static UsbEndpoint endpoint = null;
    static byte WRITE = 0;
    static byte READ = 1;
    static byte CYCLED_WRITE = (byte)2;
    static byte COMMAND = (byte)3;
    static byte PAUSE = (byte)10;
    static byte UNPAUSE = (byte)11;
    static byte MUTE = (byte)12;
    static byte UNMUTE = (byte)13;
    static byte RESET_SID = (byte)14;
    static byte DISABLE_SID = (byte)15;
    static byte ENABLE_SID = (byte)16;
    static byte CLEAR_BUS = (byte)17;
    static byte CONFIG = (byte)18;
    static byte RESET_MCU = (byte)19;
    static byte BOOTLOADER = (byte)20;

    public static boolean isOpen() {
        return us_isOpen;
    }

    public static void open_USBSID() throws UsbException {
        device = Device.find_USBSID(UsbHostManager.getUsbServices().getRootUsbHub());
        if (device == null) {
            System.err.println("USBSID-Pico not found");
            return;
        }
        configuration = device.getUsbConfiguration(US_CFG);
        iface = configuration.getUsbInterface(US_ITF);
        iface.claim(new UsbInterfacePolicy(){

            public boolean forceClaim(UsbInterface usbInterface) {
                return true;
            }
        });
        endpoint = iface.getUsbEndpoint(US_EPOUT);
        pipe = endpoint.getUsbPipe();
        pipe.open();
        us_isOpen = true;
    }

    public static void close_USBSID() throws UsbException {
        pipe.close();
        iface.release();
    }

    public static UsbDevice find_USBSID(UsbHub hub) throws UsbException {
        UsbDevice usbsidpico = null;
        for (UsbDevice device : hub.getAttachedUsbDevices()) {
            if (device.isUsbHub()) {
                usbsidpico = Device.find_USBSID((UsbHub)device);
                if (usbsidpico == null) continue;
                return usbsidpico;
            }
            UsbDeviceDescriptor desc = device.getUsbDeviceDescriptor();
            if (desc.idVendor() != VENDOR_ID || desc.idProduct() != PRODUCT_ID) continue;
            return device;
        }
        return null;
    }

    public static void asyncWrite(byte[] buffer) throws UsbException {
        pipe.asyncSubmit(buffer);
    }

    public static void syncWrite(byte[] buffer) throws UsbException {
        pipe.syncSubmit(buffer);
    }

    public static void sendCommand(int command) throws UsbException {
        byte[] message = new byte[3];
        message[0] = (byte)command;
        int sent = pipe.syncSubmit(message);
        System.out.println(sent + " bytes sent");
    }

    public static void sendConfigCommand(int command, int a, int b, int c, int d) throws UsbException {
        byte[] message = new byte[]{(byte)(COMMAND << 6 | CONFIG), (byte)command, (byte)a, (byte)b, (byte)c, (byte)d};
        int sent = pipe.syncSubmit(message);
        System.out.println(sent + " bytes sent");
    }
}

