/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import javax.usb.UsbException;
import usbsid.Device;
import usbsid.IUSBSID;

public class USBSID
extends Device
implements IUSBSID {
    @Override
    public int USBSID_init() {
        try {
            if (device != null && USBSID.isOpen()) {
                System.err.println("Device is already open!");
                return -1;
            }
            USBSID.open_USBSID();
            if (USBSID.isOpen()) {
                System.out.println("USBSID-Pico opened");
                return 0;
            }
            return -1;
        }
        catch (UsbException uE) {
            System.err.println("Exception occured: " + String.valueOf((Object)uE));
            return -1;
        }
    }

    @Override
    public void USBSID_exit() {
        try {
            if (device == null || !USBSID.isOpen()) {
                System.err.println("Device is not open!");
                return;
            }
            USBSID.close_USBSID();
            System.out.println("USBSID-Pico closed");
            return;
        }
        catch (UsbException uE) {
            System.err.println("Exception occured: " + String.valueOf((Object)uE));
            return;
        }
    }

    @Override
    public void USBSID_reset(byte volume) {
        try {
            if (device == null || !USBSID.isOpen()) {
                System.err.println("Device is not open!");
                return;
            }
            USBSID.sendCommand(RESET_SID);
        }
        catch (UsbException uE) {
            System.err.println("Exception occured: " + String.valueOf((Object)uE));
            return;
        }
    }

    @Override
    public void USBSID_clkdwrite(long cycles, byte addr, byte data) {
        try {
            byte[] buffer = new byte[5];
            byte cycles_hi = (byte)(cycles >> 8 & 0xFFFFFFFFFFFFFFFFL);
            byte cycles_lo = (byte)(cycles & 0xFFFFFFFFFFFFFFFFL);
            buffer[0] = (byte)(CYCLED_WRITE << 6);
            buffer[1] = addr;
            buffer[2] = data;
            buffer[3] = cycles_hi;
            buffer[4] = cycles_lo;
            USBSID.asyncWrite(buffer);
        }
        catch (UsbException uE) {
            System.err.println("Exception occured: " + String.valueOf((Object)uE));
            return;
        }
    }

    private void usleep(int delayUs) {
        int delayNs = delayUs * 1000;
        long start = System.nanoTime();
        long end = 0L;
        while (start + (long)delayNs >= (end = System.nanoTime())) {
        }
    }
}

