/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.PersistentUnknownKeyException;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.KeyPromptingCancelledException;
import net.java.truecommons.key.spec.prompting.PromptingKey;
import net.java.truecommons.key.spec.prompting.PromptingKeyProvider;
import net.java.truecommons.key.spec.util.SuspensionPenalty;
import net.java.truecommons.shed.UniqueObject;

@ThreadSafe
final class SharedKeyProvider<K extends PromptingKey<K>>
extends UniqueObject {
    private final ThreadLocal<Long> invalidated = new ThreadLocal();
    @Nullable
    private K key;
    @Nullable
    private PersistentUnknownKeyException exception;
    private volatile State state = State.RESET;
    private int count;

    SharedKeyProvider() {
    }

    synchronized void link() {
        ++this.count;
        assert (0 <= this.count);
    }

    synchronized void unlink() {
        if (0 >= --this.count) {
            this.resetUnconditionally();
        }
        assert (0 <= this.count);
    }

    synchronized void release() {
        this.resetCancelledKey();
    }

    K getKeyCloneForWriting(PromptingKeyProvider<K> provider) throws UnknownKeyException {
        this.setupKeyForWriting(provider);
        return this.getNonNullKeyClone();
    }

    private void setupKeyForWriting(PromptingKeyProvider<K> provider) throws UnknownKeyException {
        State os;
        State ns = this.state;
        do {
            os = ns;
            os.setupKeyForWriting(provider);
        } while ((ns = this.state) != os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    K getKeyCloneForReading(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
        if (invalid) {
            this.invalidated.set(System.currentTimeMillis());
        }
        try {
            this.setupKeyForReading(provider, invalid);
            Long invalidated = this.invalidated.get();
            SuspensionPenalty.enforce(null == invalidated ? 0L : invalidated);
        }
        catch (Throwable throwable) {
            Long invalidated = this.invalidated.get();
            SuspensionPenalty.enforce(null == invalidated ? 0L : invalidated);
            throw throwable;
        }
        return this.getNonNullKeyClone();
    }

    private void setupKeyForReading(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
        State os;
        State ns = this.state;
        do {
            os = ns;
            invalid = os.setupKeyForReading(provider, invalid);
        } while ((ns = this.state) != os);
    }

    private K getNonNullKeyClone() throws UnknownKeyException {
        K key = this.getKeyClone();
        if (null == key) {
            throw new UnknownKeyException();
        }
        return key;
    }

    @Nullable
    synchronized K getKeyClone() {
        K key = this.key;
        return (K)(null == key ? null : (PromptingKey)key.clone());
    }

    synchronized void setKeyClone(@Nullable K key) {
        K old = this.key;
        boolean set = null != key;
        this.key = set ? (PromptingKey)key.clone() : null;
        State state = this.state = set ? State.SET : State.CANCELLED;
        if (null != old) {
            old.reset();
        }
    }

    @Nullable
    synchronized PersistentUnknownKeyException getException() {
        return this.exception;
    }

    synchronized void setException(@Nullable PersistentUnknownKeyException exception) {
        this.exception = exception;
        if (null != this.exception) {
            this.setKeyClone(null);
        }
    }

    void resetCancelledKey() {
        this.state.resetCancelledKey(this);
    }

    synchronized void resetUnconditionally() {
        this.setKeyClone(null);
        this.setException(null);
        this.state = State.RESET;
    }

    synchronized boolean isChangeRequested() {
        return null != this.key && this.key.isChangeRequested();
    }

    private static enum State {
        RESET{

            @Override
            <K extends PromptingKey<K>> void setupKeyForWriting(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                provider.promptKeyForWriting();
            }

            @Override
            <K extends PromptingKey<K>> boolean setupKeyForReading(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                provider.promptKeyForReading(invalid);
                return false;
            }

            @Override
            <K extends PromptingKey<K>> void resetCancelledKey(SharedKeyProvider<K> provider) {
            }
        }
        ,
        SET{

            @Override
            <K extends PromptingKey<K>> void setupKeyForWriting(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                if (provider.isChangeRequested()) {
                    provider.resetUnconditionally();
                }
            }

            @Override
            <K extends PromptingKey<K>> boolean setupKeyForReading(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                if (invalid) {
                    provider.resetUnconditionally();
                }
                return invalid;
            }

            @Override
            <K extends PromptingKey<K>> void resetCancelledKey(SharedKeyProvider<K> provider) {
            }
        }
        ,
        CANCELLED{

            @Override
            <K extends PromptingKey<K>> void setupKeyForWriting(PromptingKeyProvider<K> provider) throws UnknownKeyException {
                throw this.exception(provider);
            }

            @Override
            <K extends PromptingKey<K>> boolean setupKeyForReading(PromptingKeyProvider<K> provider, boolean invalid) throws UnknownKeyException {
                throw this.exception(provider);
            }

            <K extends PromptingKey<K>> PersistentUnknownKeyException exception(PromptingKeyProvider<K> provider) {
                PersistentUnknownKeyException ex = provider.getException();
                if (null == ex) {
                    ex = new KeyPromptingCancelledException();
                    provider.setException(ex);
                }
                return ex;
            }

            @Override
            <K extends PromptingKey<K>> void resetCancelledKey(SharedKeyProvider<K> provider) {
                provider.resetUnconditionally();
            }
        };


        abstract <K extends PromptingKey<K>> void setupKeyForWriting(PromptingKeyProvider<K> var1) throws UnknownKeyException;

        abstract <K extends PromptingKey<K>> boolean setupKeyForReading(PromptingKeyProvider<K> var1, boolean var2) throws UnknownKeyException;

        abstract <K extends PromptingKey<K>> void resetCancelledKey(SharedKeyProvider<K> var1);
    }
}

