/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.io;

import com.xuggle.xuggler.io.IURLProtocolHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadableWritableChannelHandler
implements IURLProtocolHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final boolean CLOSE_STREAM_ON_CLOSE = true;
    private final ReadableByteChannel mReadChannel;
    private final WritableByteChannel mWriteChannel;
    private final boolean mCloseStreamOnClose;
    private Channel mOpenStream = null;

    public ReadableWritableChannelHandler(ReadableByteChannel channel) {
        this(channel, null, true);
    }

    public ReadableWritableChannelHandler(WritableByteChannel channel) {
        this(null, channel, true);
    }

    public ReadableWritableChannelHandler(ReadableByteChannel in, WritableByteChannel out, boolean closeStreamOnClose) {
        if (in == null && out == null) {
            throw new IllegalArgumentException("must pass one non null stream");
        }
        this.mReadChannel = in;
        this.mWriteChannel = out;
        this.mCloseStreamOnClose = closeStreamOnClose;
    }

    @Override
    public int close() {
        int retval = 0;
        try {
            if (this.mOpenStream != null && this.mCloseStreamOnClose) {
                this.mOpenStream.close();
            }
        }
        catch (IOException e) {
            this.log.error("could not close stream {}: {}", (Object)this.mOpenStream, (Object)e);
            retval = -1;
        }
        this.mOpenStream = null;
        return retval;
    }

    @Override
    public int open(String url, int flags) {
        if (this.mOpenStream != null) {
            this.log.debug("attempting to open already open handler: {}", (Object)this.mOpenStream);
            return -1;
        }
        switch (flags) {
            case 2: {
                this.log.debug("do not support read/write mode for Java IO Handlers");
                return -1;
            }
            case 1: {
                this.mOpenStream = this.mWriteChannel;
                if (this.mOpenStream != null) break;
                this.log.error("No OutputStream specified for writing: {}", (Object)url);
                return -1;
            }
            case 0: {
                this.mOpenStream = this.mReadChannel;
                if (this.mOpenStream != null) break;
                this.log.error("No InputStream specified for reading: {}", (Object)url);
                return -1;
            }
            default: {
                this.log.error("Invalid flag passed to open: {}", (Object)url);
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int read(byte[] buf, int size) {
        int ret = -1;
        if (this.mOpenStream == null || !(this.mOpenStream instanceof ReadableByteChannel)) {
            return -1;
        }
        try {
            ReadableByteChannel channel = (ReadableByteChannel)this.mOpenStream;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            ret = channel.read(buffer);
            if (ret > 0) {
                buffer.flip();
                buffer.get(buf, 0, ret);
            }
            return ret;
        }
        catch (IOException e) {
            this.log.error("Got IO exception reading from channel: {}; {}", (Object)this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public long seek(long offset, int whence) {
        return -1L;
    }

    @Override
    public int write(byte[] buf, int size) {
        if (this.mOpenStream == null || !(this.mOpenStream instanceof WritableByteChannel)) {
            return -1;
        }
        try {
            WritableByteChannel channel = (WritableByteChannel)this.mOpenStream;
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.put(buf, 0, size);
            buffer.flip();
            return channel.write(buffer);
        }
        catch (IOException e) {
            this.log.error("Got error writing to file: {}; {}", (Object)this.mOpenStream, (Object)e);
            return -1;
        }
    }

    @Override
    public boolean isStreamed(String url, int flags) {
        return true;
    }

    public ReadableByteChannel getReadChannel() {
        return this.mReadChannel;
    }

    public WritableByteChannel getWriteChannel() {
        return this.mWriteChannel;
    }

    public Channel getOpenChannel() {
        return this.mOpenStream;
    }

    public boolean isCloseStreamOnClose() {
        return this.mCloseStreamOnClose;
    }
}

