/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.triggers;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import java.io.Serializable;
import java.time.LocalDateTime;
import net.ucanaccess.complex.Version;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.triggers.TriggerBase;
import net.ucanaccess.triggers.TriggerException;
import net.ucanaccess.util.Logger;
import org.hsqldb.types.JavaObjectData;

public class TriggerAppendOnly
extends TriggerBase {
    public void fire(int type, String name, String tableName, Object[] oldR, Object[] newR) {
        this.checkContext();
        UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
        if (conn.isFeedbackState()) {
            return;
        }
        try {
            Table t = this.getTable(tableName, conn);
            if (t == null) {
                throw new RuntimeException(Logger.getMessage("TABLE_DOESNT_EXIST") + " :" + tableName);
            }
            int i = 0;
            for (Column cl : t.getColumns()) {
                if (cl.isAppendOnly()) {
                    String val;
                    ColumnImpl verCol = (ColumnImpl)cl.getVersionHistoryColumn();
                    LocalDateTime upTime = LocalDateTime.now();
                    String string = val = newR[i] == null ? null : newR[i].toString();
                    if (type == 6) {
                        newR[verCol.getColumnNumber()] = new JavaObjectData((Serializable)new Version[]{new Version(val, upTime)});
                    } else if (type == 8 && (oldR[i] != null || newR[i] != null) && (oldR[i] == null && newR[i] != null || oldR[i] != null && newR[i] == null || !oldR[i].equals(newR[i]))) {
                        Version[] oldV = (Version[])((JavaObjectData)oldR[verCol.getColumnNumber()]).getObject();
                        Version[] newV = new Version[oldV.length + 1];
                        for (int j = 0; j < oldV.length; ++j) {
                            newV[j + 1] = oldV[j];
                        }
                        newV[0] = new Version(val, upTime);
                        newR[verCol.getColumnNumber()] = new JavaObjectData((Serializable)newV);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new TriggerException(e.getMessage());
        }
    }
}

