/*
 * Decompiled with CFR 0.152.
 */
package build;

import client.teavm.common.parameter.event.ExportEventParameters;
import client.teavm.common.parameter.event.ImportEventParameters;
import client.teavm.common.parameter.usage.EventSchemaUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebServlet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import libsidutils.IOUtils;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TVFS;
import org.hsqldb.DatabaseManager;
import server.restful.JSIDPlay2Server;
import server.restful.common.parameter.ServletParameterHelper;
import server.restful.common.parameter.ServletsParameters;
import server.restful.common.parameter.usage.ServletsUsageFormatter;
import sidplay.Player;
import sidplay.ini.IniDefaults;
import sidplay.player.DebugUtil;
import ui.common.download.DownloadThread;
import ui.common.util.Extract7ZipUtil;
import ui.entities.DatabaseType;
import ui.entities.PersistenceProperties;
import ui.musiccollection.MusicCollectionType;
import ui.musiccollection.search.SearchIndexCreator;
import ui.musiccollection.search.SearchIndexerThread;

@Parameters(resourceBundle="build.OnlineContent")
public class OnlineContent {
    private static final String SERVLET_CLASSES_LIST = "src/main/resources/tomcat-servlets.list";
    private static final String FILTER_CLASSES_LIST = "src/main/resources/tomcat-filters.list";
    private static final String EVENT_PARAMETERS_TXT = "src/main/resources/server/restful/webapp/teavm/README_API";
    private static final String EVENT_JS_PATH = "src/main/resources/server/restful/webapp/teavm/event-api.js";
    private static final String SERVLETS_PARAMETERS_PATH = "src/main/asciidoc/restful-api.adoc";
    private static final String AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT;
    private static final int MAX_ZIP_FILESIZE = 0x2400000;
    private static final int CHUNK_SIZE = 0x100000;
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true, order=0)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--phase"}, descriptionKey="PHASE", order=1)
    private String phase;
    @Parameter(names={"--deployDir"}, descriptionKey="DEPLOY_DIR", order=2)
    private String deployDir;
    @Parameter(names={"--projectVersion"}, descriptionKey="PROJECT_VERSION", order=3)
    private String projectVersion;
    @Parameter(names={"--upxExe"}, descriptionKey="UPX_EXE", order=4)
    private String upxExe;
    @Parameter(names={"--baseDir"}, descriptionKey="BASE_DIR", order=5)
    private String baseDir;
    @Parameter(names={"--classesDir"}, descriptionKey="CLASSES_DIR", order=6)
    private String classesDir;
    @Parameter(names={"--gb64"}, descriptionKey="GB64", order=7)
    private String gb64;
    @Parameter(names={"--hvmec"}, descriptionKey="HVMEC", order=8)
    private String hvmec;
    @Parameter(names={"--cgsc"}, descriptionKey="CGSC", order=9)
    private String cgsc;
    @Parameter(names={"--hvsc"}, descriptionKey="HVSC", order=10)
    private String hvsc;
    private volatile boolean ready;

    private void execute(String[] args) throws Exception {
        JCommander commander = JCommander.newBuilder().addObject((Object)this).programName(this.getClass().getName()).build();
        commander.parse((String[])Arrays.asList(args).stream().map(arg -> arg == null ? "" : arg).toArray(String[]::new));
        if (this.help.booleanValue()) {
            commander.usage();
            System.out.println("Press <enter> to exit!");
            System.in.read();
            System.exit(0);
        }
        if ("prepare-package".equals(this.phase)) {
            List<String> servletParameterClassNames = this.createServerClzListAndCheck();
            this.createWebWorkerApiDocs();
            this.createServletApiDocs(servletParameterClassNames);
        } else if ("install".equals(this.phase)) {
            if (this.upxExe != null) {
                this.upx();
            }
            this.createDemos();
            if (this.gb64 != null) {
                this.gb64();
            }
            if (this.hvmec != null) {
                this.hvmec();
            }
            if (this.cgsc != null) {
                this.cgsc();
            }
            if (this.hvsc != null) {
                this.hvsc();
            }
            this.latestVersion();
        }
    }

    private void upx() throws IOException, InterruptedException {
        if (!new File(this.upxExe).exists() || !new File(this.upxExe).canExecute()) {
            System.err.println("Warning: UPX Program not found or not executable: " + this.upxExe);
            return;
        }
        Process proc = Runtime.getRuntime().exec(new String[]{this.upxExe, "--lzma", "--best", this.deployDir + "/jsiddevice-" + this.projectVersion + ".exe"});
        IOUtils.copy(proc.getErrorStream(), System.err);
        IOUtils.copy(proc.getInputStream(), System.out);
        proc.waitFor();
    }

    private void createDemos() throws IOException {
        new File(this.deployDir, "online/demos").mkdirs();
        File demosZipFile = new File(this.deployDir, "online/demos/Demos.zip");
        File source = new File(this.baseDir, "src/test/resources/demos/Demos.zip");
        Files.copy(Paths.get(source.toURI()), Paths.get(demosZipFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
        this.createCRC(demosZipFile, new File(this.deployDir, "online/demos/Demos.crc"));
    }

    private void gb64() throws IOException {
        File mdbFile = new File(this.gb64);
        if (mdbFile.exists()) {
            new File(this.deployDir, "online/gamebase").mkdirs();
            File mdbZipFile = new File(this.deployDir, "/online/gamebase/GameBase64.zip");
            mdbZipFile.delete();
            TFile.cp_rp((File)mdbFile, (File)new TFile(mdbZipFile, mdbFile.getName()), (TArchiveDetector)TArchiveDetector.ALL);
            TVFS.umount();
            this.createCRC(mdbZipFile, new File(this.deployDir, "online/gamebase/GameBase64.crc"));
        }
    }

    private void hvmec() throws IOException {
        File hvmecFile = new File(this.hvmec);
        if (hvmecFile.exists()) {
            new File(this.deployDir, "online/hvmec").mkdirs();
            File hvmecZipFile = new File(this.deployDir, "/online/hvmec/HVMEC.zip");
            hvmecZipFile.delete();
            TFile.cp_rp((File)hvmecFile, (File)hvmecZipFile, (TArchiveDetector)TArchiveDetector.ALL);
            TVFS.umount();
            this.createCRC(hvmecZipFile, new File(this.deployDir, "online/hvmec/HVMEC.crc"));
        }
    }

    private void cgsc() throws Exception {
        File cgsc7zFile = new File(this.cgsc);
        if (cgsc7zFile.exists()) {
            new File(this.deployDir, "online/cgsc").mkdirs();
            System.out.println("Extracting archive, please wait a moment...");
            File cgscZipFile = new File(this.deployDir, "/online/cgsc/CGSC.zip");
            Extract7ZipUtil extract7Zip = new Extract7ZipUtil(new File(this.cgsc), new File(this.deployDir, "online/cgsc"));
            extract7Zip.extract();
            cgscZipFile.delete();
            TFile.cp_rp((File)new File(this.deployDir, "online/cgsc/CGSC"), (File)new TFile(cgscZipFile), (TArchiveDetector)TArchiveDetector.ALL);
            TVFS.umount();
            IOUtils.deleteDirectory(new File(this.deployDir, "online/cgsc/CGSC"));
            this.createCRC(cgscZipFile, new File(this.deployDir, "online/cgsc/CGSC.crc"));
            this.doCreateIndex(MusicCollectionType.CGSC, cgscZipFile.getAbsolutePath());
        }
    }

    private void hvsc() throws Exception {
        File hvsc7zFile = new File(this.hvsc);
        if (hvsc7zFile.exists()) {
            new File(this.deployDir, "online/hvsc").mkdirs();
            System.out.println("Extracting archive, please wait a moment...");
            File hvscZipFile = new File(this.deployDir, "/online/hvsc/C64Music.zip");
            Extract7ZipUtil extract7Zip = new Extract7ZipUtil(new File(this.hvsc), new File(this.deployDir, "online/hvsc"));
            extract7Zip.extract();
            hvscZipFile.delete();
            TFile.cp_rp((File)new File(this.deployDir, "online/hvsc/C64Music"), (File)new TFile(hvscZipFile), (TArchiveDetector)TArchiveDetector.ALL);
            TVFS.umount();
            IOUtils.deleteDirectory(new File(this.deployDir, "online/hvsc/C64Music"));
            this.createCRC(hvscZipFile, new File(this.deployDir, "online/hvsc/C64Music.crc"));
            this.doCreateIndex(MusicCollectionType.HVSC, hvscZipFile.getAbsolutePath());
            this.doSplit(0x2400000, hvscZipFile.getAbsolutePath());
            hvscZipFile.delete();
        }
    }

    private void latestVersion() throws IOException, FileNotFoundException, UnsupportedEncodingException {
        File versionFile = new File(this.baseDir, "latest.properties");
        versionFile.delete();
        versionFile.createNewFile();
        try (PrintWriter writer = new PrintWriter(versionFile, StandardCharsets.ISO_8859_1.toString());){
            ((Writer)writer).append("version=" + this.projectVersion);
        }
    }

    private void doCreateIndex(MusicCollectionType collectionType, String zipFile) throws Exception {
        TFile rootFile = new TFile(zipFile);
        String persistenceUnitName = collectionType == MusicCollectionType.CGSC ? "cgsc-ds" : "hvsc-ds";
        File dbFilename = new File(rootFile.getParentFile(), collectionType.toString());
        EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)new PersistenceProperties(DatabaseType.HSQL_FILE, "", "", dbFilename.getAbsolutePath()));
        EntityManager em = emFactory.createEntityManager();
        Player player = new Player(IniDefaults.DEFAULTS);
        if (collectionType == MusicCollectionType.HVSC) {
            this.setSIDDatabase(player, (File)rootFile);
            this.setSTIL(player, (File)rootFile);
        }
        SearchIndexCreator searchIndexCreator = new SearchIndexCreator((File)rootFile, player, em);
        Consumer<Void> searchStart = v -> searchIndexCreator.getSearchStart().accept((Void)v);
        Consumer<File> searchHit = searchIndexCreator.getSearchHit();
        Consumer<Boolean> searchStop = cancelled -> {
            searchIndexCreator.getSearchStop().accept((Boolean)cancelled);
            this.ready = true;
        };
        this.ready = false;
        new SearchIndexerThread((File)rootFile, searchStart, searchHit, searchStop).start();
        System.out.println("Creating index, please wait a moment...");
        while (!this.ready) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while sleeping!");
            }
        }
        emFactory.close();
        DatabaseManager.closeDatabases((int)2);
    }

    private void setSTIL(Player player, File zipFile) throws NoSuchFieldException, IllegalAccessException {
        try {
            player.setSTIL(new STIL(zipFile));
        }
        catch (IOException e) {
            System.err.println("WARNING: STIL can not be read: " + e.getMessage());
        }
    }

    private void setSIDDatabase(Player player, File zipFile) {
        try {
            player.setSidDatabase(new SidDatabase(zipFile));
        }
        catch (IOException e) {
            System.err.println("WARNING: song length database can not be read: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSplit(int maxFileSize, String filename) throws IOException {
        int partNum = 1;
        String output = this.createOutputFilename(filename, partNum);
        byte[] buffer = new byte[0x100000];
        FilterOutputStream os = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(filename)), 0x100000);){
            int bytesRead = 0;
            int totalBytesRead = 0;
            os = this.createOutputStream(output);
            int len = Math.min(buffer.length, maxFileSize - totalBytesRead);
            while ((bytesRead = is.read(buffer, 0, len)) >= 0) {
                ((BufferedOutputStream)os).write(buffer, 0, bytesRead);
                len = Math.min(buffer.length, maxFileSize - (totalBytesRead += bytesRead));
                if (totalBytesRead != maxFileSize) continue;
                os.close();
                output = this.createOutputFilename(filename, ++partNum);
                os = this.createOutputStream(output);
                totalBytesRead = 0;
            }
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String createOutputFilename(String filename, int partNum) {
        return IOUtils.getFilenameWithoutSuffix(filename) + String.format(".%03d", partNum);
    }

    private BufferedOutputStream createOutputStream(String filename) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(new File(filename)), 0x100000);
    }

    private void createCRC(File demosZipFile, File crcFile) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        try (PrintWriter writer = new PrintWriter(crcFile, StandardCharsets.ISO_8859_1.toString());){
            Properties properties = new Properties();
            properties.setProperty("filename", demosZipFile.getName());
            properties.setProperty("size", String.valueOf(demosZipFile.length()));
            properties.setProperty("crc32", DownloadThread.calculateCRC32(demosZipFile));
            properties.store(writer, null);
        }
    }

    private List<String> createServerClzListAndCheck() throws IOException, SecurityException, ClassNotFoundException {
        Path base = new File(this.baseDir).toPath();
        final Path root = new File(this.classesDir).toPath();
        final ArrayList classNames = new ArrayList();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                String relPath = root.relativize(path).toFile().getPath();
                if (relPath.endsWith(".class")) {
                    classNames.add(IOUtils.getFilenameWithoutSuffix(relPath.replace(File.separatorChar, '.')));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(classNames, (s1, s2) -> s1.compareTo((String)s2));
        ArrayList<String> servletClassNames = new ArrayList<String>();
        ArrayList<String> servletParameterClassNames = new ArrayList<String>();
        ArrayList<String> filterClassNames = new ArrayList<String>();
        for (String clzName : classNames) {
            Class<?> clz = this.getClass().getClassLoader().loadClass(clzName);
            if (clz.isAnnotationPresent(WebServlet.class)) {
                servletClassNames.add(clzName);
            }
            if (clz.isAnnotationPresent(WebFilter.class)) {
                filterClassNames.add(clzName);
            }
            if (!clz.isAnnotationPresent(Parameters.class)) continue;
            if (clzName.startsWith(JSIDPlay2Server.class.getPackage().getName() + ".servlets")) {
                servletParameterClassNames.add(clzName);
                ServletParameterHelper.check(clz, true);
                continue;
            }
            for (Class cls : Arrays.asList(clz, clz.getEnclosingClass()).stream().filter(Objects::nonNull).collect(Collectors.toList())) {
                try {
                    cls.getMethod("main", String[].class);
                    ServletParameterHelper.check(clz, false);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        try (FileWriter servletsWriter = new FileWriter(base.resolve(SERVLET_CLASSES_LIST).toFile());){
            servletsWriter.write(String.format(AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT, new Object[0]));
            servletsWriter.write(new ObjectMapper().writeValueAsString(servletClassNames));
        }
        try (FileWriter filtersWriter = new FileWriter(base.resolve(FILTER_CLASSES_LIST).toFile());){
            filtersWriter.write(String.format(AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT, new Object[0]));
            filtersWriter.write(new ObjectMapper().writeValueAsString(filterClassNames));
        }
        return servletParameterClassNames;
    }

    private void createWebWorkerApiDocs() throws IOException, SecurityException, ClassNotFoundException {
        Locale originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Path base = new File(this.baseDir).toPath();
        try (PrintStream ps = new PrintStream(base.resolve(EVENT_PARAMETERS_TXT).toFile());){
            ps.print(String.format(AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT, new Object[0]));
            ExportEventParameters.usage((Console)new DefaultConsole(ps));
            ImportEventParameters.usage((Console)new DefaultConsole(ps));
        }
        ps = new PrintStream(base.resolve(EVENT_JS_PATH).toFile());
        try {
            ps.print(String.format(AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT, new Object[0]));
            ExportEventParameters.usage((Console)new DefaultConsole(ps), jCommander -> new EventSchemaUsageFormatter((JCommander)jCommander, true));
        }
        finally {
            ps.close();
        }
        Locale.setDefault(originalLocale);
    }

    private void createServletApiDocs(List<String> servletParameterClassNames) throws IOException, SecurityException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Locale originalLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Path base = new File(this.baseDir).toPath();
        try (PrintStream ps = new PrintStream(base.resolve(SERVLETS_PARAMETERS_PATH).toFile());){
            ps.print(String.format(AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT, new Object[0]));
            ServletsParameters.usage((Console)new DefaultConsole(ps), jCommander -> new ServletsUsageFormatter((JCommander)jCommander), servletParameterClassNames);
        }
        Locale.setDefault(originalLocale);
    }

    public static void main(String[] args) throws Exception {
        new OnlineContent().execute(args);
    }

    static {
        DebugUtil.init();
        System.setProperty("com.mysql.cj.disableAbandonedConnectionCleanup", "true");
        AUTO_GENERATED_BY_CLASS_BUILD_ONLINE_CONTENT = "// Code generated by " + OnlineContent.class + "; DO NOT EDIT.%n";
    }
}

