/*
 * Decompiled with CFR 0.152.
 */
package builder.hardsid;

import builder.hardsid.HardSID;
import builder.hardsid.HardSIDEmu;
import builder.hardsid.WState;
import builder.jhardsid.JHardSIDMapping;
import com.sun.jna.DefaultTypeMapper;
import com.sun.jna.Native;
import com.sun.jna.TypeConverter;
import com.sun.jna.platform.EnumConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.HardwareSIDBuilder;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SIDEmu;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public class HardSIDBuilder
implements HardwareSIDBuilder,
Mixer {
    private static final short REGULAR_DELAY = 512;
    private EventScheduler context;
    private IConfig config;
    private CPUClock cpuClock;
    private static HardSID hardSID;
    private static int deviceCount;
    private static String[] deviceNames;
    private static int chipCount;
    private byte deviceID;
    private List<HardSIDEmu> sids = new ArrayList<HardSIDEmu>();
    private long lastSIDWriteTime;
    private int fastForwardFactor;
    private int[] delayInCycles = new int[3];

    public HardSIDBuilder(EventScheduler context, IConfig config, CPUClock cpuClock) {
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        if (hardSID == null) {
            try {
                hardSID = (HardSID)Native.load((String)"hardsid", HardSID.class, this.createOptions());
            }
            catch (UnsatisfiedLinkError e) {
                System.err.println("Error: Windows, Linux or OSX is required to use " + (Object)((Object)Engine.HARDSID) + " soundcard!");
                HardSIDBuilder.printInstallationHint();
                throw e;
            }
        }
        hardSID.InitHardSID_Mapper();
        deviceCount = hardSID.HardSID_Devices();
        chipCount = hardSID.HardSID_SIDCount(this.deviceID);
        deviceNames = new String[chipCount];
        for (int i = 1; i <= chipCount; ++i) {
            HardSIDBuilder.deviceNames[i - 1] = "HardSID #" + i;
        }
    }

    @Override
    public void destroy() {
        if (hardSID != null) {
            hardSID.HardSID_Reset(this.deviceID);
            hardSID.HardSID_Uninitialize();
        }
    }

    private Map<String, Object> createOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("type-mapper", new DefaultTypeMapper(){
            {
                this.addTypeConverter(WState.class, (TypeConverter)new EnumConverter(WState.class));
            }
        });
        return options;
    }

    @Override
    public SIDEmu lock(SIDEmu oldHardSID, int sidNum, SidTune tune) {
        IAudioSection audioSection = this.config.getAudioSection();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
        ChipModel defaultSidModel = emulationSection.getDefaultSidModel();
        Set<Integer> alreadyInUse = this.sids.stream().map(sid -> sid.getChipNum()).map(Byte::intValue).collect(Collectors.toSet());
        Integer chipNum = JHardSIDMapping.getModelDependantChipNum(this.config.getEmulationSection(), chipCount, alreadyInUse, chipModel);
        if (oldHardSID != null) {
            return oldHardSID;
        }
        if (this.deviceID < deviceCount && chipNum != null && chipNum < chipCount) {
            HardSIDEmu sid2 = this.createSID(this.deviceID, chipNum, sidNum, tune, chipModel, defaultSidModel);
            sid2.lock();
            sid2.setFilterEnable(emulationSection, sidNum);
            sid2.setDigiBoost(emulationSection.isDigiBoosted8580());
            for (int voice = 0; voice < 4; ++voice) {
                sid2.setVoiceMute(voice, emulationSection.isMuteVoice(sidNum, voice));
            }
            this.sids.add(sid2);
            this.setDeviceName(sidNum, deviceNames[chipNum]);
            this.setDelay(sidNum, audioSection.getDelay(sidNum));
            return sid2;
        }
        System.err.printf("HARDSID ERROR: System doesn't have enough SID chips. Requested: (sidNum=%d)\n", sidNum);
        if (deviceCount == 0) {
            HardSIDBuilder.printInstallationHint();
        }
        return SIDEmu.NONE;
    }

    public static void printInstallationHint() {
        if (OS.get() == OS.WINDOWS) {
            HardSIDBuilder.printWindowsInstallationHint();
        } else if (OS.get() == OS.LINUX) {
            HardSIDBuilder.printLinuxInstallationHint();
        } else if (OS.get() == OS.MAC) {
            HardSIDBuilder.printMacInstallationHint();
        }
    }

    private static void printLinuxInstallationHint() {
        System.err.println("\"To give proper permissions, please type the following commands:\"");
        System.err.println("sudo vi /etc/udev/rules.d/92-hardsid4u.rules");
        System.err.println("\"Now, add the following single line:\"");
        System.err.println("SUBSYSTEM==\"usb\",ATTR{idVendor}==\"6581\",ATTR{idProduct}==\"8580\",MODE=\"0660\",GROUP=\"plugdev\"");
        System.err.println("\"And finally type this command to refresh device configuration:\"");
        System.err.println("sudo udevadm trigger");
        System.err.println("sudo chmod -R 777 /dev/bus/usb/");
        System.err.println("You are ready to start :-)");
    }

    private static void printMacInstallationHint() {
        System.err.println("Unknown things to do... N.Y.T");
        System.err.println("This should work out-of-the box!? Is a different device driver loaded?");
    }

    private static void printWindowsInstallationHint() {
        System.err.println("Go to \"Control Panel / Hardware / Device Manager\" and uninstall previous HardSID driver, and then reboot!");
        System.err.println("Now install Zadigs USB driver installation from that web-site: https://zadig.akeo.ie/");
        System.err.println("Click install for device (658x 8580) and WinUSB, where x=1-3. These settings were already proposed by the installer for me.");
        System.err.println("You are ready to start :-)");
    }

    @Override
    public void unlock(SIDEmu sidEmu) {
        HardSIDEmu hardSid = (HardSIDEmu)sidEmu;
        hardSid.unlock();
        this.sids.remove(sidEmu);
    }

    @Override
    public int getDeviceCount() {
        return chipCount;
    }

    public static String[] getDeviceNames() {
        return deviceNames;
    }

    @Override
    public Integer getDeviceId(int sidNum) {
        return sidNum < this.sids.size() ? Integer.valueOf(this.sids.get(sidNum).getChipNum()) : null;
    }

    @Override
    public String getDeviceName(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getDeviceName() : null;
    }

    public void setDeviceName(int sidNum, String serialNo) {
        if (sidNum < this.sids.size()) {
            this.sids.get(sidNum).setDeviceName(serialNo);
        }
    }

    @Override
    public ChipModel getDeviceChipModel(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getChipModel() : null;
    }

    @Override
    public void start() {
    }

    @Override
    public void fadeIn(double fadeIn) {
        System.err.println("Fade-in unsupported by HardSID");
    }

    @Override
    public void fadeOut(double fadeOut) {
        System.err.println("Fade-out unsupported by HardSID");
    }

    @Override
    public void setVolume(int sidNum, float volume) {
        System.err.println("Volume unsupported by HardSID");
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        System.err.println("Balance unsupported by HardSID");
    }

    public int getDelay(int sidNum) {
        return this.delayInCycles[sidNum];
    }

    @Override
    public void setDelay(int sidNum, int delay) {
        this.delayInCycles[sidNum] = (int)(this.cpuClock.getCpuFrequency() / 1000.0 * (double)delay);
    }

    @Override
    public void fastForward() {
        ++this.fastForwardFactor;
    }

    @Override
    public void normalSpeed() {
        this.fastForwardFactor = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.fastForwardFactor != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return (1 << this.fastForwardFactor) - 1;
    }

    @Override
    public void pause() {
        hardSID.HardSID_Flush(this.deviceID);
    }

    private HardSIDEmu createSID(byte deviceId, int chipNum, int sidNum, SidTune tune, ChipModel chipModel, ChipModel defaultChipModel) {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        if (SidTune.isFakeStereoSid(emulationSection, tune, sidNum)) {
            return new HardSIDEmu.FakeStereo(this, this.context, this.cpuClock, hardSID, deviceId, chipNum, sidNum, chipModel, defaultChipModel, this.sids, emulationSection);
        }
        return new HardSIDEmu(this, this.context, this.cpuClock, hardSID, deviceId, chipNum, sidNum, chipModel, defaultChipModel);
    }

    int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.fastForwardFactor;
    }

    long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 512) {
            this.lastSIDWriteTime += 512L;
            hardSID.HardSID_Delay(this.deviceID, (short)(512 >> this.fastForwardFactor));
        }
        return 512L;
    }
}

