/*
 * Decompiled with CFR 0.152.
 */
package builder.jhardsid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;

public class JHardSIDMapping {
    public static Map<Integer, String> mapping(IEmulationSection emulationSection, SidTune tune, int chipCount) {
        HashSet<Integer> alreadyInUse = new HashSet<Integer>();
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (int sidNum = 0; sidNum < 3; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            int address = SidTune.getSIDAddress(emulationSection, tune, sidNum);
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            Integer chipNum = JHardSIDMapping.getModelDependantChipNum(emulationSection, chipCount, alreadyInUse, chipModel);
            result.put(address, String.valueOf(chipNum));
            alreadyInUse.add(chipNum);
        }
        return result;
    }

    public static Integer getModelDependantChipNum(IEmulationSection emulationSection, int chipCount, Set<Integer> alreadyInUse, ChipModel chipModel) {
        int chipNum;
        int sid6581 = emulationSection.getHardsid6581();
        int sid8580 = emulationSection.getHardsid8580();
        for (chipNum = 0; chipNum < chipCount; ++chipNum) {
            if (JHardSIDMapping.isChipNumAlreadyUsed(alreadyInUse, chipNum) || !JHardSIDMapping.isChipModelMatching(emulationSection, chipModel, chipNum)) continue;
            return chipNum;
        }
        for (chipNum = 0; chipNum < chipCount; ++chipNum) {
            if (chipCount > 2 && (chipNum == sid6581 || chipNum == sid8580) || JHardSIDMapping.isChipNumAlreadyUsed(alreadyInUse, chipNum)) continue;
            return chipNum;
        }
        return null;
    }

    private static boolean isChipModelMatching(IEmulationSection emulationSection, ChipModel chipModel, int chipNum) {
        int sid6581 = emulationSection.getHardsid6581();
        int sid8580 = emulationSection.getHardsid8580();
        return chipNum == sid6581 && chipModel == ChipModel.MOS6581 || chipNum == sid8580 && chipModel == ChipModel.MOS8580;
    }

    private static boolean isChipNumAlreadyUsed(Set<Integer> alreadyInUse, int chipNum) {
        return alreadyInUse.contains(chipNum);
    }
}

