/*
 * Decompiled with CFR 0.152.
 */
package builder.jsidblaster;

import builder.jsidblaster.SIDBlasterEmu;
import builder.jsidblaster.SIDType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.HardwareSIDBuilder;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SIDEmu;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import sidblaster.hardsid.HardSID;
import sidblaster.hardsid.HardSIDImpl;

public class JSIDBlasterBuilder
implements HardwareSIDBuilder,
Mixer {
    private static final short REGULAR_DELAY = 512;
    private EventScheduler context;
    private IConfig config;
    private CPUClock cpuClock;
    private static HardSID hardSID;
    private static int deviceCount;
    private static String[] serialNumbers;
    private List<SIDBlasterEmu> sids = new ArrayList<SIDBlasterEmu>();
    private long lastSIDWriteTime;
    private int fastForwardFactor;
    private int[] delayInCycles = new int[3];

    public JSIDBlasterBuilder(EventScheduler context, IConfig config, CPUClock cpuClock) {
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        if (hardSID == null) {
            hardSID = new HardSIDImpl();
            this.init();
        }
    }

    private void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> JSIDBlasterBuilder.uninitialize()));
        deviceCount = hardSID.HardSID_Devices();
        hardSID.HardSID_SetWriteBufferSize((byte)this.config.getEmulationSection().getSidBlasterWriteBufferSize());
        serialNumbers = new String[deviceCount];
        for (byte deviceId = 0; deviceId < deviceCount; deviceId = (byte)(deviceId + 1)) {
            JSIDBlasterBuilder.serialNumbers[deviceId] = hardSID.HardSID_GetSerial(deviceId);
        }
    }

    public static void printInstallationHint() {
        if (OS.get() == OS.LINUX) {
            JSIDBlasterBuilder.printLinuxInstallationHint();
        }
        System.err.println("Maybe you just forgot to plug-in your USB devices?");
        System.err.println("Use the magic wand of the SIDBlaster combobox to configure your SIDBlaster devices!");
        System.err.println();
    }

    private static void printLinuxInstallationHint() {
        System.err.println("If device cannot be used, please use this workaround (we grant access to the USB device)...");
        System.err.println();
        System.err.println("... On Ubuntu you do:");
        System.err.println("$ sudo vi /etc/udev/rules.d/91-sidblaster.rules");
        System.err.println("ACTION==\"add\", ATTRS{idVendor}==\"0403\", ATTRS{idProduct}==\"6001\", MODE=\"0666\", RUN+=\"/bin/sh -c 'rmmod ftdi_sio && rmmod usbserial'\"");
        System.err.println("$ sudo udevadm control --reload-rules && sudo udevadm trigger");
        System.err.println("sudo chmod -R 777 /dev/bus/usb/");
        System.err.println();
        System.err.println("... and on Fedora you do:");
        System.err.println("$ sudo vi /etc/udev/rules.d/91-sidblaster.rules");
        System.err.println("ACTION==\"add\", ATTRS{idVendor}==\"0403\", ATTRS{idProduct}==\"6001\", MODE=\"0666\", RUN+=\"/bin/sh -c 'echo -n $id:1.0 > /sys/bus/usb/drivers/ftdi_sio/unbind; echo -n $id:1.1 > /sys/bus/usb/drivers/ftdi_sio/unbind'\"");
    }

    @Override
    public SIDEmu lock(SIDEmu oldHardSID, int sidNum, SidTune tune) {
        SIDBlasterEmu sid;
        IAudioSection audioSection = this.config.getAudioSection();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
        ChipModel defaultSidModel = emulationSection.getDefaultSidModel();
        AbstractMap.SimpleEntry<Integer, ChipModel> deviceIdAndChipModel = this.getModelDependantDeviceId(chipModel, sidNum, emulationSection.getSidBlasterSerialNumber());
        Integer deviceId = deviceIdAndChipModel.getKey();
        ChipModel model = deviceIdAndChipModel.getValue();
        if (oldHardSID != null) {
            return oldHardSID;
        }
        if (deviceId != null && deviceId < deviceCount && (sid = this.createSID(deviceId.byteValue(), sidNum, tune, model, defaultSidModel)).lock()) {
            sid.setFilterEnable(emulationSection, sidNum);
            sid.setDigiBoost(emulationSection.isDigiBoosted8580());
            for (int voice = 0; voice < 4; ++voice) {
                sid.setVoiceMute(voice, emulationSection.isMuteVoice(sidNum, voice));
            }
            this.sids.add(sid);
            this.setDeviceName(sidNum, serialNumbers[deviceId]);
            this.setDelay(sidNum, audioSection.getDelay(sidNum));
            this.setLatencyTimer(emulationSection.getSidBlasterLatencyTimer());
            return sid;
        }
        System.err.printf("SIDBLASTER ERROR: System doesn't have enough SID chips. Requested: (sidNum=%d)\n", sidNum);
        if (deviceCount == 0) {
            JSIDBlasterBuilder.printInstallationHint();
        }
        return SIDEmu.NONE;
    }

    @Override
    public void unlock(SIDEmu sidEmu) {
        SIDBlasterEmu sid = (SIDBlasterEmu)sidEmu;
        this.sids.remove(sid);
        sid.unlock();
    }

    @Override
    public int getDeviceCount() {
        return deviceCount;
    }

    public static String[] getSerialNumbers() {
        return serialNumbers;
    }

    public boolean isSidBlasterRead() {
        return this.config.getEmulationSection().isSidBlasterRead();
    }

    public static SIDType getSidType(int deviceId) {
        sidblaster.SIDType hardSID_GetSIDType = hardSID.HardSID_GetSIDType((byte)deviceId);
        return SIDType.to(hardSID_GetSIDType);
    }

    public static int setSidType(int deviceId, SIDType sidType) {
        sidblaster.SIDType hardSID_GetSIDType = SIDType.from(sidType);
        return hardSID.HardSID_SetSIDType((byte)deviceId, hardSID_GetSIDType);
    }

    public static int setSerial(int deviceId, String serialNo) {
        return hardSID.HardSID_SetSerial((byte)deviceId, serialNo);
    }

    public static void uninitialize() {
        if (hardSID != null) {
            hardSID.HardSID_Uninitialize();
        }
    }

    @Override
    public Integer getDeviceId(int sidNum) {
        return sidNum < this.sids.size() ? Integer.valueOf(this.sids.get(sidNum).getDeviceId()) : null;
    }

    @Override
    public String getDeviceName(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getDeviceName() : null;
    }

    public void setDeviceName(int sidNum, String serialNo) {
        if (sidNum < this.sids.size()) {
            this.sids.get(sidNum).setDeviceName(serialNo);
        }
    }

    @Override
    public ChipModel getDeviceChipModel(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getChipModel() : null;
    }

    @Override
    public void start() {
    }

    @Override
    public void fadeIn(double fadeIn) {
        System.err.println("Fade-in unsupported by SIDBlaster");
    }

    @Override
    public void fadeOut(double fadeOut) {
        System.err.println("Fade-out unsupported by SIDBlaster");
    }

    @Override
    public void setVolume(int sidNum, float volume) {
        System.err.println("Volume unsupported by SIDBlaster");
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        System.err.println("Balance unsupported by SIDBlaster");
    }

    public int getDelay(int sidNum) {
        return this.delayInCycles[sidNum];
    }

    @Override
    public void setDelay(int sidNum, int delay) {
        this.delayInCycles[sidNum] = (int)(this.cpuClock.getCpuFrequency() / 1000.0 * (double)delay);
    }

    public void setLatencyTimer(short ms) {
        hardSID.HardSID_SetLatencyTimer(ms);
    }

    @Override
    public void fastForward() {
        ++this.fastForwardFactor;
    }

    @Override
    public void normalSpeed() {
        this.fastForwardFactor = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.fastForwardFactor != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return (1 << this.fastForwardFactor) - 1;
    }

    @Override
    public void pause() {
        for (SIDBlasterEmu sid : this.sids) {
            hardSID.HardSID_Flush(sid.getDeviceId());
        }
    }

    private SIDBlasterEmu createSID(byte deviceId, int sidNum, SidTune tune, ChipModel chipModel, ChipModel defaultChipModel) {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        if (SidTune.isFakeStereoSid(emulationSection, tune, sidNum)) {
            return new SIDBlasterEmu.FakeStereo(this, this.context, this.cpuClock, hardSID, deviceId, sidNum, chipModel, defaultChipModel, this.sids, emulationSection);
        }
        return new SIDBlasterEmu(this, this.context, this.cpuClock, hardSID, deviceId, sidNum, chipModel, defaultChipModel);
    }

    private AbstractMap.SimpleEntry<Integer, ChipModel> getModelDependantDeviceId(ChipModel chipModel, int sidNum, String sidBlasterSerialNumber) {
        if (sidBlasterSerialNumber == null) {
            String serialNo;
            int deviceId;
            Map<String, ChipModel> deviceMap = this.config.getEmulationSection().getSidBlasterDeviceMap();
            for (deviceId = 0; deviceId < deviceCount; ++deviceId) {
                serialNo = serialNumbers[deviceId];
                if (this.isSerialNumAlreadyUsed(serialNo) || chipModel != deviceMap.get(serialNo)) continue;
                return new AbstractMap.SimpleEntry<Integer, ChipModel>(deviceId, chipModel);
            }
            for (deviceId = 0; deviceId < deviceCount; ++deviceId) {
                serialNo = serialNumbers[deviceId];
                if (this.isSerialNumAlreadyUsed(serialNo) || deviceMap.get(serialNo) == null) continue;
                return new AbstractMap.SimpleEntry<Integer, ChipModel>(deviceId, deviceMap.get(serialNo));
            }
        } else {
            for (int deviceId = 0; deviceId < deviceCount; ++deviceId) {
                if (!Objects.equals(serialNumbers[deviceId], sidBlasterSerialNumber)) continue;
                return new AbstractMap.SimpleEntry<Integer, ChipModel>(deviceId, chipModel);
            }
        }
        return new AbstractMap.SimpleEntry<Object, Object>(null, null);
    }

    private boolean isSerialNumAlreadyUsed(String serialNo) {
        return this.sids.stream().filter(sid -> Objects.equals(sid.getDeviceName(), serialNo)).findFirst().isPresent();
    }

    int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.fastForwardFactor;
    }

    long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 512) {
            this.lastSIDWriteTime += 512L;
            hardSID.HardSID_Delay((byte)0, (short)(512 >> this.fastForwardFactor));
        }
        return 512L;
    }
}

