/*
 * Decompiled with CFR 0.152.
 */
package builder.jsidblaster;

import builder.jsidblaster.JSIDBlasterBuilder;
import builder.resid.residfp.ReSIDfp;
import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import sidblaster.hardsid.HardSID;
import sidblaster.hardsid.WState;

public class SIDBlasterEmu
extends ReSIDfp {
    private final EventScheduler context;
    private final JSIDBlasterBuilder hardSIDBuilder;
    private final Event event;
    private final HardSID hardSID;
    private final byte deviceID;
    private String deviceName;
    private int sidNum;
    private final ChipModel chipModel;
    private boolean[] voiceMute = new boolean[4];
    private boolean[] filterDisable = new boolean[3];

    public SIDBlasterEmu(JSIDBlasterBuilder hardSIDBuilder, EventScheduler context, CPUClock cpuClock, HardSID hardSID, byte deviceId, int sidNum, ChipModel model, ChipModel defaultSidModel) {
        super(context);
        this.hardSIDBuilder = hardSIDBuilder;
        this.context = context;
        this.hardSID = hardSID;
        this.deviceID = deviceId;
        this.sidNum = sidNum;
        this.chipModel = model;
        this.event = Event.of("HardSID Delay", event -> context.schedule((Event)event, hardSIDBuilder.eventuallyDelay(), Event.Phase.PHI2));
        super.setChipModel(model == ChipModel.AUTO ? defaultSidModel : model);
        super.setClockFrequency(cpuClock.getCpuFrequency());
    }

    @Override
    public byte read(int addr) {
        byte emulatedRead = super.read(addr);
        if (this.hardSIDBuilder.isSidBlasterRead()) {
            short clocksSinceLastAccess = (short)this.hardSIDBuilder.clocksSinceLastAccess();
            return this.hardSID.HardSID_Read(this.deviceID, clocksSinceLastAccess, (byte)addr);
        }
        return emulatedRead;
    }

    @Override
    public void write(int addr, byte data) {
        short clocksSinceLastAccess = (short)this.hardSIDBuilder.clocksSinceLastAccess();
        switch (addr & 0x1F) {
            case 4: 
            case 11: 
            case 18: {
                if (this.voiceMute[(addr - 4) / 7]) {
                    data = (byte)(data & 0xFE);
                }
                super.write(addr, data);
                break;
            }
            case 23: {
                if (this.filterDisable[this.sidNum]) {
                    data = (byte)(data & 0xF0);
                }
                super.write(addr, data);
                break;
            }
            case 24: {
                if (this.voiceMute[3] && (data & 0xF) < (this.readInternalRegister(addr) & 0xF)) {
                    return;
                }
                super.write(addr, data);
                break;
            }
            default: {
                super.write(addr, data);
            }
        }
        byte dataByte = data;
        this.doWriteDelayed(() -> {
            while (this.hardSID.HardSID_Try_Write(this.deviceID, clocksSinceLastAccess, (byte)addr, dataByte) == WState.BUSY) {
            }
        });
    }

    private void doWriteDelayed(Runnable runnable) {
        if (this.hardSIDBuilder.getDelay(this.sidNum) > 0) {
            this.context.schedule(Event.of("Delayed SID output", event -> runnable.run()), this.hardSIDBuilder.getDelay(this.sidNum));
        } else {
            runnable.run();
        }
    }

    protected boolean lock() {
        boolean locked = this.hardSID.HardSID_Lock(this.deviceID);
        if (locked) {
            this.hardSID.HardSID_Reset(this.deviceID);
            this.reset((byte)15);
            this.context.schedule(this.event, 0L, Event.Phase.PHI2);
        }
        return locked;
    }

    protected void unlock() {
        this.hardSID.HardSID_Reset(this.deviceID);
        this.reset((byte)0);
        this.context.cancel(this.event);
        this.hardSID.HardSID_Unlock(this.deviceID);
    }

    @Override
    public void setVoiceMute(int num, boolean mute) {
        super.setVoiceMute(num, mute);
        if (num < 4) {
            this.voiceMute[num] = mute;
        }
    }

    @Override
    public void setFilterEnable(IEmulationSection emulation, int sidNum) {
        super.setFilterEnable(emulation, sidNum);
        this.filterDisable[sidNum] = !emulation.isFilterEnable(sidNum);
    }

    public byte getDeviceId() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    protected ChipModel getChipModel() {
        return this.chipModel;
    }

    public static final String credits() {
        StringBuffer credits = new StringBuffer();
        credits.append("SIDBlaster Java version by Ken H\u00e4ndel <kschwiersch@yahoo.de> Copyright (\u00a9) 2020\n");
        credits.append("\tSupported by SIDBlaster-USB TicTac Edition (Andreas Schumm)\n");
        credits.append("\thttp://crazy-midi.de\n");
        credits.append("\tBased on SIDBlaster-USB by Davey (Das Phantom)\n");
        credits.append("\tDLL created by Stein Pedersen\n");
        credits.append("\tSIDBlaster test song by Hannes Malecki (Honey) of Welle: Erdball\n");
        return credits.toString();
    }

    public static class FakeStereo
    extends SIDBlasterEmu {
        private final IEmulationSection emulationSection;
        private final int prevNum;
        private final List<SIDBlasterEmu> sids;

        public FakeStereo(JSIDBlasterBuilder hardSIDBuilder, EventScheduler context, CPUClock cpuClock, HardSID hardSID, byte deviceId, int sidNum, ChipModel model, ChipModel defaultChipModel, List<SIDBlasterEmu> sids, IEmulationSection emulationSection) {
            super(hardSIDBuilder, context, cpuClock, hardSID, deviceId, sidNum, model, defaultChipModel);
            this.prevNum = sidNum - 1;
            this.sids = sids;
            this.emulationSection = emulationSection;
        }

        @Override
        public byte read(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).read(addr);
            }
            return super.read(addr);
        }

        @Override
        public byte readInternalRegister(int addr) {
            if (this.emulationSection.getSidToRead().getSidNum() <= this.prevNum) {
                return this.sids.get(this.prevNum).readInternalRegister(addr);
            }
            return super.readInternalRegister(addr);
        }

        @Override
        public void write(int addr, byte data) {
            super.write(addr, data);
            this.sids.get(this.prevNum).write(addr, data);
        }
    }
}

