/*
 * Decompiled with CFR 0.152.
 */
package builder.jusbsid;

import builder.jusbsid.USBSIDEmu;
import java.util.ArrayList;
import java.util.List;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.HardwareSIDBuilder;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SIDEmu;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.sidtune.SidTune;
import usbsid.USBSID;

public class JUSBSIDBuilder
implements HardwareSIDBuilder,
Mixer {
    private static final short REGULAR_DELAY = 512;
    private EventScheduler context;
    private IConfig config;
    private CPUClock cpuClock;
    private static USBSID usbsid;
    private static int deviceCount;
    private static String[] deviceNames;
    private List<USBSIDEmu> sids = new ArrayList<USBSIDEmu>();
    private long lastSIDWriteTime;
    private int fastForwardFactor;
    private int[] delayInCycles = new int[3];
    protected int lastSidNum = -1;

    public JUSBSIDBuilder(EventScheduler context, IConfig config, CPUClock cpuClock) {
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        if (usbsid == null) {
            usbsid = new USBSID();
            this.init();
        }
    }

    private void init() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> usbsid.USBSID_exit()));
        if (usbsid.USBSID_init() < 0) {
            deviceNames = new String[0];
            return;
        }
        String hardwareRevision = "1.0";
        String firmwareVersion = "4.0";
        deviceCount = 2;
        deviceNames = new String[deviceCount];
        JUSBSIDBuilder.deviceNames[0] = "1.0 4.0 #1";
        JUSBSIDBuilder.deviceNames[1] = "1.0 4.0 #2";
    }

    public static void printInstallationHint() {
        if (OS.get() == OS.LINUX) {
            JUSBSIDBuilder.printLinuxInstallationHint();
        }
    }

    private static void printLinuxInstallationHint() {
        System.err.println("\"To give proper permissions, please type the following commands:\"");
        System.err.println("sudo vi /etc/udev/rules.d/92-usbsid.rules");
        System.err.println("\"Now, add the following single line:\"");
        System.err.println("SUBSYSTEM==\"usb\",ATTR{idVendor}==\"6581\",ATTR{idProduct}==\"8580\",MODE=\"0660\",GROUP=\"plugdev\"");
        System.err.println("\"And finally type this command to refresh device configuration:\"");
        System.err.println("sudo udevadm trigger");
        System.err.println("You are ready to start :-)");
    }

    @Override
    public SIDEmu lock(SIDEmu oldSIDEmu, int sidNum, SidTune tune) {
        USBSIDEmu sid;
        Integer deviceId;
        IAudioSection audioSection = this.config.getAudioSection();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
        ChipModel defaultSidModel = emulationSection.getDefaultSidModel();
        boolean stereo = SidTune.isSIDUsed(emulationSection, tune, 1);
        if (oldSIDEmu != null) {
            return oldSIDEmu;
        }
        if (sidNum == 1 && this.sids.get(0).getChipModel() == chipModel) {
            ChipModel chipModel2 = chipModel = chipModel == ChipModel.MOS6581 ? ChipModel.MOS8580 : ChipModel.MOS6581;
        }
        if ((deviceId = Integer.valueOf(sidNum)) < deviceCount && (sid = this.createSID(deviceId.byteValue(), sidNum, tune, chipModel, defaultSidModel, stereo)).lock()) {
            sid.setFilterEnable(emulationSection, sidNum);
            sid.setDigiBoost(emulationSection.isDigiBoosted8580());
            for (int voice = 0; voice < 4; ++voice) {
                sid.setVoiceMute(voice, emulationSection.isMuteVoice(sidNum, voice));
            }
            this.sids.add(sid);
            this.setDeviceName(sidNum, deviceNames[deviceId]);
            this.setDelay(sidNum, audioSection.getDelay(sidNum));
            return sid;
        }
        System.err.printf("USBSID ERROR: System doesn't have enough SID chips. Requested: (sidNum=%d)\n", sidNum);
        if (deviceCount == 0) {
            JUSBSIDBuilder.printInstallationHint();
        }
        return SIDEmu.NONE;
    }

    @Override
    public void unlock(SIDEmu sidEmu) {
        USBSIDEmu sid = (USBSIDEmu)sidEmu;
        this.sids.remove(sid);
        sid.unlock();
    }

    @Override
    public int getDeviceCount() {
        return deviceCount;
    }

    public static String[] getDeviceNames() {
        return deviceNames;
    }

    @Override
    public Integer getDeviceId(int sidNum) {
        return sidNum < this.sids.size() ? Integer.valueOf(this.sids.get(sidNum).getDeviceId()) : null;
    }

    @Override
    public String getDeviceName(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getDeviceName() : null;
    }

    public void setDeviceName(int sidNum, String serialNo) {
        if (sidNum < this.sids.size()) {
            this.sids.get(sidNum).setDeviceName(serialNo);
        }
    }

    @Override
    public ChipModel getDeviceChipModel(int sidNum) {
        return sidNum < this.sids.size() ? this.sids.get(sidNum).getChipModel() : null;
    }

    @Override
    public void start() {
    }

    @Override
    public void fadeIn(double fadeIn) {
        System.err.println("Fade-in unsupported by USBSID");
    }

    @Override
    public void fadeOut(double fadeOut) {
        System.err.println("Fade-out unsupported by USBSID");
    }

    @Override
    public void setVolume(int sidNum, float volume) {
        System.err.println("Volume unsupported by USBSID");
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        System.err.println("Balance unsupported by USBSID");
    }

    public int getDelay(int sidNum) {
        return this.delayInCycles[sidNum];
    }

    @Override
    public void setDelay(int sidNum, int delay) {
        this.delayInCycles[sidNum] = (int)(this.cpuClock.getCpuFrequency() / 1000.0 * (double)delay);
    }

    @Override
    public void fastForward() {
        ++this.fastForwardFactor;
    }

    @Override
    public void normalSpeed() {
        this.fastForwardFactor = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.fastForwardFactor != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return (1 << this.fastForwardFactor) - 1;
    }

    @Override
    public void pause() {
    }

    private USBSIDEmu createSID(byte deviceId, int sidNum, SidTune tune, ChipModel chipModel, ChipModel defaultChipModel, boolean stereo) {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        if (SidTune.isFakeStereoSid(emulationSection, tune, sidNum)) {
            return new USBSIDEmu.FakeStereo(this, this.context, this.cpuClock, usbsid, deviceId, sidNum, chipModel, defaultChipModel, stereo, this.sids, emulationSection);
        }
        return new USBSIDEmu(this, this.context, this.cpuClock, usbsid, deviceId, sidNum, chipModel, defaultChipModel, stereo);
    }

    int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.fastForwardFactor;
    }

    long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 512) {
            this.lastSIDWriteTime += 512L;
        }
        return 512L;
    }
}

