/*
 * Decompiled with CFR 0.152.
 */
package builder.netsiddev;

import builder.netsiddev.NetSIDDevConnection;
import builder.netsiddev.commands.Flush;
import builder.netsiddev.commands.GetConfigCount;
import builder.netsiddev.commands.GetConfigInfo;
import builder.netsiddev.commands.GetVersion;
import builder.netsiddev.commands.NetSIDPkg;
import builder.netsiddev.commands.TryDelay;
import builder.netsiddev.commands.TryRead;
import builder.netsiddev.commands.TryReset;
import builder.netsiddev.commands.TrySetSidCount;
import builder.netsiddev.commands.TrySetSidModel;
import builder.netsiddev.commands.TryWrite;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import libsidplay.common.ChipModel;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.config.IEmulationSection;
import server.netsiddev.Response;

public class NetSIDClient {
    private static final int CYCLES_TO_MILLIS = 1000;
    private static final int MAX_WRITE_CYCLES = 4096;
    private static final int MAX_BUFFER_SIZE = 4096;
    private static final int BUFFER_NEAR_FULL = 3072;
    private static final int REGULAR_DELAY = 1024;
    private NetSIDDevConnection connection = NetSIDDevConnection.getInstance();
    private static byte version;
    private final EventScheduler context;
    private final List<NetSIDPkg> commands = new ArrayList<NetSIDPkg>(4096);
    private TryWrite tryWrite = new TryWrite();
    private byte readResult;
    private String configName;
    private long lastSIDWriteTime;
    private int fastForwardFactor;
    private final Event event;

    public NetSIDClient(EventScheduler context, IEmulationSection emulationSection) {
        this.context = context;
        this.event = Event.of("JSIDDevice Delay", event -> context.schedule((Event)event, this.eventuallyDelay((byte)0), Event.Phase.PHI2));
        boolean wasNotConnectedYet = this.connection.isDisconnected();
        try {
            this.connection.open(emulationSection.getNetSIDDevHost(), emulationSection.getNetSIDDevPort());
        }
        catch (IOException e) {
            this.connection.close();
            System.err.printf("Creating connection for %s:%d failed!\n", emulationSection.getNetSIDDevHost(), emulationSection.getNetSIDDevPort());
            throw new RuntimeException(e.getMessage());
        }
        if (TrySetSidModel.getFilterToSidModel().isEmpty() || wasNotConnectedYet) {
            version = this.sendReceive(new GetVersion());
            TrySetSidModel.getFilterToSidModel().clear();
            for (byte config = 0; config < this.sendReceive(new GetConfigCount()); config = (byte)(config + 1)) {
                AbstractMap.SimpleImmutableEntry<ChipModel, String> filter = this.sendReceiveConfig(new GetConfigInfo(config));
                TrySetSidModel.getFilterToSidModel().put(filter, config);
            }
            this.addSetSidModels();
            this.softFlush();
        }
    }

    public byte getVersion() {
        return version;
    }

    private void addSetSidModels() {
        this.commands.add(new TrySetSidCount(3));
        for (byte sidNum = 0; sidNum < 3; sidNum = (byte)(sidNum + 1)) {
            this.commands.add(new TrySetSidModel(sidNum, 0));
        }
    }

    public void init(byte volume) {
        this.clocksSinceLastAccess();
        this.commands.clear();
        this.add(new Flush());
        this.add(new TryReset(volume));
    }

    public byte read(byte sidNum, byte addr) {
        return this.tryRead(sidNum, this.clocksSinceLastAccess() >> this.fastForwardFactor, addr);
    }

    public void write(byte sidNum, byte addr, byte data) {
        try {
            int clocksSinceLastAccess = this.clocksSinceLastAccess();
            while (this.tryWrite(sidNum, clocksSinceLastAccess >> this.fastForwardFactor, addr, data) == Response.BUSY) {
            }
        }
        catch (IOException | InterruptedException e) {
            this.connection.close();
            throw new RuntimeException(e);
        }
    }

    private AbstractMap.SimpleImmutableEntry<ChipModel, String> sendReceiveConfig(NetSIDPkg cmd) {
        this.addAndSend(cmd);
        return new AbstractMap.SimpleImmutableEntry<ChipModel, String>(this.readResult == 1 ? ChipModel.MOS8580 : ChipModel.MOS6581, "Filter" + this.configName);
    }

    private byte sendReceive(NetSIDPkg cmd) {
        this.addAndSend(cmd);
        return this.readResult;
    }

    final void addAndSend(NetSIDPkg cmd) {
        this.softFlush();
        this.add(cmd);
        this.softFlush();
    }

    final boolean add(NetSIDPkg cmd) {
        return this.commands.add(cmd);
    }

    void softFlush() {
        try {
            this.flush(false);
        }
        catch (IOException | InterruptedException e) {
            this.connection.close();
            throw new RuntimeException(e);
        }
    }

    private byte tryRead(byte sidNum, int cycles, byte addr) {
        this.tryWrite = !this.commands.isEmpty() && this.commands.get(0) instanceof TryWrite ? new TryRead((TryWrite)this.commands.remove(0), sidNum, cycles, addr) : new TryRead(sidNum, cycles, addr);
        return this.sendReceive(this.tryWrite);
    }

    private Response tryWrite(byte sidNum, int cycles, byte reg, byte data) throws InterruptedException, IOException {
        if (this.maybeSendWritesToServer() == Response.BUSY) {
            this.sleepDependingOnCyclesSent();
            return Response.BUSY;
        }
        if (this.commands.isEmpty()) {
            this.tryWrite = new TryWrite();
            this.commands.add(this.tryWrite);
        }
        this.tryWrite.addWrite(cycles, (byte)(sidNum << 5 | reg), data);
        this.maybeSendWritesToServer();
        return Response.OK;
    }

    private Response flush(boolean giveUpIfBusy) throws IOException, InterruptedException {
        block6: while (!this.commands.isEmpty()) {
            NetSIDPkg cmd = this.commands.remove(0);
            this.connection.send(cmd.toByteArrayWithLength());
            byte rc = this.readResponse();
            switch (Response.values()[rc]) {
                case VERSION: 
                case READ: 
                case COUNT: {
                    this.readResult = this.readResponse();
                }
                case OK: {
                    continue block6;
                }
                case BUSY: {
                    this.commands.add(0, cmd);
                    if (giveUpIfBusy) {
                        return Response.BUSY;
                    }
                    this.sleepDependingOnCyclesSent();
                    continue block6;
                }
                case INFO: {
                    this.readResult = this.readResponse();
                    this.configName = this.connection.receiveString();
                    continue block6;
                }
            }
            this.connection.close();
            throw new RuntimeException("Server error: Unexpected response: " + rc);
        }
        return Response.OK;
    }

    private byte readResponse() throws IOException {
        int rc = this.connection.receive();
        if (rc == -1) {
            this.connection.close();
            throw new RuntimeException("Server closed the connection!");
        }
        return (byte)rc;
    }

    private void sleepDependingOnCyclesSent() throws InterruptedException {
        if (this.tryWrite.getCyclesSendToServer() > 3072) {
            Thread.sleep(this.tryWrite.getCyclesSendToServer() / 1000 - 3);
        }
    }

    private Response maybeSendWritesToServer() throws IOException, InterruptedException {
        if ((this.commands.size() >= 4096 || this.tryWrite.getCyclesSendToServer() >= 4096) && this.flush(true) == Response.BUSY) {
            return Response.BUSY;
        }
        return Response.OK;
    }

    private int clocksSinceLastAccess() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff;
    }

    private long eventuallyDelay(byte sidNum) {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 1024) {
            this.lastSIDWriteTime += 1024L;
            this.addAndSend(new TryDelay(sidNum, 1024 >> this.fastForwardFactor));
        }
        return 1024L;
    }

    public void start() {
        this.context.schedule(this.event, 0L, Event.Phase.PHI2);
    }

    public void fastForward() {
        ++this.fastForwardFactor;
    }

    public void normalSpeed() {
        this.fastForwardFactor = 0;
    }

    public boolean isFastForward() {
        return this.fastForwardFactor != 0;
    }

    public int getFastForwardBitMask() {
        return (1 << this.fastForwardFactor) - 1;
    }
}

