/*
 * Decompiled with CFR 0.152.
 */
package builder.resid;

import builder.resid.ReSIDBase;
import builder.resid.SampleMixer;
import builder.resid.resample.Resampler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SamplingMethod;
import libsidplay.components.cart.Cartridge;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.IWhatsSidSection;
import sidplay.audio.AudioDriver;
import sidplay.audio.processors.AudioProcessor;
import sidplay.audio.processors.delay.DelayProcessor;
import sidplay.audio.processors.reverb.ReverbProcessor;
import sidplay.fingerprinting.WhatsSidSupport;

public class SIDMixer
implements Mixer {
    static final int VOLUME_SCALER = 10;
    protected final EventScheduler context;
    protected final IConfig config;
    protected final CPUClock cpuClock;
    protected final List<ReSIDBase> sids = new ArrayList<ReSIDBase>(3);
    private Cartridge cart;
    private final MixerEvent mixerAudio = new MixerEvent("MixerAudio");
    private IntBuffer audioBufferL;
    private IntBuffer audioBufferR;
    private int bufferSize;
    private int[] emptyBuffer;
    private final Resampler resamplerL;
    private final Resampler resamplerR;
    private AudioDriver audioDriver;
    private final int[] volume = new int[3];
    private final float[] positionL = new float[3];
    private final float[] positionR = new float[3];
    private final int[] delayInSamples = new int[3];
    private final boolean fadeInFadeOutEnabled;
    private boolean whatsSidEnabled;
    private final WhatsSidSupport whatsSidSupport;
    private List<AudioProcessor> audioProcessors = new ArrayList<AudioProcessor>();
    private ByteBuffer buffer;

    public SIDMixer(EventScheduler context, IConfig config, CPUClock cpuClock, Cartridge cart) {
        ISidPlay2Section sidplay2Section = config.getSidplay2Section();
        IAudioSection audioSection = config.getAudioSection();
        IWhatsSidSection whatsSidSection = config.getWhatsSidSection();
        double cpuFrequency = cpuClock.getCpuFrequency();
        SamplingMethod samplingMethod = audioSection.getSampling();
        int samplingFrequency = audioSection.getSamplingRate().getFrequency();
        int middleFrequency = audioSection.getSamplingRate().getMiddleFrequency();
        this.context = context;
        this.config = config;
        this.cpuClock = cpuClock;
        this.cart = cart;
        this.resamplerL = Resampler.createResampler(cpuFrequency, samplingMethod, samplingFrequency, middleFrequency);
        this.resamplerR = Resampler.createResampler(cpuFrequency, samplingMethod, samplingFrequency, middleFrequency);
        this.fadeInFadeOutEnabled = sidplay2Section.getFadeInTime() != 0.0 || sidplay2Section.getFadeOutTime() != 0.0;
        this.audioProcessors.add(new DelayProcessor(config));
        this.audioProcessors.add(new ReverbProcessor(config));
        if (cart instanceof AudioProcessor) {
            this.audioProcessors.add((AudioProcessor)((Object)cart));
        }
        this.whatsSidEnabled = whatsSidSection.isEnable();
        this.whatsSidSupport = new WhatsSidSupport(cpuFrequency, whatsSidSection.getCaptureTime(), whatsSidSection.getMinimumRelativeConfidence());
        this.normalSpeed();
    }

    public void setAudioDriver(AudioDriver audioDriver) {
        IAudioSection audioSection = this.config.getAudioSection();
        this.audioDriver = audioDriver;
        this.bufferSize = audioSection.getBufferSize();
        this.emptyBuffer = new int[this.bufferSize];
        this.buffer = audioDriver.buffer();
        this.audioBufferL = ByteBuffer.allocateDirect(4 * this.bufferSize).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.audioBufferR = ByteBuffer.allocateDirect(4 * this.bufferSize).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.cart.setSampler(this.createSampleMixer(this.audioBufferL.duplicate(), this.audioBufferR.duplicate()));
    }

    @Override
    public void start() {
        this.context.schedule(this.mixerAudio, 0L, Event.Phase.PHI2);
        this.cart.mixerStart();
        for (ReSIDBase sid : this.sids) {
            sid.clocksSinceLastAccess();
        }
    }

    @Override
    public void fadeIn(double fadeIn) {
        for (ReSIDBase sid : this.sids) {
            SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)sid.getSampler();
            sampler.setFadeIn((long)(fadeIn * this.cpuClock.getCpuFrequency()));
        }
        SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)this.cart.getSampler();
        sampler.setFadeIn((long)(fadeIn * this.cpuClock.getCpuFrequency()));
    }

    @Override
    public void fadeOut(double fadeOut) {
        for (ReSIDBase sid : this.sids) {
            SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)sid.getSampler();
            sampler.setFadeOut((long)(fadeOut * this.cpuClock.getCpuFrequency()));
        }
        SampleMixer.LinearFadingSampleMixer sampler = (SampleMixer.LinearFadingSampleMixer)this.cart.getSampler();
        sampler.setFadeOut((long)(fadeOut * this.cpuClock.getCpuFrequency()));
    }

    public void add(int sidNum, ReSIDBase sid) {
        if (sidNum < this.sids.size()) {
            this.sids.set(sidNum, sid);
        } else {
            this.sids.add(sid);
        }
        sid.setSampler(this.createSampleMixer(this.audioBufferL.duplicate(), this.audioBufferR.duplicate()));
        this.setVolume(sidNum, this.config.getAudioSection().getVolume(sidNum));
        this.setBalance(sidNum, this.config.getAudioSection().getBalance(sidNum));
        this.setDelay(sidNum, this.config.getAudioSection().getDelay(sidNum));
    }

    public void remove(ReSIDBase sid) {
        this.sids.remove(sid);
        sid.setSampler(null);
        this.updateSampleMixerVolume();
    }

    @Override
    public void setVolume(int sidNum, float volumeInDB) {
        assert (volumeInDB >= -6.0f && volumeInDB <= 6.0f);
        this.volume[sidNum] = (int)(Math.pow(10.0, (double)SIDMixer.decibelsToCentibels(volumeInDB) / 100.0) * 1024.0);
        this.updateSampleMixerVolume();
    }

    public static int decibelsToCentibels(float decibel) {
        return (int)(decibel * 10.0f);
    }

    @Override
    public void setBalance(int sidNum, float balance) {
        assert (balance >= 0.0f && balance <= 1.0f);
        this.positionL[sidNum] = 1.0f - balance;
        this.positionR[sidNum] = balance;
        this.updateSampleMixerVolume();
    }

    @Override
    public void setDelay(int sidNum, int delay) {
        assert (delay >= 0 && delay <= 50);
        this.delayInSamples[sidNum] = (int)(this.cpuClock.getCpuFrequency() / 1000.0 * (double)delay);
        this.updateSampleMixerVolume();
    }

    private SampleMixer createSampleMixer(IntBuffer intBufferL, IntBuffer intBufferR) {
        if (this.fadeInFadeOutEnabled) {
            return new SampleMixer.LinearFadingSampleMixer(intBufferL, intBufferR);
        }
        return new SampleMixer.DefaultSampleMixer(intBufferL, intBufferR);
    }

    private void updateSampleMixerVolume() {
        boolean mono = this.sids.size() == 1;
        boolean fakeStereo = this.isFakeStereo();
        int sidNum = 0;
        for (ReSIDBase sid : this.sids) {
            SampleMixer sampler = sid.getSampler();
            if (mono) {
                sampler.setVolume(this.volume[sidNum], this.volume[sidNum]);
                sampler.setDelay(0);
            } else {
                double leftFraction = this.positionL[sidNum];
                double rightFraction = this.positionR[sidNum];
                if (!fakeStereo) {
                    leftFraction = Math.sqrt(2.0 * leftFraction);
                    rightFraction = Math.sqrt(2.0 * rightFraction);
                }
                int volumeL = (int)((double)this.volume[sidNum] * leftFraction);
                int volumeR = (int)((double)this.volume[sidNum] * rightFraction);
                sampler.setVolume(volumeL, volumeR);
                sampler.setDelay(this.delayInSamples[sidNum]);
            }
            ++sidNum;
        }
    }

    private boolean isFakeStereo() {
        return this.sids.stream().map(Object::getClass).map(Class::getSimpleName).anyMatch("FakeStereo"::equals);
    }

    @Override
    public void fastForward() {
        this.mixerAudio.fastForwardShift = Math.min(this.mixerAudio.fastForwardShift + 1, 15);
        this.mixerAudio.fastForwardBitMask = (1 << this.mixerAudio.fastForwardShift - 10) - 1;
    }

    @Override
    public void normalSpeed() {
        this.mixerAudio.fastForwardShift = 10;
        this.mixerAudio.fastForwardBitMask = 0;
    }

    @Override
    public boolean isFastForward() {
        return this.mixerAudio.fastForwardShift - 10 != 0;
    }

    @Override
    public int getFastForwardBitMask() {
        return this.mixerAudio.fastForwardBitMask;
    }

    public WhatsSidSupport getWhatsSidSupport() {
        return this.whatsSidSupport;
    }

    public void setWhatsSidEnabled(boolean whatsSidEnabled) {
        this.whatsSidEnabled = whatsSidEnabled;
    }

    private final class MixerEvent
    extends Event {
        private final Random RANDOM;
        private int oldRandomValue;
        private int fastForwardShift;
        private int fastForwardBitMask;

        private MixerEvent(String name) {
            super(name);
            this.RANDOM = new Random();
        }

        @Override
        public void event() throws InterruptedException {
            for (ReSIDBase sid : SIDMixer.this.sids) {
                sid.clock();
                sid.getSampler().clear();
            }
            SIDMixer.this.cart.clock();
            SIDMixer.this.cart.getSampler().clear();
            int valL = 0;
            int valR = 0;
            for (int i = 0; i < SIDMixer.this.bufferSize; ++i) {
                valL += SIDMixer.this.audioBufferL.get();
                valR += SIDMixer.this.audioBufferR.get();
                if ((i & this.fastForwardBitMask) != this.fastForwardBitMask) continue;
                int dither = this.triangularDithering();
                if (SIDMixer.this.resamplerL.input(valL >> this.fastForwardShift)) {
                    short outputL = (short)Math.max(Math.min(SIDMixer.this.resamplerL.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE);
                    SIDMixer.this.buffer.putShort(outputL);
                }
                if (SIDMixer.this.resamplerR.input(valR >> this.fastForwardShift)) {
                    short outputR = (short)Math.max(Math.min(SIDMixer.this.resamplerR.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE);
                    if (!SIDMixer.this.buffer.putShort(outputR).hasRemaining()) {
                        ListIterator listIterator = SIDMixer.this.audioProcessors.listIterator();
                        while (listIterator.hasNext()) {
                            ((AudioProcessor)listIterator.next()).process(SIDMixer.this.buffer);
                        }
                        SIDMixer.this.audioDriver.write();
                        ((Buffer)SIDMixer.this.buffer).clear();
                    }
                }
                if (SIDMixer.this.whatsSidEnabled) {
                    SIDMixer.this.whatsSidSupport.output(valL >> this.fastForwardShift, valR >> this.fastForwardShift);
                }
                valR = 0;
                valL = 0;
            }
            ((Buffer)SIDMixer.this.audioBufferL).flip();
            ((Buffer)SIDMixer.this.audioBufferR).flip();
            ((Buffer)SIDMixer.this.audioBufferL.put(SIDMixer.this.emptyBuffer)).clear();
            ((Buffer)SIDMixer.this.audioBufferR.put(SIDMixer.this.emptyBuffer)).clear();
            SIDMixer.this.context.schedule(this, SIDMixer.this.bufferSize);
        }

        private int triangularDithering() {
            int prevValue = this.oldRandomValue;
            this.oldRandomValue = this.RANDOM.nextInt() & 1;
            return this.oldRandomValue - prevValue;
        }
    }
}

