/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resid;

import builder.resid.resid.Filter;
import builder.resid.resid.FilterModelConfig;
import builder.resid.resid.Integrator;

public final class Filter6581
extends Filter {
    protected int Vhp;
    protected int Vbp;
    protected int Vlp;
    private char[] currentGain;
    private char[] currentMixer;
    private char[] currentSummer;
    private char[] currentResonance;
    private final Integrator hpIntegrator;
    private final Integrator bpIntegrator;
    private int ve;
    private final int voiceScaleS14 = FilterModelConfig.getVoiceScaleS14();
    private final int voiceDC = FilterModelConfig.getVoiceDC();
    private final int vo_T16 = FilterModelConfig.getVO_T16();
    private final char[] f0_dac = FilterModelConfig.getDAC(FilterModelConfig.getDacZero(0.0));
    private final char[][] mixer = FilterModelConfig.getMixer();
    private final char[][] summer = FilterModelConfig.getSummer();
    private final char[][] gain = FilterModelConfig.getGain();

    protected Filter6581() {
        this.hpIntegrator = FilterModelConfig.buildIntegrator();
        this.bpIntegrator = FilterModelConfig.buildIntegrator();
        this.input(0);
    }

    public void setFilterCurve(double curvePosition) {
        System.arraycopy(FilterModelConfig.getDAC(FilterModelConfig.getDacZero(curvePosition)), 0, this.f0_dac, 0, 2048);
        this.updatedCenterFrequency();
    }

    @Override
    protected int clock(int voice1, int voice2, int voice3) {
        int v1 = (voice1 * this.voiceScaleS14 >> 18) + this.voiceDC;
        int v2 = (voice2 * this.voiceScaleS14 >> 18) + this.voiceDC;
        int v3 = (voice3 * this.voiceScaleS14 >> 18) + this.voiceDC;
        int Vi = 0;
        int Vo = 0;
        if (this.filt1) {
            Vi += v1;
        } else {
            Vo += v1;
        }
        if (this.filt2) {
            Vi += v2;
        } else {
            Vo += v2;
        }
        if (this.filt3) {
            Vi += v3;
        } else if (!this.voice3off) {
            Vo += v3;
        }
        if (this.filtE) {
            Vi += this.ve;
        } else {
            Vo += this.ve;
        }
        int oldVhp = this.Vhp;
        this.Vhp = this.currentSummer[this.currentResonance[this.Vbp] + this.Vlp + Vi];
        this.Vlp = this.bpIntegrator.solve(this.Vbp + this.vo_T16) - this.vo_T16;
        this.Vbp = this.hpIntegrator.solve(oldVhp + this.vo_T16) - this.vo_T16;
        if (this.lp) {
            Vo += this.Vlp;
        }
        if (this.bp) {
            Vo += this.Vbp;
        }
        if (this.hp) {
            Vo += this.Vhp;
        }
        return this.currentGain[this.currentMixer[Vo]] - 32768;
    }

    @Override
    protected void zeroDenormals() {
    }

    @Override
    protected void input(int sample) {
        this.ve = (sample * this.voiceScaleS14 * 3 >> 10) + this.mixer[0][0];
    }

    @Override
    protected void updatedCenterFrequency() {
        char Vw = this.f0_dac[this.fc];
        this.hpIntegrator.setVw(Vw);
        this.bpIntegrator.setVw(Vw);
    }

    @Override
    protected void updatedResonance() {
        this.currentResonance = this.gain[~this.res & 0xF];
    }

    @Override
    protected void updatedMixing() {
        this.currentGain = this.gain[this.vol];
        int ni = 0;
        int no = 0;
        if (this.filt1) {
            ++ni;
        } else {
            ++no;
        }
        if (this.filt2) {
            ++ni;
        } else {
            ++no;
        }
        if (this.filt3) {
            ++ni;
        } else if (!this.voice3off) {
            ++no;
        }
        if (this.filtE) {
            ++ni;
        } else {
            ++no;
        }
        this.currentSummer = this.summer[ni];
        if (this.lp) {
            ++no;
        }
        if (this.bp) {
            ++no;
        }
        if (this.hp) {
            ++no;
        }
        this.currentMixer = this.mixer[no];
    }
}

