/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resid;

import builder.resid.resid.ExternalFilter;
import builder.resid.resid.Filter;
import builder.resid.resid.Filter6581;
import builder.resid.resid.Filter8580;
import builder.resid.resid.Voice;
import builder.resid.resid.WaveformCalculator;
import java.util.function.IntConsumer;
import libsidplay.common.ChipModel;
import libsidplay.common.Potentiometer;
import libsidplay.common.SIDChip;

public final class SID
implements SIDChip {
    private static final int INPUTDIGIBOOST = 1023;
    private static final int NO_INPUTDIGIBOOST = 127;
    private static final int OUTPUT_LEVEL = 359;
    public final Voice[] voice = new Voice[]{new Voice(), new Voice(), new Voice()};
    private Filter filter;
    private final Filter6581 filter6581 = new Filter6581();
    private final Filter8580 filter8580 = new Filter8580();
    private final ExternalFilter externalFilter = new ExternalFilter();
    private final Potentiometer potX = new Potentiometer(){};
    private final Potentiometer potY = new Potentiometer(){};
    private byte busValue;
    private int busValueTtl;
    private int databus_ttl;
    private int write_address;
    private ChipModel model;
    private int nextVoiceSync;
    private final boolean[] muted = new boolean[4];

    static void kinkedDac(double[] dac, double _2R_div_R, boolean term) {
        double INFINITY = 1000000.0;
        for (int set_bit = 0; set_bit < dac.length; ++set_bit) {
            int bit;
            double Vn = 1.0;
            double R = 1.0;
            double _2R = _2R_div_R * R;
            double Rn = term ? _2R : 1000000.0;
            for (bit = 0; bit < set_bit; ++bit) {
                Rn = Rn == 1000000.0 ? R + _2R : R + _2R * Rn / (_2R + Rn);
            }
            if (Rn == 1000000.0) {
                Rn = _2R;
            } else {
                Rn = _2R * Rn / (_2R + Rn);
                Vn = Vn * Rn / _2R;
            }
            ++bit;
            while (bit < dac.length) {
                double I = Vn / (Rn += R);
                Rn = _2R * Rn / (_2R + Rn);
                Vn = Rn * I;
                ++bit;
            }
            dac[set_bit] = Vn;
        }
        double Vsum = 0.0;
        for (double element : dac) {
            Vsum += element;
        }
        Vsum /= (double)(1 << dac.length);
        int i = 0;
        while (i < dac.length) {
            int n = i++;
            dac[n] = dac[n] / Vsum;
        }
    }

    public SID() {
        this.reset();
        this.setChipModel(ChipModel.MOS8580);
    }

    @Override
    public void setChipModel(ChipModel model) {
        this.model = model;
        int n = this.databus_ttl = model == ChipModel.MOS8580 ? 663552 : 7424;
        if (model == ChipModel.MOS6581) {
            this.filter = this.filter6581;
        } else if (model == ChipModel.MOS8580) {
            this.filter = this.filter8580;
        } else {
            throw new RuntimeException("Don't know how to handle chip type " + (Object)((Object)model));
        }
        short[][] tables = WaveformCalculator.buildTable(model);
        for (int i = 0; i < 3; ++i) {
            this.voice[i].envelope.setChipModel(model);
            this.voice[i].wave.setChipModel(model);
            this.voice[i].wave.setWaveformModels(tables);
        }
    }

    protected ChipModel getChipModel() {
        return this.model;
    }

    @Override
    public void reset() {
        for (int i = 0; i < 3; ++i) {
            this.voice[i].reset();
        }
        this.filter6581.reset();
        this.filter8580.reset();
        this.externalFilter.reset();
        this.busValue = 0;
        this.busValueTtl = 0;
        this.write_address = 0;
        this.voiceSync(false);
    }

    @Override
    public void input(int value) {
        this.filter6581.input(value);
        this.filter8580.input(value);
    }

    @Override
    public byte read(int offset) {
        switch (offset) {
            case 25: {
                this.busValue = this.potX.readPOT();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            case 26: {
                this.busValue = this.potY.readPOT();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            case 27: {
                this.busValue = this.model == ChipModel.MOS6581 ? this.voice[2].wave.readOSC6581(this.voice[0].wave) : this.voice[2].wave.readOSC8580(this.voice[0].wave);
                break;
            }
            case 28: {
                this.busValue = this.voice[2].envelope.readENV();
                this.busValueTtl = this.databus_ttl;
                break;
            }
            default: {
                this.busValueTtl /= 2;
            }
        }
        return this.busValue;
    }

    @Override
    public void write(int offset, byte value) {
        this.write_address = offset;
        this.busValue = value;
        this.busValueTtl = this.databus_ttl;
        switch (this.write_address) {
            case 0: {
                this.voice[0].wave.writeFREQ_LO(this.busValue);
                break;
            }
            case 1: {
                this.voice[0].wave.writeFREQ_HI(this.busValue);
                break;
            }
            case 2: {
                this.voice[0].wave.writePW_LO(this.busValue);
                break;
            }
            case 3: {
                this.voice[0].wave.writePW_HI(this.busValue);
                break;
            }
            case 4: {
                this.voice[0].writeCONTROL_REG(this.muted[0] ? (byte)0 : this.busValue);
                break;
            }
            case 5: {
                this.voice[0].envelope.writeATTACK_DECAY(this.busValue);
                break;
            }
            case 6: {
                this.voice[0].envelope.writeSUSTAIN_RELEASE(this.busValue);
                break;
            }
            case 7: {
                this.voice[1].wave.writeFREQ_LO(this.busValue);
                break;
            }
            case 8: {
                this.voice[1].wave.writeFREQ_HI(this.busValue);
                break;
            }
            case 9: {
                this.voice[1].wave.writePW_LO(this.busValue);
                break;
            }
            case 10: {
                this.voice[1].wave.writePW_HI(this.busValue);
                break;
            }
            case 11: {
                this.voice[1].writeCONTROL_REG(this.muted[1] ? (byte)0 : this.busValue);
                break;
            }
            case 12: {
                this.voice[1].envelope.writeATTACK_DECAY(this.busValue);
                break;
            }
            case 13: {
                this.voice[1].envelope.writeSUSTAIN_RELEASE(this.busValue);
                break;
            }
            case 14: {
                this.voice[2].wave.writeFREQ_LO(this.busValue);
                break;
            }
            case 15: {
                this.voice[2].wave.writeFREQ_HI(this.busValue);
                break;
            }
            case 16: {
                this.voice[2].wave.writePW_LO(this.busValue);
                break;
            }
            case 17: {
                this.voice[2].wave.writePW_HI(this.busValue);
                break;
            }
            case 18: {
                this.voice[2].writeCONTROL_REG(this.muted[2] ? (byte)0 : this.busValue);
                break;
            }
            case 19: {
                this.voice[2].envelope.writeATTACK_DECAY(this.busValue);
                break;
            }
            case 20: {
                this.voice[2].envelope.writeSUSTAIN_RELEASE(this.busValue);
                break;
            }
            case 21: {
                this.filter6581.writeFC_LO(this.busValue);
                this.filter8580.writeFC_LO(this.busValue);
                break;
            }
            case 22: {
                this.filter6581.writeFC_HI(this.busValue);
                this.filter8580.writeFC_HI(this.busValue);
                break;
            }
            case 23: {
                this.filter6581.writeRES_FILT(this.busValue);
                this.filter8580.writeRES_FILT(this.busValue);
                break;
            }
            case 24: {
                if (this.muted[3] && (value & 0xF) < this.filter6581.vol) break;
                this.filter6581.writeMODE_VOL(this.busValue);
                this.filter8580.writeMODE_VOL(this.busValue);
                break;
            }
        }
        this.voiceSync(false);
    }

    @Override
    public void mute(int channel, boolean mute) {
        if (channel < 4) {
            this.muted[channel] = mute;
        }
    }

    @Override
    public void setClockFrequency(double clockFrequency) {
        this.filter6581.setClockFrequency(clockFrequency);
        this.filter8580.setClockFrequency(clockFrequency);
        this.externalFilter.setClockFrequency(clockFrequency);
    }

    private void ageBusValue(int n) {
        if (this.busValueTtl != 0) {
            this.busValueTtl -= n;
            if (this.busValueTtl <= 0) {
                this.busValue = 0;
                this.busValueTtl = 0;
            }
        }
    }

    @Override
    public void clock(int cycles, IntConsumer sample) {
        this.ageBusValue(cycles);
        while (cycles != 0) {
            int delta_t = Math.min(this.nextVoiceSync, cycles);
            if (delta_t > 0) {
                for (int i = 0; i < delta_t; ++i) {
                    sample.accept(this.clock() * 359 >> 8);
                }
                this.filter.zeroDenormals();
                this.externalFilter.zeroDenormals();
                cycles -= delta_t;
                this.nextVoiceSync -= delta_t;
            }
            if (this.nextVoiceSync != 0) continue;
            this.voiceSync(true);
        }
    }

    private int clock() {
        this.voice[0].wave.clock();
        this.voice[1].wave.clock();
        this.voice[2].wave.clock();
        this.voice[0].envelope.clock();
        this.voice[1].envelope.clock();
        this.voice[2].envelope.clock();
        return this.externalFilter.clock(this.filter.clock(this.voice[0].output(this.voice[2].wave), this.voice[1].output(this.voice[0].wave), this.voice[2].output(this.voice[1].wave)));
    }

    private void voiceSync(boolean sync) {
        int i;
        if (sync) {
            for (i = 0; i < 3; ++i) {
                this.voice[i].wave.synchronize(this.voice[(i + 1) % 3].wave, this.voice[(i + 2) % 3].wave);
            }
        }
        this.nextVoiceSync = Integer.MAX_VALUE;
        for (i = 0; i < 3; ++i) {
            int thisVoiceSync;
            int accumulator = this.voice[i].wave.accumulator;
            int freq = this.voice[i].wave.freq;
            if (this.voice[i].wave.test || freq == 0 || !this.voice[(i + 1) % 3].wave.sync || (thisVoiceSync = (0x7FFFFF - accumulator & 0xFFFFFF) / freq + 1) >= this.nextVoiceSync) continue;
            this.nextVoiceSync = thisVoiceSync;
        }
    }

    public Filter6581 getFilter6581() {
        return this.filter6581;
    }

    public Filter8580 getFilter8580() {
        return this.filter8580;
    }

    @Override
    public void setDigiBoost(boolean digiBoost) {
        if (digiBoost && this.model.equals((Object)ChipModel.MOS8580)) {
            this.input(1023);
        } else {
            this.input(127);
        }
    }
}

