/*
 * Decompiled with CFR 0.152.
 */
package client.teavm;

import client.teavm.ImportedApi;
import client.teavm.common.ExportedApi;
import client.teavm.common.IExportedApi;
import java.util.Optional;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.common.SidReads;
import libsidplay.common.StereoMode;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.FloppyType;
import libsidplay.components.keyboard.KeyTableEntry;
import org.teavm.interop.Export;
import org.teavm.jso.JSExport;

public class JSIDPlay2TeaVM {
    private static IExportedApi jsidplay2;

    public static void main(String[] args) {
        jsidplay2 = new ExportedApi(new ImportedApi(), args);
    }

    @Export(name="js2open")
    @JSExport
    public static void js2open(byte[] sidContents, String sidContentsName, int song, int nthFrame, boolean addSidListener, byte[] cartContents, String cartContentsName, String command, double songLength) {
        jsidplay2.open(sidContents, sidContentsName, song, nthFrame, addSidListener, cartContents, cartContentsName, command, songLength);
    }

    @Export(name="js2clock")
    @JSExport
    public static void js2clock() {
        jsidplay2.clock();
    }

    @Export(name="js2defaultPlayLength")
    @JSExport
    public static void js2defaultPlayLength(double defaultPlayLength) {
        jsidplay2.defaultPlayLength(defaultPlayLength);
    }

    @Export(name="js2loop")
    @JSExport
    public static void js2loop(boolean loop) {
        jsidplay2.loop(loop);
    }

    @Export(name="js2single")
    @JSExport
    public static void js2single(boolean single) {
        jsidplay2.single(single);
    }

    @Export(name="js2palEmulationEnable")
    @JSExport
    public static void js2palEmulationEnable(boolean palEmulationEnable) {
        jsidplay2.palEmulationEnable(palEmulationEnable);
    }

    @Export(name="js2turboTape")
    @JSExport
    public static void js2turboTape(boolean turboTape) {
        jsidplay2.turboTape(turboTape);
    }

    @Export(name="js2fade")
    @JSExport
    public static void js2fade(double fadeInTime, double fadeOutTime) {
        jsidplay2.fade(fadeInTime, fadeOutTime);
    }

    @Export(name="js2samplingRate")
    @JSExport
    public static void js2samplingRate(String samplingRate) {
        jsidplay2.samplingRate(SamplingRate.valueOf(samplingRate));
    }

    @Export(name="js2sampling")
    @JSExport
    public static void js2sampling(String sampling) {
        jsidplay2.sampling(SamplingMethod.valueOf(sampling));
    }

    @Export(name="js2volumeLevels")
    @JSExport
    public static void js2volumeLevels(float mainVolume, float secondVolume, float thirdVolume, float mainBalance, float secondBalance, float thirdBalance, int mainDelay, int secondDelay, int thirdDelay) {
        jsidplay2.volumeLevels(mainVolume, secondVolume, thirdVolume, mainBalance, secondBalance, thirdBalance, mainDelay, secondDelay, thirdDelay);
    }

    @Export(name="js2bufferSize")
    @JSExport
    public static void js2bufferSize(int bufferSize) {
        jsidplay2.bufferSize(bufferSize);
    }

    @Export(name="js2audioBufferSize")
    @JSExport
    public static void js2audioBufferSize(int audioBufferSize) {
        jsidplay2.audioBufferSize(audioBufferSize);
    }

    @Export(name="js2delay")
    @JSExport
    public static void js2delay(boolean delayBypass, int delay, int delayWetLevel, int delayDryLevel, int delayFeedbackLevel) {
        jsidplay2.delay(delayBypass, delay, delayWetLevel, delayDryLevel, delayFeedbackLevel);
    }

    @Export(name="js2reverb")
    @JSExport
    public static void js2reverb(boolean reverbBypass, float reverbComb1Delay, float reverbComb2Delay, float reverbComb3Delay, float reverbComb4Delay, float reverbAllPass1Delay, float reverbAllPass2Delay, float reverbSustainDelay, float reverbDryWetMix) {
        jsidplay2.reverb(reverbBypass, reverbComb1Delay, reverbComb2Delay, reverbComb3Delay, reverbComb4Delay, reverbAllPass1Delay, reverbAllPass2Delay, reverbSustainDelay, reverbDryWetMix);
    }

    @Export(name="js2engine")
    @JSExport
    public static void js2engine(String engine) {
        jsidplay2.engine(Engine.valueOf(engine));
    }

    @Export(name="js2defaultEmulation")
    @JSExport
    public static void js2defaultEmulation(String emulation) {
        jsidplay2.defaultEmulation(Emulation.valueOf(emulation));
    }

    @Export(name="js2userEmulation")
    @JSExport
    public static void js2userEmulation(String userEmulation, String stereoEmulation, String thirdEmulation) {
        jsidplay2.userEmulation(Emulation.valueOf(userEmulation), Emulation.valueOf(stereoEmulation), Emulation.valueOf(thirdEmulation));
    }

    @Export(name="js2defaultClockSpeed")
    @JSExport
    public static void js2defaultClockSpeed(String defaultClockSpeed) {
        jsidplay2.defaultClockSpeed(CPUClock.valueOf(defaultClockSpeed));
    }

    @Export(name="js2userClockSpeed")
    @JSExport
    public static void js2userClockSpeed(String userClockSpeed) {
        jsidplay2.userClockSpeed(CPUClock.valueOf(userClockSpeed));
    }

    @Export(name="js2defaultChipModel")
    @JSExport
    public static void js2defaultChipModel(String chipModel) {
        jsidplay2.defaultChipModel(ChipModel.valueOf(chipModel));
    }

    @Export(name="js2userChipModel")
    @JSExport
    public static void js2userChipModel(String userSidModel, String stereoSidModel, String thirdSIDModel) {
        jsidplay2.userChipModel(ChipModel.valueOf(userSidModel), ChipModel.valueOf(stereoSidModel), ChipModel.valueOf(thirdSIDModel));
    }

    @Export(name="js2hardSidMapping")
    @JSExport
    public static String js2hardSidMapping(int chipCount, int hardsid6581, int hardsid8580) {
        return jsidplay2.hardSidMapping(chipCount, hardsid6581, hardsid8580);
    }

    @Export(name="js2exSidMapping")
    @JSExport
    public static String js2exSidMapping() {
        return jsidplay2.exSidMapping();
    }

    @Export(name="js2sidBlasterMapping")
    @JSExport
    public static String js2sidBlasterMapping() {
        return jsidplay2.sidBlasterMapping();
    }

    @Export(name="js2usbSidMapping")
    @JSExport
    public static String js2usbSidMapping() {
        return jsidplay2.usbSidMapping();
    }

    @Export(name="js2filterEnable")
    @JSExport
    public static void js2filterEnable(int sidNum, boolean filterEnable) {
        jsidplay2.filterEnable(sidNum, filterEnable);
    }

    @Export(name="js2filterName")
    @JSExport
    public static void js2filterName(String emulation, String chipModel, int sidNum, String filterName) {
        jsidplay2.filterName(Emulation.valueOf(emulation), ChipModel.valueOf(chipModel), sidNum, filterName);
    }

    @Export(name="js2digiBoosted8580")
    @JSExport
    public static void js2digiBoosted8580(boolean boost) {
        jsidplay2.digiBoosted8580(boost);
    }

    @Export(name="js2stereo")
    @JSExport
    public static void js2stereo(String stereoMode, int dualSidBase, int thirdSIDBase, boolean fakeStereo, String sidToRead) {
        jsidplay2.stereo(StereoMode.valueOf(stereoMode), dualSidBase, thirdSIDBase, fakeStereo, SidReads.valueOf(sidToRead));
    }

    @Export(name="js2mute")
    @JSExport
    public static void js2mute(int sidNum, int voice, boolean value) {
        jsidplay2.mute(sidNum, voice, value);
    }

    @Export(name="js2detectPSID64ChipModel")
    @JSExport
    public static void js2detectPSID64ChipModel(boolean detectPSID64ChipModel) {
        jsidplay2.detectPSID64ChipModel(detectPSID64ChipModel);
    }

    @Export(name="js2turnDriveOn")
    @JSExport
    public static void js2turnDriveOn(boolean driveOn) {
        jsidplay2.turnDriveOn(driveOn);
    }

    @Export(name="js2parallelCable")
    @JSExport
    public static void js2parallelCable(boolean parallelCable) {
        jsidplay2.parallelCable(parallelCable);
    }

    @Export(name="js2jiffyDosInstalled")
    @JSExport
    public static void js2jiffyDosInstalled(boolean jiffyDosInstalled) {
        jsidplay2.jiffyDosInstalled(jiffyDosInstalled);
    }

    @Export(name="js2ramExpansion")
    @JSExport
    public static void js2ramExpansion(boolean ramExpansion0, boolean ramExpansion1, boolean ramExpansion2, boolean ramExpansion3, boolean ramExpansion4) {
        jsidplay2.ramExpansion(ramExpansion0, ramExpansion1, ramExpansion2, ramExpansion3, ramExpansion4);
    }

    @Export(name="js2floppyType")
    @JSExport
    public static void js2floppyType(String floppyType) {
        jsidplay2.floppyType(FloppyType.valueOf(floppyType));
    }

    @Export(name="js2printerOn")
    @JSExport
    public static void js2printerOn(boolean printerOn) {
        jsidplay2.printerOn(printerOn);
    }

    @Export(name="js2whatsSID")
    @JSExport
    public static void js2whatsSID(boolean enable, int captureTime, int matchStartTime, int matchRetryTime, float minimumRelativeConfidence) {
        jsidplay2.whatsSID(enable, captureTime, matchStartTime, matchRetryTime, minimumRelativeConfidence);
    }

    @Export(name="js2typeInCommand")
    @JSExport
    public static void js2typeInCommand(String multiLineCommand) {
        jsidplay2.typeInCommand(multiLineCommand);
    }

    @Export(name="js2typeKey")
    @JSExport
    public static void js2typeKey(String keyCode) {
        jsidplay2.typeKey(KeyTableEntry.valueOf(keyCode));
    }

    @Export(name="js2pressKey")
    @JSExport
    public static void js2pressKey(String keyCode) {
        jsidplay2.pressKey(KeyTableEntry.valueOf(keyCode));
    }

    @Export(name="js2releaseKey")
    @JSExport
    public static void js2releaseKey(String keyCode) {
        jsidplay2.releaseKey(KeyTableEntry.valueOf(keyCode));
    }

    @Export(name="js2joystick")
    @JSExport
    public static void js2joystick(int number, int value) {
        jsidplay2.joystick(number, value);
    }

    @Export(name="js2fastForward")
    @JSExport
    public static void js2fastForward() {
        jsidplay2.fastForward();
    }

    @Export(name="js2normalSpeed")
    @JSExport
    public static void js2normalSpeed() {
        jsidplay2.normalSpeed();
    }

    @Export(name="js2tuneInfo")
    @JSExport
    public static String js2tuneInfo() {
        return jsidplay2.tuneInfo();
    }

    @Export(name="js2playList")
    @JSExport
    public static String js2playList() {
        return jsidplay2.playList();
    }

    @Export(name="js2status")
    @JSExport
    public static String js2status() {
        return jsidplay2.status();
    }

    @Export(name="js2insertDisk")
    @JSExport
    public static void js2insertDisk(byte[] diskContents, String diskContentsName) {
        jsidplay2.insertDisk(diskContents, diskContentsName);
    }

    @Export(name="js2ejectDisk")
    @JSExport
    public static void js2ejectDisk() {
        jsidplay2.ejectDisk();
    }

    @Export(name="js2insertTape")
    @JSExport
    public static void js2insertTape(byte[] tapeContents, String tapeContentsNameFromJS) {
        String tapeContentsName = Optional.ofNullable(tapeContentsNameFromJS).map(String::valueOf).orElse(null);
        jsidplay2.insertTape(tapeContents, tapeContentsName);
    }

    @Export(name="js2ejectTape")
    @JSExport
    public static void js2ejectTape() {
        jsidplay2.ejectTape();
    }

    @Export(name="js2controlDatasette")
    @JSExport
    public static void js2controlDatasette(String control) {
        jsidplay2.controlDatasette(Datasette.Control.valueOf(control));
    }

    @Export(name="js2insertREUfile")
    @JSExport
    public static void js2insertREUfile(byte[] cartContents, String cartContentsName) {
        jsidplay2.insertREUfile(cartContents, cartContentsName);
    }

    @Export(name="js2insertREU")
    @JSExport
    public static void js2insertREU(int sizeKb) {
        jsidplay2.insertREU(sizeKb);
    }

    @Export(name="js2freezeCartridge")
    @JSExport
    public static void js2freezeCartridge() {
        jsidplay2.freezeCartridge();
    }

    @Export(name="js2delaySidBlaster")
    @JSExport
    public static void js2delaySidBlaster(int cycles) {
        jsidplay2.delaySidBlaster(cycles);
    }
}

