/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.c;

import client.teavm.c.ImportedApi;
import client.teavm.common.ExportedApi;
import client.teavm.common.IExportedApi;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import libsidplay.common.SamplingRate;
import libsidutils.IOUtils;

public final class JSIDPlay2TeaVM {
    private static final String[] DEBUG_ARGS = new String[]{"--debug", "true"};
    private static IExportedApi jsidplay2;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Missing arguments: <sidFilename> <wavFilename> <recordingTimeInSeconds>");
        } else {
            File tuneFile = new File(args[0]);
            File outFile = new File(args[1]);
            int seconds = Integer.parseInt(args[2]);
            try (FileInputStream is = new FileInputStream(tuneFile);
                 DataOutputStream os = new DataOutputStream(new FileOutputStream(outFile));){
                SamplingRate samplingRate = SamplingRate.MEDIUM;
                int numSamples = seconds * samplingRate.getFrequency();
                jsidplay2 = new ExportedApi(new ImportedApi(os, samplingRate.getFrequency(), numSamples), DEBUG_ARGS);
                jsidplay2.bufferSize(3 * samplingRate.getFrequency());
                jsidplay2.audioBufferSize(samplingRate.getFrequency());
                jsidplay2.samplingRate(samplingRate);
                jsidplay2.open(IOUtils.readAllBytes(is), tuneFile.getName(), 0, 0, false, null, null, null, 0.0);
                while (os.size() >> 2 < numSamples) {
                    jsidplay2.clock();
                }
            }
        }
    }
}

