/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.audio;

import client.teavm.common.IImportedApi;
import client.teavm.common.video.PALEmulationTeaVM;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SIDListener;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.VideoDriver;

public final class AudioDriverTeaVM
implements AudioDriver,
VideoDriver,
SIDListener {
    private static final short REGULAR_DELAY = 8192;
    private final IImportedApi importedApi;
    private final float[] lookupTable;
    private final Mixer mixer;
    private final Engine engine;
    private final int nthFrame;
    private final byte[] pixelsArray;
    private EventScheduler context;
    private ByteBuffer sampleBuffer;
    private ShortBuffer shortBuffer;
    private FloatBuffer resultL;
    private FloatBuffer resultR;
    private int n;
    private long lastSIDWriteTime;
    private int fastForwardVICFrames;

    public AudioDriverTeaVM(IImportedApi importedApi, float[] lookupTable, Mixer mixer, Engine engine, PALEmulationTeaVM palEmulation) {
        this.importedApi = importedApi;
        this.lookupTable = lookupTable;
        this.mixer = mixer;
        this.engine = engine;
        this.pixelsArray = palEmulation != null ? palEmulation.getPixels().array() : null;
        this.nthFrame = palEmulation != null ? palEmulation.getNthFrame() : 0;
        this.fastForwardVICFrames = 0;
    }

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.context = context;
        AudioConfig cfg = new AudioConfig(audioSection);
        this.sampleBuffer = ByteBuffer.allocate(cfg.getChunkFrames() * 2 * cfg.getChannels()).order(ByteOrder.LITTLE_ENDIAN);
        this.shortBuffer = this.sampleBuffer.asShortBuffer();
        this.resultL = FloatBuffer.wrap(new float[cfg.getChunkFrames()]);
        this.resultR = FloatBuffer.wrap(new float[cfg.getChunkFrames()]);
        if (this.engine != Engine.EMULATION) {
            context.schedule(Event.of("USB Regular Delay", event -> context.schedule((Event)event, this.eventuallyDelay(), Event.Phase.PHI2)), 0L, Event.Phase.PHI2);
        }
        this.n = 0;
        this.lastSIDWriteTime = 0L;
    }

    @Override
    public void write() throws InterruptedException {
        int position = this.sampleBuffer.position();
        ((Buffer)this.shortBuffer).limit(position >> 1);
        while (this.shortBuffer.hasRemaining()) {
            this.resultL.put(this.lookupTable[this.shortBuffer.get() - Short.MIN_VALUE]);
            this.resultR.put(this.lookupTable[this.shortBuffer.get() - Short.MIN_VALUE]);
        }
        this.importedApi.processSamples(this.resultL.array(), this.resultR.array());
        ((Buffer)this.resultL).clear();
        ((Buffer)this.resultR).clear();
        ((Buffer)this.shortBuffer).rewind();
    }

    public void writeRemaining() throws InterruptedException {
        int position = this.sampleBuffer.position();
        if (position < this.sampleBuffer.capacity()) {
            this.resultL = FloatBuffer.wrap(new float[position >> 2]);
            this.resultR = FloatBuffer.wrap(new float[position >> 2]);
        }
        this.write();
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    @Override
    public void accept(VIC vic) {
        int fastForwardBitMask = this.mixer.getFastForwardBitMask();
        if ((this.fastForwardVICFrames++ & fastForwardBitMask) == fastForwardBitMask && ++this.n == this.nthFrame) {
            this.n = 0;
            this.importedApi.processPixels(this.pixelsArray);
        }
    }

    @Override
    public void write(int addr, byte data) {
        long now = this.context.getTime(Event.Phase.PHI2);
        this.importedApi.processSidWrite(now, this.clocksSinceLastAccess(now), addr, data & 0xFF);
    }

    private int clocksSinceLastAccess(long now) {
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.mixer.getFastForwardBitMask();
    }

    private long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 8192) {
            this.lastSIDWriteTime += 8192L;
            this.importedApi.processSidWrite(now, (short)(8192 >> this.mixer.getFastForwardBitMask()), -1, 0);
        }
        return 8192L;
    }
}

