/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;
import sidplay.AllRoms;

@CompileTime
public class RomsTeaVM {
    protected static final String CHAR_ROM = "CHAR_ROM";
    protected static final String BASIC_ROM = "BASIC_ROM";
    protected static final String KERNAL_ROM = "KERNAL_ROM";
    protected static final String C1541_ROM = "C1541_ROM";
    protected static final String C1541_II_ROM = "C1541_II_ROM";
    protected static final String JIFFYDOS_C64_ROM = "JIFFYDOS_C64_ROM";
    protected static final String JIFFYDOS_C1541_ROM = "JIFFYDOS_C1541_ROM";
    protected static final String MPS803_ROM = "MPS803_ROM";
    protected static final String PSID_DRIVER_ROM = "PSID_DRIVER_ROM";
    protected static final String TURBO_HEADER_ROM = "TURBO_HEADER_ROM";
    protected static final String TURBO_DATA_ROM = "TURBO_DATA_ROM";
    protected static final String SLOW_HEADER_ROM = "SLOW_HEADER_ROM";
    protected static final String NUVIE_PLAYER_ROM = "NUVIE_PLAYER_ROM";
    private static final String PSID_DRIVER_BIN = "/libsidplay/sidtune/psiddriver.bin";
    private static final String TURBO_HEADER_BIN = "/libsidutils/prg2tap/PRG2TAP_TurboHeader.bin";
    private static final String TURBO_DATA_BIN = "/libsidutils/prg2tap/PRG2TAP_TurboData.bin";
    private static final String SLOW_HEADER_BIN = "/libsidutils/prg2tap/PRG2TAP_SlowHeader.bin";
    private static final String NUVIE_PLAYER_BIN = "/libsidplay/roms/nuvieplayer-v1.0.prg";

    @Meta
    public static native Map<String, String> getJavaScriptRoms(boolean var0);

    private static void getJavaScriptRoms(Value<Boolean> b) {
        try (DataInputStream psidDriverIn = new DataInputStream(RomsTeaVM.class.getResourceAsStream(PSID_DRIVER_BIN));
             DataInputStream turboHeaderIn = new DataInputStream(RomsTeaVM.class.getResourceAsStream(TURBO_HEADER_BIN));
             DataInputStream turboDataIn = new DataInputStream(RomsTeaVM.class.getResourceAsStream(TURBO_DATA_BIN));
             DataInputStream slowHeaderIn = new DataInputStream(RomsTeaVM.class.getResourceAsStream(SLOW_HEADER_BIN));
             DataInputStream nuviePlayerIn = new DataInputStream(RomsTeaVM.class.getResourceAsStream(NUVIE_PLAYER_BIN));){
            URL psidDriverUrl = RomsTeaVM.class.getResource(PSID_DRIVER_BIN);
            byte[] psidDriverBin = new byte[psidDriverUrl.openConnection().getContentLength()];
            psidDriverIn.readFully(psidDriverBin);
            URL turboHeaderUrl = RomsTeaVM.class.getResource(TURBO_HEADER_BIN);
            byte[] turboHeaderBin = new byte[turboHeaderUrl.openConnection().getContentLength()];
            turboHeaderIn.readFully(turboHeaderBin);
            URL turboDataUrl = RomsTeaVM.class.getResource(TURBO_DATA_BIN);
            byte[] turboDataBin = new byte[turboDataUrl.openConnection().getContentLength()];
            turboDataIn.readFully(turboDataBin);
            URL slowDataUrl = RomsTeaVM.class.getResource(SLOW_HEADER_BIN);
            byte[] slowHeaderBin = new byte[slowDataUrl.openConnection().getContentLength()];
            slowHeaderIn.readFully(slowHeaderBin);
            URL nuviePlayerUrl = RomsTeaVM.class.getResource(NUVIE_PLAYER_BIN);
            byte[] nuviePlayerBin = new byte[nuviePlayerUrl.openConnection().getContentLength()];
            nuviePlayerIn.readFully(nuviePlayerBin);
            String charRom = new String(Base64.getEncoder().encode(AllRoms.CHAR), StandardCharsets.US_ASCII);
            String basicRom = new String(Base64.getEncoder().encode(AllRoms.BASIC), StandardCharsets.US_ASCII);
            String kernalRom = new String(Base64.getEncoder().encode(AllRoms.KERNAL), StandardCharsets.US_ASCII);
            String c1541Rom = new String(Base64.getEncoder().encode(AllRoms.C1541), StandardCharsets.US_ASCII);
            String c15412Rom = new String(Base64.getEncoder().encode(AllRoms.C1541_II), StandardCharsets.US_ASCII);
            String jiffyDosC64Rom = new String(Base64.getEncoder().encode(AllRoms.JIFFYDOS_C64), StandardCharsets.US_ASCII);
            String jiffyDosC1541Rom = new String(Base64.getEncoder().encode(AllRoms.JIFFYDOS_C1541), StandardCharsets.US_ASCII);
            String mps803Rom = new String(Base64.getEncoder().encode(AllRoms.MPS803_CHAR), StandardCharsets.US_ASCII);
            String psidDriver = new String(Base64.getEncoder().encode(psidDriverBin), StandardCharsets.US_ASCII);
            String turboHeader = new String(Base64.getEncoder().encode(turboHeaderBin), StandardCharsets.US_ASCII);
            String turboData = new String(Base64.getEncoder().encode(turboDataBin), StandardCharsets.US_ASCII);
            String slowHeader = new String(Base64.getEncoder().encode(slowHeaderBin), StandardCharsets.US_ASCII);
            String nuviePlayer = new String(Base64.getEncoder().encode(nuviePlayerBin), StandardCharsets.US_ASCII);
            Value result = Metaprogramming.emit(() -> new HashMap());
            Value basicRomValue = Metaprogramming.emit(() -> basicRom);
            Value kernalRomValue = Metaprogramming.emit(() -> kernalRom);
            Value charRomValue = Metaprogramming.emit(() -> charRom);
            Value c1541RomValue = Metaprogramming.emit(() -> c1541Rom);
            Value c15412RomValue = Metaprogramming.emit(() -> c15412Rom);
            Value jiffyDosC64RomValue = Metaprogramming.emit(() -> jiffyDosC64Rom);
            Value jiffyDosC1541RomValue = Metaprogramming.emit(() -> jiffyDosC1541Rom);
            Value mps803RomValue = Metaprogramming.emit(() -> mps803Rom);
            Value psidDriverValue = Metaprogramming.emit(() -> psidDriver);
            Value turboHeaderValue = Metaprogramming.emit(() -> turboHeader);
            Value turboDataValue = Metaprogramming.emit(() -> turboData);
            Value slowHeaderValue = Metaprogramming.emit(() -> slowHeader);
            Value nuviePlayerValue = Metaprogramming.emit(() -> nuviePlayer);
            Metaprogramming.emit(() -> ((Map)result.get()).put(CHAR_ROM, (String)charRomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(BASIC_ROM, (String)basicRomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(KERNAL_ROM, (String)kernalRomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(C1541_ROM, (String)c1541RomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(C1541_II_ROM, (String)c15412RomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(JIFFYDOS_C64_ROM, (String)jiffyDosC64RomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(JIFFYDOS_C1541_ROM, (String)jiffyDosC1541RomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(MPS803_ROM, (String)mps803RomValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(PSID_DRIVER_ROM, (String)psidDriverValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(TURBO_HEADER_ROM, (String)turboHeaderValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(TURBO_DATA_ROM, (String)turboDataValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(SLOW_HEADER_ROM, (String)slowHeaderValue.get()));
            Metaprogramming.emit(() -> ((Map)result.get()).put(NUVIE_PLAYER_ROM, (String)nuviePlayerValue.get()));
            Metaprogramming.exit(() -> result.get());
        }
        catch (IOException e) {
            throw new RuntimeException("Load failed for resource: " + e.getMessage());
        }
    }
}

