/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.parameter.usage;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EventSchemaUsageFormatter
extends DefaultUsageFormatter {
    private JCommander commander;
    private boolean isExport;

    public EventSchemaUsageFormatter(JCommander commander, boolean isExport) {
        super(commander);
        this.commander = commander;
        this.isExport = isExport;
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        if (this.isExport && !hasCommands && this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden()).filter(pd -> !pd.getParameter().isHelp()).count() > 0L) {
            out.append("      eventData: {\n");
            out.append("        type: 'object',\n");
        }
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        boolean hasCommands;
        boolean bl = hasCommands = !this.commander.getCommands().isEmpty();
        if (sortedParameters.size() > 0) {
            List collect = sortedParameters.stream().filter(p -> p.getParameter().required()).collect(Collectors.toList());
            if (!hasCommands && !collect.isEmpty()) {
                out.append("        required: [" + collect.stream().map(p -> "'" + p.getNames() + "'").collect(Collectors.joining(",")) + "],\n");
            }
            out.append("        properties: {\n");
        }
        for (ParameterDescription pd2 : sortedParameters) {
            if (pd2.getParameter().hidden() || pd2.getParameter().isHelp()) continue;
            out.append(indent).append("    ").append(this.getEventDataParameterNames(pd2.getNames())).append(": {");
            Class type2 = pd2.getParameterized().getType();
            if (type2.equals(Integer.TYPE) || type2.equals(Integer.class)) {
                out.append(" type: 'integer'");
            } else if (type2.equals(Boolean.TYPE) || type2.equals(Boolean.class)) {
                out.append(" type: 'boolean'");
            } else if (type2.equals(String.class)) {
                out.append(" type: 'string'");
            } else if (type2.equals(Double.TYPE) || type2.equals(Double.class)) {
                out.append(" type: 'number'");
            } else if (type2.equals(Float.TYPE) || type2.equals(Float.class)) {
                out.append(" type: 'number'");
            } else if (type2.equals(byte[].class)) {
                out.append(" elements: { type: \"uint8\" }");
            } else if (type2.isEnum()) {
                out.append(" enum: [");
                for (Enum en : EnumSet.allOf(type2)) {
                    out.append("'" + en.toString() + "',");
                }
                out.append("]");
            }
            out.append("},\n");
        }
        if (sortedParameters.stream().filter(pd -> !pd.getParameter().hidden()).filter(pd -> !pd.getParameter().isHelp()).count() > 0L) {
            out.append("        },\n");
            out.append("        additionalProperties: false,\n");
            out.append("      },\n");
        }
        if (!hasCommands) {
            out.append("    },\n");
        }
    }

    public void usage(StringBuilder out, String indent) {
        if (this.commander.getDescriptions() == null) {
            this.commander.createDescriptions();
        }
        boolean hasCommands = !this.commander.getCommands().isEmpty();
        boolean hasOptions = !this.commander.getDescriptions().isEmpty();
        int descriptionIndent = 6;
        int indentCount = indent.length() + 6;
        this.appendMainLine(out, hasOptions, hasCommands, indentCount, indent);
        List sortedParameters = Lists.newArrayList();
        for (ParameterDescription pd : this.commander.getFields().values()) {
            if (pd.getParameter().hidden() || pd.getParameter().isHelp()) continue;
            sortedParameters.add(pd);
        }
        sortedParameters.sort(this.commander.getParameterDescriptionComparator());
        this.appendAllParametersDetails(out, indentCount, indent, sortedParameters);
        if (hasCommands) {
            this.appendCommands(out, indentCount, 6, indent);
        }
    }

    public void appendCommands(StringBuilder out, int indentCount, int descriptionIndent, String indent) {
        Parameters p;
        Object arg;
        boolean hasOnlyHiddenCommands = true;
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            hasOnlyHiddenCommands = false;
        }
        if (hasOnlyHiddenCommands) {
            return;
        }
        out.append("\n// myModule.js\n(function (global, factory) {\n    global.myModule = factory();\n})(typeof self !== \"undefined\" ? self : this, function () {\n\n");
        out.append("const schema = {\n  type: 'object',\n  discriminator: { propertyName: 'eventType' },\n  required: ['eventType'],\n  oneOf: [\n");
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            JCommander.ProgramName progName = (JCommander.ProgramName)commands.getKey();
            String dispName = progName.getDisplayName();
            JCommander jc = this.commander.findCommandByAlias(progName.getName());
            out.append("  {\n" + (jc.getFields().values().stream().filter(pd -> !pd.getParameter().hidden()).filter(pd -> !pd.getParameter().isHelp()).count() > 0L ? "    required: ['eventData'],\n" : "") + "    properties: {\n      eventType: {enum: ['" + dispName + "'] },\n");
            jc.setUsageFormatter((IUsageFormatter)new EventSchemaUsageFormatter(jc, this.isExport));
            jc.getUsageFormatter().usage(out, indent + EventSchemaUsageFormatter.s((int)6));
            out.append("  },\n");
        }
        out.append("  ],\n}\n");
        out.append("    return {\n        schema\n    };\n});\n");
    }

    private String getEventDataParameterNames(String names) {
        return Arrays.asList(names.split(", ")).stream().collect(Collectors.joining(", "));
    }
}

