/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.parameter.usage;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.Strings;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class EventUsageFormatter
extends DefaultUsageFormatter {
    private JCommander commander;
    private boolean isExport;
    private ResourceBundle bundle;

    public EventUsageFormatter(JCommander commander, boolean isExport) {
        super(commander);
        this.commander = commander;
        this.isExport = isExport;
        this.bundle = this.getBundle();
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        if (this.isExport && !hasCommands) {
            out.append("\n");
            out.append(indent).append("Usage: \n");
            if (this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden()).filter(pd -> !pd.getParameter().isHelp()).count() > 0L) {
                out.append(indent).append("  $ worker.postMessage({ eventType: \"");
                out.append(this.commander.getProgramDisplayName());
                out.append("\", eventData: { EventData } })");
            } else {
                out.append(indent).append("  $ worker.postMessage({ eventType: \"");
                out.append(this.commander.getProgramDisplayName());
                out.append("\" })");
            }
            out.append("\n");
        }
        if (this.commander.getMainParameter() != null && this.commander.getMainParameterValue() != null) {
            this.appendReturnedEvent(out, indentCount, indent);
        }
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        if (sortedParameters.size() > 0) {
            out.append("\n");
            out.append(indent).append("EventData:\n");
        }
        for (ParameterDescription pd : sortedParameters) {
            Class type2;
            WrappedParameter parameter = pd.getParameter();
            if (pd.getParameter().hidden() || pd.getParameter().isHelp()) continue;
            String description = pd.getDescription();
            boolean hasDescription = !description.isEmpty();
            out.append(indent).append("  ").append(parameter.required() ? "* " : "  ").append(this.getEventDataParameterNames(pd.getNames())).append("\n");
            if (hasDescription) {
                this.wrapDescription(out, indentCount, EventUsageFormatter.s((int)indentCount) + description);
            }
            Object def = pd.getDefault();
            if (pd.isDynamicParameter()) {
                String syntax = "Syntax: " + parameter.names()[0] + "key" + parameter.getAssignment() + "value";
                if (hasDescription) {
                    out.append(EventUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(EventUsageFormatter.s((int)indentCount));
                }
                out.append(syntax);
            }
            if (this.isExport && def != null && !pd.isHelp()) {
                String displayedDef = Strings.isStringEmpty((String)def.toString()) ? "<empty string>" : def.toString();
                String defaultText = "Default: " + (parameter.password() ? "********" : displayedDef);
                if (hasDescription) {
                    out.append(EventUsageFormatter.newLineAndIndent(indentCount));
                } else {
                    out.append(EventUsageFormatter.s((int)indentCount));
                }
                out.append(defaultText);
            }
            if ((type2 = pd.getParameterized().getType()).isEnum()) {
                String valueList = EnumSet.allOf(type2).toString();
                String possibleValues = "Possible Values: " + valueList;
                if (!description.contains("Options: " + valueList)) {
                    if (hasDescription) {
                        out.append(EventUsageFormatter.newLineAndIndent(indentCount));
                    } else {
                        out.append(EventUsageFormatter.s((int)indentCount));
                    }
                    out.append(possibleValues);
                }
            }
            out.append("\n");
        }
    }

    public void usage(StringBuilder out, String indent) {
        if (this.commander.getDescriptions() == null) {
            this.commander.createDescriptions();
        }
        boolean hasCommands = !this.commander.getCommands().isEmpty();
        boolean hasOptions = !this.commander.getDescriptions().isEmpty();
        int descriptionIndent = 6;
        int indentCount = indent.length() + 6;
        this.appendMainLine(out, hasOptions, hasCommands, indentCount, indent);
        int longestName = 0;
        List sortedParameters = Lists.newArrayList();
        for (ParameterDescription pd : this.commander.getFields().values()) {
            if (pd.getParameter().hidden() || pd.getParameter().isHelp()) continue;
            sortedParameters.add(pd);
            int length = pd.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        sortedParameters.sort(this.commander.getParameterDescriptionComparator());
        this.appendAllParametersDetails(out, indentCount, indent, sortedParameters);
        if (hasCommands) {
            this.appendCommands(out, indentCount, 6, indent);
        }
    }

    public void appendCommands(StringBuilder out, int indentCount, int descriptionIndent, String indent) {
        Parameters p;
        Object arg;
        boolean hasOnlyHiddenCommands = true;
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            hasOnlyHiddenCommands = false;
        }
        if (hasOnlyHiddenCommands) {
            return;
        }
        out.append("\n");
        out.append("\n");
        out.append(this.bundle.getString("USAGE_DESCRIPTION"));
        out.append("\n");
        for (Map.Entry commands : this.commander.getRawCommands().entrySet()) {
            arg = ((JCommander)commands.getValue()).getObjects().get(0);
            p = arg.getClass().getAnnotation(Parameters.class);
            if (p != null && p.hidden()) continue;
            JCommander.ProgramName progName = (JCommander.ProgramName)commands.getKey();
            String dispName = progName.getDisplayName();
            String description = indent + EventUsageFormatter.s((int)4) + dispName + EventUsageFormatter.s((int)6) + this.getCommandDescription(progName.getName());
            this.wrapDescription(out, indentCount + descriptionIndent, description);
            out.append("\n");
            JCommander jc = this.commander.findCommandByAlias(progName.getName());
            jc.setUsageFormatter((IUsageFormatter)new EventUsageFormatter(jc, this.isExport));
            jc.getUsageFormatter().usage(out, indent + EventUsageFormatter.s((int)6));
            out.append("\n");
        }
    }

    private void appendReturnedEvent(StringBuilder out, int indentCount, String indent) {
        out.append(indent).append("  Fires Event: ");
        out.append(this.commander.getMainParameterValue().getDescription());
        out.append("\n");
    }

    private ResourceBundle getBundle() {
        Object firstParameterObject = this.commander.getObjects().get(0);
        Parameters parameters = firstParameterObject.getClass().getAnnotation(Parameters.class);
        return ResourceBundle.getBundle(parameters.resourceBundle(), Locale.getDefault());
    }

    private String getEventDataParameterNames(String names) {
        return Arrays.asList(names.split(", ")).stream().collect(Collectors.joining(", "));
    }

    private static String newLineAndIndent(int indent) {
        return "\n" + EventUsageFormatter.s((int)indent);
    }
}

