/*
 * Decompiled with CFR 0.152.
 */
package libsidplay;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import libsidplay.C64;
import libsidplay.Ultimate64;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Ultimate64Mode;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.c1541.C1541Runner;
import libsidplay.components.c1541.DisconnectedParallelCable;
import libsidplay.components.c1541.DiskImage;
import libsidplay.components.c1541.FloppyType;
import libsidplay.components.c1541.IExtendImageListener;
import libsidplay.components.c1541.IParallelCable;
import libsidplay.components.c1541.SameThreadC1541Runner;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.iec.IECBus;
import libsidplay.components.iec.SerialIECDevice;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos656x.IPALEmulation;
import libsidplay.components.mos656x.IPalette;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.components.printer.mps803.MPS803;
import libsidplay.config.IC1541Section;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.prg2tap.PRG2TAP;
import libsidutils.prg2tap.PRG2TAPProgram;

public class HardwareEnsemble
implements Ultimate64 {
    private final byte[] JIFFYDOS_C64;
    private final byte[] JIFFYDOS_C1541;
    private static byte[] EOD_HACK = new byte[]{-18, -83, 86, 48, -112, 70, 55, -51, 61, 76, -123, -113, 80, -122, 81, -110};
    private static final byte[] EOD_HACK2 = new byte[]{73, -79, -83, 45, 26, 1, 38, -1, 37, -37, -45, 94, 119, 59, -109, -78};
    protected IConfig config;
    protected C64 c64;
    protected Datasette datasette;
    protected IECBus iecBus;
    protected SerialIECDevice[] serialDevices;
    protected C1541[] floppies;
    protected C1541Runner c1541Runner;
    protected MPS803 printer;
    private IExtendImageListener policy;

    public HardwareEnsemble(final IConfig config, Function<EventScheduler, MOS6510> cpuCreator, byte[] charBin, byte[] basicBin, byte[] kernalBin, byte[] jiffyDosC64Bin, byte[] jiffyDosC1541Bin, byte[] c1541Bin, byte[] c1541_IIBin, byte[] mps803CharBin) {
        this.JIFFYDOS_C64 = jiffyDosC64Bin;
        this.JIFFYDOS_C1541 = jiffyDosC1541Bin;
        this.config = config;
        this.iecBus = new IECBus();
        this.printer = new MPS803(this.iecBus, 4, 7, mps803CharBin){

            @Override
            public void setBusy(boolean flag) {
                HardwareEnsemble.this.c64.cia2.setFlag(flag);
            }

            @Override
            public long clk() {
                return HardwareEnsemble.this.c64.context.getTime(Event.Phase.PHI2);
            }
        };
        this.c64 = new C64(cpuCreator, charBin, basicBin, kernalBin){

            @Override
            public void printerUserportWriteData(byte data) {
                if (config.getPrinterSection().isPrinterOn()) {
                    HardwareEnsemble.this.printer.printerUserportWriteData(data);
                }
            }

            @Override
            public void printerUserportWriteStrobe(boolean strobe) {
                if (config.getPrinterSection().isPrinterOn()) {
                    HardwareEnsemble.this.printer.printerUserportWriteStrobe(strobe);
                }
            }

            @Override
            public byte readFromIECBus() {
                if (config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                return HardwareEnsemble.this.iecBus.readFromIECBus();
            }

            @Override
            public void writeToIECBus(byte data) {
                if (config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(1L);
                }
                HardwareEnsemble.this.iecBus.writeToIECBus(data);
            }

            @Override
            public boolean getTapeSense() {
                return HardwareEnsemble.this.datasette.getTapeSense();
            }

            @Override
            public void setMotor(boolean state) {
                HardwareEnsemble.this.datasette.setMotor(state);
            }

            @Override
            public void toggleWriteBit(boolean state) {
                HardwareEnsemble.this.datasette.toggleWriteBit(state);
            }
        };
        this.datasette = new Datasette(this.c64.getEventScheduler()){

            @Override
            public void setFlag(boolean flag) {
                HardwareEnsemble.this.c64.cia1.setFlag(flag);
            }
        };
        C1541 c1541 = new C1541(this.iecBus, 8, FloppyType.C1541, c1541Bin, c1541_IIBin);
        this.floppies = new C1541[]{c1541};
        this.serialDevices = new SerialIECDevice[]{this.printer};
        this.iecBus.setFloppies(this.floppies);
        this.iecBus.setSerialDevices(this.serialDevices);
        this.c1541Runner = new SameThreadC1541Runner(this.c64.getEventScheduler(), c1541.getEventScheduler());
    }

    public final IConfig getConfig() {
        return this.config;
    }

    public final C64 getC64() {
        return this.c64;
    }

    public final Datasette getDatasette() {
        return this.datasette;
    }

    public final C1541[] getFloppies() {
        return this.floppies;
    }

    public final MPS803 getPrinter() {
        return this.printer;
    }

    public void setClock(CPUClock cpuFreq) {
        this.c64.setClock(cpuFreq);
        this.c1541Runner.setClockDivider(cpuFreq);
        for (SerialIECDevice device : this.serialDevices) {
            device.setClock(cpuFreq);
        }
    }

    public void reset() {
        ISidPlay2Section sidplay2section = this.config.getSidplay2Section();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        this.c64.configureVICs(vic -> {
            IPALEmulation palEmulation = vic.getPalEmulation();
            if (palEmulation != PALEmulation.NONE) {
                palEmulation.setPalEmulationEnable(sidplay2section.isPalEmulation());
                IPalette palette = palEmulation.getPalette();
                palette.setBrightness(sidplay2section.getBrightness());
                palette.setContrast(sidplay2section.getContrast());
                palette.setGamma(sidplay2section.getGamma());
                palette.setSaturation(sidplay2section.getSaturation());
                palette.setPhaseShift(sidplay2section.getPhaseShift());
                palette.setOffset(sidplay2section.getOffset());
                palette.setTint(sidplay2section.getTint());
                palette.setLuminanceC(sidplay2section.getBlur());
                palette.setDotCreep(sidplay2section.getBleed());
            }
        });
        IC1541Section c1541Section = this.config.getC1541Section();
        this.c64.setCustomKernal(c1541Section.isJiffyDosInstalled() ? this.JIFFYDOS_C64 : null);
        this.c64.reset();
        this.iecBus.reset();
        this.datasette.reset();
        emulationSection.getOverrideSection().reset();
        for (C1541 floppy : this.floppies) {
            floppy.setRamExpansion(0, c1541Section.isRamExpansion(0));
            floppy.setRamExpansion(1, c1541Section.isRamExpansion(1));
            floppy.setRamExpansion(2, c1541Section.isRamExpansion(2));
            floppy.setRamExpansion(3, c1541Section.isRamExpansion(3));
            floppy.setRamExpansion(4, c1541Section.isRamExpansion(4));
            floppy.setCustomKernalRom(c1541Section.isJiffyDosInstalled() ? this.JIFFYDOS_C1541 : null);
            floppy.setFloppyType(c1541Section.getFloppyType());
            floppy.reset();
        }
        this.enableFloppyDiskDrives(c1541Section.isDriveOn());
        this.connectC64AndC1541WithParallelCable(c1541Section.isParallelCable());
        for (SerialIECDevice serialDevice : this.serialDevices) {
            serialDevice.reset();
        }
        this.enablePrinter(this.config.getPrinterSection().isPrinterOn());
    }

    public final void enableFloppyDiskDrives(boolean on) {
        this.c64.getEventScheduler().scheduleThreadSafe(Event.of("C64-C1541 sync", event -> {
            if (on) {
                this.c1541Runner.reset();
            } else {
                this.c1541Runner.cancel();
            }
            for (C1541 floppy : this.floppies) {
                floppy.setPowerOn(on);
            }
        }));
    }

    public final void connectC64AndC1541WithParallelCable(boolean connected) {
        IParallelCable cable = connected ? this.makeCableBetweenC64AndC1541() : new DisconnectedParallelCable();
        this.c64.setParallelCable(cable);
        for (C1541 floppy : this.floppies) {
            floppy.getBusController().setParallelCable(cable);
        }
    }

    private IParallelCable makeCableBetweenC64AndC1541() {
        return new IParallelCable(){
            protected byte parallelCableCpuValue = (byte)-1;
            protected final byte[] parallelCableDriveValue = new byte[]{-1, -1, -1, -1};

            @Override
            public void driveWrite(byte data, boolean handshake, int dnr) {
                HardwareEnsemble.this.c64.cia2.setFlag(handshake);
                this.parallelCableDriveValue[dnr & 0xFFFFFFF7] = data;
            }

            @Override
            public byte driveRead(boolean handshake) {
                HardwareEnsemble.this.c64.cia2.setFlag(handshake);
                return this.parallelCableValue();
            }

            private byte parallelCableValue() {
                byte val = this.parallelCableCpuValue;
                for (C1541 floppy : HardwareEnsemble.this.floppies) {
                    val = (byte)(val & this.parallelCableDriveValue[floppy.getID() & 0xFFFFFFF7]);
                }
                return val;
            }

            @Override
            public void c64Write(byte data) {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                this.parallelCableCpuValue = data;
            }

            @Override
            public byte c64Read() {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                return this.parallelCableValue();
            }

            @Override
            public void pulse() {
                if (HardwareEnsemble.this.config.getC1541Section().isDriveOn()) {
                    HardwareEnsemble.this.c1541Runner.synchronize(0L);
                }
                for (C1541 floppy : HardwareEnsemble.this.floppies) {
                    floppy.getBusController().signal(2, 0);
                }
            }
        };
    }

    public final void enablePrinter(boolean printerOn) {
        this.printer.turnPrinterOnOff(printerOn);
    }

    public final void setExtendImagePolicy(IExtendImageListener policy) {
        this.policy = policy;
    }

    public final void insertDisk(File file) throws IOException {
        if (this.config.getEmulationSection().getUltimate64Mode() != Ultimate64Mode.OFF) {
            this.sendInsertDisk(this.config, file);
        }
        this.config.getSidplay2Section().setLastDirectory(file.getParentFile());
        if (this.config.getEmulationSection().getUltimate64Mode() != Ultimate64Mode.STANDALONE) {
            this.config.getC1541Section().setDriveOn(true);
            this.enableFloppyDiskDrives(true);
            DiskImage disk = this.floppies[0].getDiskController().insertDisk(file);
            if (this.policy != null) {
                disk.setExtendImagePolicy(this.policy);
            }
            this.installHack(file);
        }
    }

    private void installHack(File file) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                 DigestInputStream dis = new DigestInputStream(is, messageDigest);){
                boolean hack;
                while (dis.read() != -1) {
                }
                byte[] digest = messageDigest.digest();
                boolean bl = hack = Arrays.equals(digest, EOD_HACK) || Arrays.equals(digest, EOD_HACK2);
                if (hack) {
                    System.err.println("Edge of Disgrace hack has been installed!");
                }
                this.c64.getCPU().setEODHack(hack);
            }
        }
        catch (Exception e) {
            System.err.println("Warning: installHack failed: " + e.getMessage());
        }
    }

    public final void insertTape(File file) throws IOException, SidTuneError {
        this.config.getSidplay2Section().setLastDirectory(file.getParentFile());
        if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(".tap")) {
            File convertedTape = new File(this.config.getSidplay2Section().getTmpDir(), file.getName() + ".tap");
            convertedTape.deleteOnExit();
            SidTune prog = SidTune.load(file);
            PRG2TAPProgram program = new PRG2TAPProgram(prog, IOUtils.getFilenameWithoutSuffix(file.getName()));
            PRG2TAP prg2tap = new PRG2TAP();
            prg2tap.setTurboTape(this.config.getSidplay2Section().isTurboTape());
            prg2tap.open();
            prg2tap.add(program);
            prg2tap.close();
            try (FileOutputStream os = new FileOutputStream(convertedTape);){
                ((OutputStream)os).write(prg2tap.getResult());
            }
            this.datasette.insertTape(convertedTape);
        } else {
            this.datasette.insertTape(file);
        }
    }

    public final void insertCartridge(CartridgeType type2, int sizeKB) throws IOException {
        this.c64.ejectCartridge();
        this.c64.setCartridge(type2, sizeKB);
    }

    public final void insertCartridge(CartridgeType type2, File file) throws IOException {
        this.config.getSidplay2Section().setLastDirectory(file.getParentFile());
        this.c64.ejectCartridge();
        this.c64.setCartridge(type2, file);
    }

    public final void insertCartridgeCRT(InputStream is) throws IOException {
        this.config.getC1541Section().setJiffyDosInstalled(false);
        this.c64.ejectCartridge();
        this.c64.setCartridgeCRT(is);
    }
}

