/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported;

import java.io.DataInputStream;
import java.io.IOException;
import libsidplay.components.cart.Cartridge;
import libsidplay.components.pla.Bank;
import libsidplay.components.pla.PLA;

public class Normal
extends Cartridge {
    protected byte[] roml;
    protected byte[] romh;
    private boolean exrom;
    private boolean game;
    private final Bank romlBank = new Bank(){

        @Override
        public byte read(int address) {
            if (Normal.this.roml != null) {
                return Normal.this.roml[address & 0x1FFF];
            }
            return Normal.this.pla.getDisconnectedBusBank().read(address);
        }
    };
    private final Bank romhBank = new Bank(){

        @Override
        public byte read(int address) {
            if (Normal.this.romh != null) {
                return Normal.this.romh[address & 0x1FFF];
            }
            return Normal.this.pla.getDisconnectedBusBank().read(address);
        }
    };

    public Normal(DataInputStream dis, PLA pla) throws IOException {
        super(pla);
        byte[] header = new byte[16];
        dis.readFully(header);
        if (header[14] == 16) {
            byte[] data = new byte[4096];
            dis.readFully(data);
            this.romh = new byte[8192];
            System.arraycopy(data, 0, this.romh, 0, 4096);
            System.arraycopy(data, 0, this.romh, 4096, 4096);
            this.exrom = false;
            this.game = true;
        } else if (header[14] == 32) {
            this.roml = new byte[8192];
            dis.readFully(this.roml);
            this.game = true;
            this.exrom = false;
        } else if (header[14] == 64) {
            this.roml = new byte[8192];
            this.romh = new byte[8192];
            dis.readFully(this.roml);
            dis.readFully(this.romh);
            this.game = false;
            this.exrom = false;
        }
    }

    @Override
    public Bank getRoml() {
        return this.romlBank;
    }

    @Override
    public Bank getRomh() {
        return this.romhBank;
    }

    @Override
    public void reset() {
        super.reset();
        this.pla.setGameExrom(this.game, this.exrom);
    }
}

