/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.EnvelopeGeneratorData;
import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.OPL3Data;
import libsidplay.components.cart.supported.core.OperatorData;

class EnvelopeGenerator {
    static final double[] INFINITY = null;
    Stage stage = Stage.OFF;
    int actualAttackRate = 0;
    int actualDecayRate = 0;
    int actualReleaseRate = 0;
    double xAttackIncrement = 0.0;
    double xMinimumInAttack = 0.0;
    double dBdecayIncrement = 0.0;
    double dBreleaseIncrement = 0.0;
    double attenuation = 0.0;
    double totalLevel = 0.0;
    double sustainLevel = 0.0;
    double x = EnvelopeGenerator.dBtoX(-96.0);
    double envelope = -96.0;

    EnvelopeGenerator() {
    }

    void setActualSustainLevel(int sl) {
        if (sl == 15) {
            this.sustainLevel = -93.0;
            return;
        }
        this.sustainLevel = -3 * sl;
    }

    void setTotalLevel(int tl) {
        this.totalLevel = (double)tl * -0.75;
    }

    void setAtennuation(int f_number, int block, int ksl) {
        int hi4bits = f_number >> 6 & 0xF;
        switch (ksl) {
            case 0: {
                this.attenuation = 0.0;
                break;
            }
            case 1: {
                this.attenuation = OperatorData.ksl3dBtable[hi4bits][block];
                break;
            }
            case 2: {
                this.attenuation = OperatorData.ksl3dBtable[hi4bits][block] / 2.0;
                break;
            }
            case 3: {
                this.attenuation = OperatorData.ksl3dBtable[hi4bits][block] * 2.0;
            }
        }
    }

    void setActualAttackRate(int attackRate, int ksr, int keyScaleNumber) {
        this.actualAttackRate = this.calculateActualRate(attackRate, ksr, keyScaleNumber);
        double period0to100inSeconds = EnvelopeGeneratorData.attackTimeValuesTable[this.actualAttackRate][0] / 1000.0;
        int period0to100inSamples = (int)(period0to100inSeconds * 49700.0);
        double period10to90inSeconds = EnvelopeGeneratorData.attackTimeValuesTable[this.actualAttackRate][1] / 1000.0;
        int period10to90inSamples = (int)(period10to90inSeconds * 49700.0);
        this.xAttackIncrement = OPL3Data.calculateIncrement(EnvelopeGenerator.percentageToX(0.1), EnvelopeGenerator.percentageToX(0.9), period10to90inSeconds);
        int period10to100inSamples = (int)((double)period10to90inSamples + (EnvelopeGenerator.dBtoX(-0.1875) - EnvelopeGenerator.percentageToX(0.9)) / this.xAttackIncrement);
        this.xMinimumInAttack = EnvelopeGenerator.percentageToX(0.1) - (double)(period0to100inSamples - period10to100inSamples) * this.xAttackIncrement;
    }

    void setActualDecayRate(int decayRate, int ksr, int keyScaleNumber) {
        this.actualDecayRate = this.calculateActualRate(decayRate, ksr, keyScaleNumber);
        double period10to90inSeconds = EnvelopeGeneratorData.decayAndReleaseTimeValuesTable[this.actualDecayRate][1] / 1000.0;
        this.dBdecayIncrement = OPL3Data.calculateIncrement(EnvelopeGenerator.percentageToDB(0.1), EnvelopeGenerator.percentageToDB(0.9), period10to90inSeconds);
    }

    void setActualReleaseRate(int releaseRate, int ksr, int keyScaleNumber) {
        this.actualReleaseRate = this.calculateActualRate(releaseRate, ksr, keyScaleNumber);
        double period10to90inSeconds = EnvelopeGeneratorData.decayAndReleaseTimeValuesTable[this.actualReleaseRate][1] / 1000.0;
        this.dBreleaseIncrement = OPL3Data.calculateIncrement(EnvelopeGenerator.percentageToDB(0.1), EnvelopeGenerator.percentageToDB(0.9), period10to90inSeconds);
    }

    private int calculateActualRate(int rate, int ksr, int keyScaleNumber) {
        int rof = EnvelopeGeneratorData.rateOffset[ksr][keyScaleNumber];
        int actualRate = rate * 4 + rof;
        if (actualRate > 63) {
            actualRate = 63;
        }
        return actualRate;
    }

    double getEnvelope(int egt, int am) {
        double envelopeSustainLevel = this.sustainLevel / 2.0;
        double envelopeTremolo = OPL3Data.tremoloTable[OPL3.dam][OPL3.tremoloIndex] / 2.0;
        double envelopeAttenuation = this.attenuation / 2.0;
        double envelopeTotalLevel = this.totalLevel / 2.0;
        double envelopeMinimum = -96.0;
        double envelopeResolution = 0.1875;
        switch (this.stage.ordinal()) {
            case 0: {
                if (this.envelope < -envelopeResolution && this.xAttackIncrement != Double.NEGATIVE_INFINITY) {
                    this.envelope = -Math.pow(2.0, this.x);
                    this.x += this.xAttackIncrement;
                    break;
                }
                this.envelope = 0.0;
                this.stage = Stage.DECAY;
            }
            case 1: {
                if (this.envelope > envelopeSustainLevel) {
                    this.envelope -= this.dBdecayIncrement;
                    break;
                }
                this.stage = Stage.SUSTAIN;
            }
            case 2: {
                if (egt == 1) break;
                if (this.envelope > envelopeMinimum) {
                    this.envelope -= this.dBreleaseIncrement;
                    break;
                }
                this.stage = Stage.OFF;
                break;
            }
            case 3: {
                if (this.envelope > envelopeMinimum) {
                    this.envelope -= this.dBreleaseIncrement;
                    break;
                }
                this.stage = Stage.OFF;
                break;
            }
        }
        double outputEnvelope = this.envelope;
        if (am == 1) {
            outputEnvelope += envelopeTremolo;
        }
        outputEnvelope += envelopeAttenuation;
        return outputEnvelope += envelopeTotalLevel;
    }

    void keyOn() {
        double xCurrent = OperatorData.log2(-this.envelope);
        this.x = xCurrent < this.xMinimumInAttack ? xCurrent : this.xMinimumInAttack;
        this.stage = Stage.ATTACK;
    }

    void keyOff() {
        if (this.stage != Stage.OFF) {
            this.stage = Stage.RELEASE;
        }
    }

    private static double dBtoX(double dB) {
        return OperatorData.log2(-dB);
    }

    private static double percentageToDB(double percentage) {
        return Math.log10(percentage) * 10.0;
    }

    private static double percentageToX(double percentage) {
        return EnvelopeGenerator.dBtoX(EnvelopeGenerator.percentageToDB(percentage));
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Envelope Generator: \n");
        double attackPeriodInSeconds = EnvelopeGeneratorData.attackTimeValuesTable[this.actualAttackRate][0] / 1000.0;
        str.append(String.format("\tATTACK  %f s, rate %d. \n", attackPeriodInSeconds, this.actualAttackRate));
        double decayPeriodInSeconds = EnvelopeGeneratorData.decayAndReleaseTimeValuesTable[this.actualDecayRate][0] / 1000.0;
        str.append(String.format("\tDECAY   %f s, rate %d. \n", decayPeriodInSeconds, this.actualDecayRate));
        str.append(String.format("\tSL      %f dB. \n", this.sustainLevel));
        double releasePeriodInSeconds = EnvelopeGeneratorData.decayAndReleaseTimeValuesTable[this.actualReleaseRate][0] / 1000.0;
        str.append(String.format("\tRELEASE %f s, rate %d. \n", releasePeriodInSeconds, this.actualReleaseRate));
        str.append("\n");
        return str.toString();
    }

    static enum Stage {
        ATTACK,
        DECAY,
        SUSTAIN,
        RELEASE,
        OFF;

    }
}

