/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.BassDrumChannel;
import libsidplay.components.cart.supported.core.Channel;
import libsidplay.components.cart.supported.core.Channel2op;
import libsidplay.components.cart.supported.core.Channel4op;
import libsidplay.components.cart.supported.core.DisabledChannel;
import libsidplay.components.cart.supported.core.HighHatOperator;
import libsidplay.components.cart.supported.core.HighHatSnareDrumChannel;
import libsidplay.components.cart.supported.core.OPL3Data;
import libsidplay.components.cart.supported.core.Operator;
import libsidplay.components.cart.supported.core.SnareDrumOperator;
import libsidplay.components.cart.supported.core.TomTomOperator;
import libsidplay.components.cart.supported.core.TomTomTopCymbalChannel;
import libsidplay.components.cart.supported.core.TopCymbalOperator;

public final class OPL3 {
    static int[] registers = new int[512];
    static Operator[][] operators;
    static Channel2op[][] channels2op;
    static Channel4op[][] channels4op;
    static Channel[][] channels;
    static DisabledChannel disabledChannel;
    static BassDrumChannel bassDrumChannel;
    static HighHatSnareDrumChannel highHatSnareDrumChannel;
    static TomTomTopCymbalChannel tomTomTopCymbalChannel;
    static HighHatOperator highHatOperator;
    static SnareDrumOperator snareDrumOperator;
    static TomTomOperator tomTomOperator;
    static TopCymbalOperator topCymbalOperator;
    static Operator highHatOperatorInNonRhythmMode;
    static Operator snareDrumOperatorInNonRhythmMode;
    static Operator tomTomOperatorInNonRhythmMode;
    static Operator topCymbalOperatorInNonRhythmMode;
    static int nts;
    static int dam;
    static int dvb;
    static int ryt;
    static int bd;
    static int sd;
    static int tom;
    static int tc;
    static int hh;
    static int _new;
    static int connectionsel;
    static int vibratoIndex;
    static int tremoloIndex;

    public short[] read() {
        int outputChannelNumber;
        short[] output = new short[4];
        double[] outputBuffer = new double[4];
        for (outputChannelNumber = 0; outputChannelNumber < 4; ++outputChannelNumber) {
            outputBuffer[outputChannelNumber] = 0.0;
        }
        for (int array = 0; array < _new + 1; ++array) {
            for (int channelNumber = 0; channelNumber < 9; ++channelNumber) {
                double[] channelOutput = channels[array][channelNumber].getChannelOutput();
                for (int outputChannelNumber2 = 0; outputChannelNumber2 < 4; ++outputChannelNumber2) {
                    int n = outputChannelNumber2;
                    outputBuffer[n] = outputBuffer[n] + channelOutput[outputChannelNumber2];
                }
            }
        }
        for (outputChannelNumber = 0; outputChannelNumber < 4; ++outputChannelNumber) {
            output[outputChannelNumber] = (short)(outputBuffer[outputChannelNumber] / 18.0 * 32767.0);
        }
        if (++vibratoIndex >= OPL3Data.vibratoTable[dvb].length) {
            vibratoIndex = 0;
        }
        if (++tremoloIndex >= OPL3Data.tremoloTable[dam].length) {
            tremoloIndex = 0;
        }
        return output;
    }

    public void write(int array, int address, int data) {
        int registerAddress = array << 8 | address;
        if (registerAddress < 0 || registerAddress >= 512) {
            return;
        }
        OPL3.registers[registerAddress] = data;
        block0 : switch (address & 0xE0) {
            case 0: {
                if (array == 1) {
                    if (address == 4) {
                        this.update_2_CONNECTIONSEL6();
                        break;
                    }
                    if (address != 5) break;
                    this.update_7_NEW1();
                    break;
                }
                if (address != 8) break;
                this.update_1_NTS1_6();
                break;
            }
            case 160: {
                if (address == 189) {
                    if (array != 0) break;
                    this.update_DAM1_DVB1_RYT1_BD1_SD1_TOM1_TC1_HH1();
                    break;
                }
                if ((address & 0xF0) == 176 && address <= 184) {
                    channels[array][address & 0xF].update_2_KON1_BLOCK3_FNUMH2();
                    break;
                }
                if ((address & 0xF0) != 160 || address > 168) break;
                channels[array][address & 0xF].update_FNUML8();
                break;
            }
            case 192: {
                if (address > 200) break;
                channels[array][address & 0xF].update_CHD1_CHC1_CHB1_CHA1_FB3_CNT1();
                break;
            }
            default: {
                int operatorOffset = address & 0x1F;
                if (operators[array][operatorOffset] == null) break;
                switch (address & 0xE0) {
                    case 32: {
                        operators[array][operatorOffset].update_AM1_VIB1_EGT1_KSR1_MULT4();
                        break block0;
                    }
                    case 64: {
                        operators[array][operatorOffset].update_KSL2_TL6();
                        break block0;
                    }
                    case 96: {
                        operators[array][operatorOffset].update_AR4_DR4();
                        break block0;
                    }
                    case 128: {
                        operators[array][operatorOffset].update_SL4_RR4();
                        break block0;
                    }
                    case 224: {
                        operators[array][operatorOffset].update_5_WS3();
                    }
                }
            }
        }
    }

    public OPL3() {
        connectionsel = 0;
        _new = 0;
        hh = 0;
        tc = 0;
        tom = 0;
        sd = 0;
        bd = 0;
        ryt = 0;
        dvb = 0;
        dam = 0;
        nts = 0;
        tremoloIndex = 0;
        vibratoIndex = 0;
        channels = new Channel[2][9];
        this.initOperators();
        this.initChannels2op();
        this.initChannels4op();
        this.initRhythmChannels();
        this.initChannels();
    }

    private void initOperators() {
        operators = new Operator[2][32];
        for (int array = 0; array < 2; ++array) {
            for (int group = 0; group <= 16; group += 8) {
                for (int offset = 0; offset < 6; ++offset) {
                    int baseAddress = array << 8 | group + offset;
                    OPL3.operators[array][group + offset] = new Operator(baseAddress);
                }
            }
        }
        highHatOperator = new HighHatOperator();
        snareDrumOperator = new SnareDrumOperator();
        tomTomOperator = new TomTomOperator();
        topCymbalOperator = new TopCymbalOperator();
        highHatOperatorInNonRhythmMode = operators[0][17];
        snareDrumOperatorInNonRhythmMode = operators[0][20];
        tomTomOperatorInNonRhythmMode = operators[0][18];
        topCymbalOperatorInNonRhythmMode = operators[0][21];
    }

    private void initChannels2op() {
        channels2op = new Channel2op[2][9];
        for (int array = 0; array < 2; ++array) {
            for (int channelNumber = 0; channelNumber < 3; ++channelNumber) {
                int baseAddress = array << 8 | channelNumber;
                OPL3.channels2op[array][channelNumber] = new Channel2op(baseAddress, operators[array][channelNumber], operators[array][channelNumber + 3]);
                OPL3.channels2op[array][channelNumber + 3] = new Channel2op(baseAddress + 3, operators[array][channelNumber + 8], operators[array][channelNumber + 11]);
                OPL3.channels2op[array][channelNumber + 6] = new Channel2op(baseAddress + 6, operators[array][channelNumber + 16], operators[array][channelNumber + 19]);
            }
        }
    }

    private void initChannels4op() {
        channels4op = new Channel4op[2][3];
        for (int array = 0; array < 2; ++array) {
            for (int channelNumber = 0; channelNumber < 3; ++channelNumber) {
                int baseAddress = array << 8 | channelNumber;
                OPL3.channels4op[array][channelNumber] = new Channel4op(baseAddress, operators[array][channelNumber], operators[array][channelNumber + 3], operators[array][channelNumber + 8], operators[array][channelNumber + 11]);
            }
        }
    }

    private void initRhythmChannels() {
        bassDrumChannel = new BassDrumChannel();
        highHatSnareDrumChannel = new HighHatSnareDrumChannel();
        tomTomTopCymbalChannel = new TomTomTopCymbalChannel();
    }

    private void initChannels() {
        for (int array = 0; array < 2; ++array) {
            for (int i = 0; i < 9; ++i) {
                OPL3.channels[array][i] = channels2op[array][i];
            }
        }
        disabledChannel = new DisabledChannel();
    }

    private void update_1_NTS1_6() {
        int _1_nts1_6 = registers[8];
        nts = (_1_nts1_6 & 0x40) >> 6;
    }

    private void update_DAM1_DVB1_RYT1_BD1_SD1_TOM1_TC1_HH1() {
        int new_hh;
        int new_tc;
        int new_tom;
        int new_sd;
        int new_bd;
        int dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 = registers[189];
        dam = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 0x80) >> 7;
        dvb = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 0x40) >> 6;
        int new_ryt = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 0x20) >> 5;
        if (new_ryt != ryt) {
            ryt = new_ryt;
            this.setRhythmMode();
        }
        if ((new_bd = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 0x10) >> 4) != bd && (bd = new_bd) == 1) {
            OPL3.bassDrumChannel.op1.keyOn();
            OPL3.bassDrumChannel.op2.keyOn();
        }
        if ((new_sd = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 8) >> 3) != sd && (sd = new_sd) == 1) {
            snareDrumOperator.keyOn();
        }
        if ((new_tom = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 4) >> 2) != tom && (tom = new_tom) == 1) {
            tomTomOperator.keyOn();
        }
        if ((new_tc = (dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 2) >> 1) != tc && (tc = new_tc) == 1) {
            topCymbalOperator.keyOn();
        }
        if ((new_hh = dam1_dvb1_ryt1_bd1_sd1_tom1_tc1_hh1 & 1) != hh && (hh = new_hh) == 1) {
            highHatOperator.keyOn();
        }
    }

    private void update_7_NEW1() {
        int _7_new1 = registers[261];
        _new = _7_new1 & 1;
        if (_new == 1) {
            this.setEnabledChannels();
        }
        this.set4opConnections();
    }

    private void setEnabledChannels() {
        for (int array = 0; array < 2; ++array) {
            for (int i = 0; i < 9; ++i) {
                int baseAddress = OPL3.channels[array][i].channelBaseAddress;
                int n = baseAddress + 192;
                registers[n] = registers[n] | 0xF0;
                channels[array][i].update_CHD1_CHC1_CHB1_CHA1_FB3_CNT1();
            }
        }
    }

    private void update_2_CONNECTIONSEL6() {
        int _2_connectionsel6 = registers[260];
        connectionsel = _2_connectionsel6 & 0x3F;
        this.set4opConnections();
    }

    private void set4opConnections() {
        for (int array = 0; array < 2; ++array) {
            for (int i = 0; i < 3; ++i) {
                int shift;
                int connectionBit;
                if (_new == 1 && (connectionBit = connectionsel >> (shift = array * 3 + i) & 1) == 1) {
                    OPL3.channels[array][i] = channels4op[array][i];
                    OPL3.channels[array][i + 3] = disabledChannel;
                    channels[array][i].updateChannel();
                    continue;
                }
                OPL3.channels[array][i] = channels2op[array][i];
                OPL3.channels[array][i + 3] = channels2op[array][i + 3];
                channels[array][i].updateChannel();
                channels[array][i + 3].updateChannel();
            }
        }
    }

    private void setRhythmMode() {
        int i;
        if (ryt == 1) {
            OPL3.channels[0][6] = bassDrumChannel;
            OPL3.channels[0][7] = highHatSnareDrumChannel;
            OPL3.channels[0][8] = tomTomTopCymbalChannel;
            OPL3.operators[0][17] = highHatOperator;
            OPL3.operators[0][20] = snareDrumOperator;
            OPL3.operators[0][18] = tomTomOperator;
            OPL3.operators[0][21] = topCymbalOperator;
        } else {
            for (i = 6; i <= 8; ++i) {
                OPL3.channels[0][i] = channels2op[0][i];
            }
            OPL3.operators[0][17] = highHatOperatorInNonRhythmMode;
            OPL3.operators[0][20] = snareDrumOperatorInNonRhythmMode;
            OPL3.operators[0][18] = tomTomOperatorInNonRhythmMode;
            OPL3.operators[0][21] = topCymbalOperatorInNonRhythmMode;
        }
        for (i = 6; i <= 8; ++i) {
            channels[0][i].updateChannel();
        }
    }
}

