/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.EnvelopeGenerator;
import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.OperatorData;
import libsidplay.components.cart.supported.core.PhaseGenerator;

class Operator {
    PhaseGenerator phaseGenerator;
    EnvelopeGenerator envelopeGenerator;
    double envelope;
    double phase;
    int operatorBaseAddress;
    int am;
    int vib;
    int ksr;
    int egt;
    int mult;
    int ksl;
    int tl;
    int ar;
    int dr;
    int sl;
    int rr;
    int ws;
    int keyScaleNumber;
    int f_number;
    int block;
    static final double noModulator = 0.0;

    Operator(int baseAddress) {
        this.operatorBaseAddress = baseAddress;
        this.phaseGenerator = new PhaseGenerator();
        this.envelopeGenerator = new EnvelopeGenerator();
        this.envelope = 0.0;
        this.ws = 0;
        this.rr = 0;
        this.sl = 0;
        this.dr = 0;
        this.ar = 0;
        this.tl = 0;
        this.ksl = 0;
        this.mult = 0;
        this.egt = 0;
        this.ksr = 0;
        this.vib = 0;
        this.am = 0;
        this.block = 0;
        this.f_number = 0;
        this.keyScaleNumber = 0;
    }

    void update_AM1_VIB1_EGT1_KSR1_MULT4() {
        int am1_vib1_egt1_ksr1_mult4 = OPL3.registers[this.operatorBaseAddress + 32];
        this.am = (am1_vib1_egt1_ksr1_mult4 & 0x80) >> 7;
        this.vib = (am1_vib1_egt1_ksr1_mult4 & 0x40) >> 6;
        this.egt = (am1_vib1_egt1_ksr1_mult4 & 0x20) >> 5;
        this.ksr = (am1_vib1_egt1_ksr1_mult4 & 0x10) >> 4;
        this.mult = am1_vib1_egt1_ksr1_mult4 & 0xF;
        this.phaseGenerator.setFrequency(this.f_number, this.block, this.mult);
        this.envelopeGenerator.setActualAttackRate(this.ar, this.ksr, this.keyScaleNumber);
        this.envelopeGenerator.setActualDecayRate(this.dr, this.ksr, this.keyScaleNumber);
        this.envelopeGenerator.setActualReleaseRate(this.rr, this.ksr, this.keyScaleNumber);
    }

    void update_KSL2_TL6() {
        int ksl2_tl6 = OPL3.registers[this.operatorBaseAddress + 64];
        this.ksl = (ksl2_tl6 & 0xC0) >> 6;
        this.tl = ksl2_tl6 & 0x3F;
        this.envelopeGenerator.setAtennuation(this.f_number, this.block, this.ksl);
        this.envelopeGenerator.setTotalLevel(this.tl);
    }

    void update_AR4_DR4() {
        int ar4_dr4 = OPL3.registers[this.operatorBaseAddress + 96];
        this.ar = (ar4_dr4 & 0xF0) >> 4;
        this.dr = ar4_dr4 & 0xF;
        this.envelopeGenerator.setActualAttackRate(this.ar, this.ksr, this.keyScaleNumber);
        this.envelopeGenerator.setActualDecayRate(this.dr, this.ksr, this.keyScaleNumber);
    }

    void update_SL4_RR4() {
        int sl4_rr4 = OPL3.registers[this.operatorBaseAddress + 128];
        this.sl = (sl4_rr4 & 0xF0) >> 4;
        this.rr = sl4_rr4 & 0xF;
        this.envelopeGenerator.setActualSustainLevel(this.sl);
        this.envelopeGenerator.setActualReleaseRate(this.rr, this.ksr, this.keyScaleNumber);
    }

    void update_5_WS3() {
        int _5_ws3 = OPL3.registers[this.operatorBaseAddress + 224];
        this.ws = _5_ws3 & 7;
    }

    double getOperatorOutput(double modulator) {
        if (this.envelopeGenerator.stage == EnvelopeGenerator.Stage.OFF) {
            return 0.0;
        }
        double envelopeInDB = this.envelopeGenerator.getEnvelope(this.egt, this.am);
        this.envelope = Math.pow(10.0, envelopeInDB / 10.0);
        this.ws &= (OPL3._new << 2) + 3;
        double[] waveform = OperatorData.waveforms[this.ws];
        this.phase = this.phaseGenerator.getPhase(this.vib);
        double operatorOutput = this.getOutput(modulator, this.phase, waveform);
        return operatorOutput;
    }

    protected double getOutput(double modulator, double outputPhase, double[] waveform) {
        if ((outputPhase = (outputPhase + modulator) % 1.0) < 0.0) {
            outputPhase += 1.0;
            outputPhase %= 1.0;
        }
        int sampleIndex = (int)(outputPhase * 1024.0);
        return waveform[sampleIndex] * this.envelope;
    }

    protected void keyOn() {
        if (this.ar > 0) {
            this.envelopeGenerator.keyOn();
            this.phaseGenerator.keyOn();
        } else {
            this.envelopeGenerator.stage = EnvelopeGenerator.Stage.OFF;
        }
    }

    protected void keyOff() {
        this.envelopeGenerator.keyOff();
    }

    protected void updateOperator(int ksn, int f_num, int blk) {
        this.keyScaleNumber = ksn;
        this.f_number = f_num;
        this.block = blk;
        this.update_AM1_VIB1_EGT1_KSR1_MULT4();
        this.update_KSL2_TL6();
        this.update_AR4_DR4();
        this.update_SL4_RR4();
        this.update_5_WS3();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        double operatorFrequency = (double)this.f_number * Math.pow(2.0, this.block - 1) * 49700.0 / Math.pow(2.0, 19.0) * OperatorData.multTable[this.mult];
        str.append(String.format("operatorBaseAddress: %d\n", this.operatorBaseAddress));
        str.append(String.format("operatorFrequency: %f\n", operatorFrequency));
        str.append(String.format("mult: %d, ar: %d, dr: %d, sl: %d, rr: %d, ws: %d\n", this.mult, this.ar, this.dr, this.sl, this.rr, this.ws));
        str.append(String.format("am: %d, vib: %d, ksr: %d, egt: %d, ksl: %d, tl: %d\n", this.am, this.vib, this.ksr, this.egt, this.ksl, this.tl));
        return str.toString();
    }
}

