/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

class OperatorData {
    static final int AM1_VIB1_EGT1_KSR1_MULT4_Offset = 32;
    static final int KSL2_TL6_Offset = 64;
    static final int AR4_DR4_Offset = 96;
    static final int SL4_RR4_Offset = 128;
    static final int _5_WS3_Offset = 224;
    static final int waveLength = 1024;
    static final double[] multTable = new double[]{0.5, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 10.0, 12.0, 12.0, 15.0, 15.0};
    static final double[][] ksl3dBtable = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, -3.0, -6.0, -9.0}, {0.0, 0.0, 0.0, 0.0, -3.0, -6.0, -9.0, -12.0}, {0.0, 0.0, 0.0, -1.875, -4.875, -7.875, -10.875, -13.875}, {0.0, 0.0, 0.0, -3.0, -6.0, -9.0, -12.0, -15.0}, {0.0, 0.0, -1.125, -4.125, -7.125, -10.125, -13.125, -16.125}, {0.0, 0.0, -1.875, -4.875, -7.875, -10.875, -13.875, -16.875}, {0.0, 0.0, -2.625, -5.625, -8.625, -11.625, -14.625, -17.625}, {0.0, 0.0, -3.0, -6.0, -9.0, -12.0, -15.0, -18.0}, {0.0, -0.75, -3.75, -6.75, -9.75, -12.75, -15.75, -18.75}, {0.0, -1.125, -4.125, -7.125, -10.125, -13.125, -16.125, -19.125}, {0.0, -1.5, -4.5, -7.5, -10.5, -13.5, -16.5, -19.5}, {0.0, -1.875, -4.875, -7.875, -10.875, -13.875, -16.875, -19.875}, {0.0, -2.25, -5.25, -8.25, -11.25, -14.25, -17.25, -20.25}, {0.0, -2.625, -5.625, -8.625, -11.625, -14.625, -17.625, -20.625}, {0.0, -3.0, -6.0, -9.0, -12.0, -15.0, -18.0, -21.0}};
    static double[][] waveforms;

    OperatorData() {
    }

    private static void loadWaveforms() {
        waveforms = new double[8][1024];
        double theta = 0.0;
        double thetaIncrement = 0.006135923151542565;
        int i = 0;
        theta = 0.0;
        while (i < 1024) {
            OperatorData.waveforms[0][i] = Math.sin(theta);
            ++i;
            theta += thetaIncrement;
        }
        double[] sineTable = waveforms[0];
        for (i = 0; i < 512; ++i) {
            OperatorData.waveforms[1][i] = sineTable[i];
            OperatorData.waveforms[1][512 + i] = 0.0;
        }
        for (i = 0; i < 512; ++i) {
            double d = sineTable[i];
            OperatorData.waveforms[2][512 + i] = d;
            OperatorData.waveforms[2][i] = d;
        }
        for (i = 0; i < 256; ++i) {
            double d = sineTable[i];
            OperatorData.waveforms[3][512 + i] = d;
            OperatorData.waveforms[3][i] = d;
            OperatorData.waveforms[3][768 + i] = 0.0;
            OperatorData.waveforms[3][256 + i] = 0.0;
        }
        for (i = 0; i < 512; ++i) {
            OperatorData.waveforms[4][i] = sineTable[i * 2];
            OperatorData.waveforms[4][512 + i] = 0.0;
        }
        for (i = 0; i < 256; ++i) {
            double d = sineTable[i * 2];
            OperatorData.waveforms[5][256 + i] = d;
            OperatorData.waveforms[5][i] = d;
            OperatorData.waveforms[5][768 + i] = 0.0;
            OperatorData.waveforms[5][512 + i] = 0.0;
        }
        for (i = 0; i < 512; ++i) {
            OperatorData.waveforms[6][i] = 1.0;
            OperatorData.waveforms[6][512 + i] = -1.0;
        }
        double xIncrement = 0.0625;
        i = 0;
        double x = 0.0;
        while (i < 512) {
            OperatorData.waveforms[7][i] = Math.pow(2.0, -x);
            OperatorData.waveforms[7][1023 - i] = -Math.pow(2.0, -(x + 0.0625));
            ++i;
            x += xIncrement;
        }
    }

    static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    static {
        OperatorData.loadWaveforms();
    }

    static enum type {
        NO_MODULATION,
        CARRIER,
        FEEDBACK;

    }
}

