/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.cart.supported.core;

import libsidplay.components.cart.supported.core.OPL3;
import libsidplay.components.cart.supported.core.Operator;
import libsidplay.components.cart.supported.core.OperatorData;

class TopCymbalOperator
extends Operator {
    static final int topCymbalOperatorBaseAddress = 21;

    TopCymbalOperator(int baseAddress) {
        super(baseAddress);
    }

    TopCymbalOperator() {
        this(21);
    }

    @Override
    double getOperatorOutput(double modulator) {
        double highHatOperatorPhase = OPL3.highHatOperator.phase * OperatorData.multTable[OPL3.highHatOperator.mult];
        return this.getOperatorOutput(modulator, highHatOperatorPhase);
    }

    protected double getOperatorOutput(double modulator, double externalPhase) {
        double envelopeInDB = this.envelopeGenerator.getEnvelope(this.egt, this.am);
        this.envelope = Math.pow(10.0, envelopeInDB / 10.0);
        this.phase = this.phaseGenerator.getPhase(this.vib);
        int waveIndex = this.ws & (OPL3._new << 2) + 3;
        double[] waveform = OperatorData.waveforms[waveIndex];
        double carrierPhase = 8.0 * this.phase % 1.0;
        double modulatorPhase = externalPhase;
        double modulatorOutput = this.getOutput(0.0, modulatorPhase, waveform);
        double carrierOutput = this.getOutput(modulatorOutput, carrierPhase, waveform);
        int cycles = 4;
        if (carrierPhase * (double)cycles % (double)cycles > 0.1) {
            carrierOutput = 0.0;
        }
        return carrierOutput * 2.0;
    }
}

