/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos6510;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;

public class MOS6510 {
    public static final int SR_INTERRUPT = 2;
    protected static final byte SP_PAGE = 1;
    private static final int MAX = 65536;
    private boolean EOD;
    private static final int ANE_CONST = 238;
    protected final EventScheduler context;
    private boolean rdy;
    private final Runnable[] instrTable = new Runnable[2048];
    private final boolean[] processorCycleNoSteal = new boolean[this.instrTable.length];
    protected int cycleCount;
    protected int Cycle_EffectiveAddress;
    protected int Cycle_HighByteWrongEffectiveAddress;
    protected int Register_ProgramCounter;
    protected int Cycle_Pointer;
    protected byte Cycle_Data;
    protected byte Register_Accumulator;
    protected byte Register_X;
    protected byte Register_Y;
    protected byte Register_StackPointer;
    protected boolean flagN;
    protected boolean flagC;
    protected boolean flagD;
    protected boolean flagZ;
    protected boolean flagV;
    protected boolean flagI;
    protected boolean flagU;
    protected boolean flagB;
    protected Function<Boolean, Boolean> v = Function.identity();
    protected Consumer<Integer> jmpJsr = null;
    protected Function<Integer, Byte> cpuRead;
    protected BiConsumer<Integer, Byte> cpuWrite;
    protected boolean irqAssertedOnPin;
    protected int interruptCycle;
    protected boolean nmiFlag;
    protected boolean rstFlag;
    private final Event eventWithoutSteals;
    private final Event eventWithSteals;

    public void setMemoryHandler(Function<Integer, Byte> cpuRead, BiConsumer<Integer, Byte> cpuWrite) {
        this.cpuRead = cpuRead;
        this.cpuWrite = cpuWrite;
    }

    public void setJmpJsrHandler(Consumer<Integer> jmpJsr) {
        this.jmpJsr = jmpJsr;
    }

    public void setVFlagHandler(Function<Boolean, Boolean> v) {
        this.v = v;
    }

    public void setFlagV(boolean flag) {
        this.flagV = flag;
    }

    protected void calculateInterruptTriggerCycle() {
        if (this.interruptCycle == 65536 && (this.rstFlag || this.nmiFlag || !this.flagI && this.irqAssertedOnPin)) {
            this.interruptCycle = this.cycleCount;
        }
    }

    private void Initialise() {
        assert (this.cpuRead != null && this.cpuWrite != null);
        this.Register_StackPointer = (byte)-1;
        this.flagB = true;
        this.flagU = true;
        this.flagI = false;
        this.flagZ = false;
        this.flagV = false;
        this.flagD = false;
        this.flagC = false;
        this.flagN = false;
        this.Register_ProgramCounter = 0;
        this.irqAssertedOnPin = false;
        this.nmiFlag = false;
        this.rstFlag = false;
        this.interruptCycle = 65536;
        this.rdy = true;
        this.context.schedule(this.eventWithoutSteals, 0L, Event.Phase.PHI2);
    }

    protected void interruptsAndNextOpcode() {
        if (this.cycleCount > this.interruptCycle + 2) {
            this.interrupt();
        } else {
            this.fetchNextOpcode();
        }
    }

    protected void interrupt() {
        this.cpuRead.apply(this.Register_ProgramCounter);
        this.cycleCount = 0;
        this.flagB = false;
        this.interruptCycle = 65536;
    }

    protected void interruptEnd() {
        this.Register_ProgramCounter = this.Cycle_EffectiveAddress;
        this.interruptsAndNextOpcode();
    }

    protected void fetchNextOpcode() {
        this.cycleCount = (this.cpuRead.apply(this.Register_ProgramCounter) & 0xFF) << 3;
        this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
        if (!(this.rstFlag || this.nmiFlag || !this.flagI && this.irqAssertedOnPin)) {
            this.interruptCycle = 65536;
        }
        if (this.interruptCycle != 65536) {
            this.interruptCycle = -65536;
        }
    }

    protected void FetchLowAddr() {
        this.Cycle_EffectiveAddress = this.cpuRead.apply(this.Register_ProgramCounter) & 0xFF;
        this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
    }

    protected void FetchLowAddrX() {
        this.FetchLowAddr();
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + this.Register_X & 0xFF;
    }

    protected void FetchLowAddrY() {
        this.FetchLowAddr();
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + this.Register_Y & 0xFF;
    }

    protected void FetchHighAddr() {
        this.Cycle_EffectiveAddress |= (this.cpuRead.apply(this.Register_ProgramCounter) & 0xFF) << 8;
        this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
    }

    protected void FetchHighAddrX() {
        this.FetchHighAddr();
        this.Cycle_HighByteWrongEffectiveAddress = this.Cycle_EffectiveAddress & 0xFF00 | this.Cycle_EffectiveAddress + this.Register_X & 0xFF;
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + (this.Register_X & 0xFF) & 0xFFFF;
    }

    protected void FetchHighAddrY() {
        this.FetchHighAddr();
        this.Cycle_HighByteWrongEffectiveAddress = this.Cycle_EffectiveAddress & 0xFF00 | this.Cycle_EffectiveAddress + this.Register_Y & 0xFF;
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + (this.Register_Y & 0xFF) & 0xFFFF;
    }

    protected void FetchLowEffAddr() {
        this.Cycle_EffectiveAddress = this.cpuRead.apply(this.Cycle_Pointer) & 0xFF;
    }

    protected void FetchHighEffAddr() {
        this.Cycle_Pointer = this.Cycle_Pointer & 0xFF00 | this.Cycle_Pointer + 1 & 0xFF;
        this.Cycle_EffectiveAddress |= (this.cpuRead.apply(this.Cycle_Pointer) & 0xFF) << 8;
    }

    protected void FetchHighEffAddrY() {
        this.FetchHighEffAddr();
        this.Cycle_HighByteWrongEffectiveAddress = this.Cycle_EffectiveAddress & 0xFF00 | this.Cycle_EffectiveAddress + this.Register_Y & 0xFF;
        this.Cycle_EffectiveAddress = this.Cycle_EffectiveAddress + (this.Register_Y & 0xFF) & 0xFFFF;
    }

    protected void FetchLowPointer() {
        this.Cycle_Pointer = this.cpuRead.apply(this.Register_ProgramCounter) & 0xFF;
        this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
    }

    protected void FetchHighPointer() {
        this.Cycle_Pointer |= (this.cpuRead.apply(this.Register_ProgramCounter) & 0xFF) << 8;
        this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
    }

    protected void PutEffAddrDataByte() {
        this.cpuWrite.accept(this.Cycle_EffectiveAddress, this.Cycle_Data);
    }

    protected void PushLowPC() {
        this.cpuWrite.accept(0x100 | this.Register_StackPointer & 0xFF, (byte)(this.Register_ProgramCounter & 0xFF));
        this.Register_StackPointer = (byte)(this.Register_StackPointer - 1);
    }

    protected void PushHighPC() {
        this.cpuWrite.accept(0x100 | this.Register_StackPointer & 0xFF, (byte)(this.Register_ProgramCounter >> 8));
        this.Register_StackPointer = (byte)(this.Register_StackPointer - 1);
    }

    protected void PushSR() {
        this.cpuWrite.accept(0x100 | this.Register_StackPointer & 0xFF, this.getStatusRegister());
        this.Register_StackPointer = (byte)(this.Register_StackPointer - 1);
    }

    protected void PopLowPC() {
        this.Register_StackPointer = (byte)(this.Register_StackPointer + 1);
        this.Cycle_EffectiveAddress = this.cpuRead.apply(0x100 | this.Register_StackPointer & 0xFF) & 0xFF;
    }

    protected void PopHighPC() {
        this.Register_StackPointer = (byte)(this.Register_StackPointer + 1);
        this.Cycle_EffectiveAddress |= (this.cpuRead.apply(0x100 | this.Register_StackPointer & 0xFF) & 0xFF) << 8;
    }

    protected void PopSR() {
        this.Register_StackPointer = (byte)(this.Register_StackPointer + 1);
        this.setStatusRegister(this.cpuRead.apply(0x100 | this.Register_StackPointer & 0xFF));
        this.flagU = true;
        this.flagB = true;
    }

    protected void doADC() {
        int C = this.flagC ? 1 : 0;
        int A = this.Register_Accumulator & 0xFF;
        int s = this.Cycle_Data & 0xFF;
        int regAC2 = A + s + C;
        if (this.flagD) {
            int lo = (A & 0xF) + (s & 0xF) + C;
            int hi = (A & 0xF0) + (s & 0xF0);
            if (lo > 9) {
                lo += 6;
            }
            if (lo > 15) {
                hi += 16;
            }
            this.flagZ = (regAC2 & 0xFF) == 0;
            this.flagN = (hi & 0x80) != 0;
            this.flagV = this.v.apply(((hi ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) == 0);
            if (hi > 144) {
                hi += 96;
            }
            this.flagC = hi > 255;
            this.Register_Accumulator = (byte)(hi & 0xF0 | lo & 0xF);
        } else {
            this.flagC = regAC2 > 255;
            this.flagV = this.v.apply(((regAC2 ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) == 0);
            this.Register_Accumulator = (byte)regAC2;
            this.setFlagsNZ(this.Register_Accumulator);
        }
    }

    protected void doSBC() {
        int C = this.flagC ? 0 : 1;
        int A = this.Register_Accumulator & 0xFF;
        int s = this.Cycle_Data & 0xFF;
        int regAC2 = A - s - C;
        this.flagC = regAC2 >= 0;
        this.flagV = this.v.apply(((regAC2 ^ A) & 0x80) != 0 && ((A ^ s) & 0x80) != 0);
        this.setFlagsNZ((byte)regAC2);
        if (this.flagD) {
            int lo = (A & 0xF) - (s & 0xF) - C;
            int hi = (A & 0xF0) - (s & 0xF0);
            if ((lo & 0x10) != 0) {
                lo -= 6;
                hi -= 16;
            }
            if ((hi & 0x100) != 0) {
                hi -= 96;
            }
            this.Register_Accumulator = (byte)(hi & 0xF0 | lo & 0xF);
        } else {
            this.Register_Accumulator = (byte)regAC2;
        }
    }

    public MOS6510(EventScheduler context) {
        this.context = context;
        this.eventWithoutSteals = Event.of("CPU-nosteal", event -> {
            this.instrTable[this.cycleCount++].run();
            context.schedule((Event)event, 1L);
        });
        this.eventWithSteals = Event.of("CPU-steal", event -> {
            if (this.processorCycleNoSteal[this.cycleCount]) {
                this.instrTable[this.cycleCount++].run();
                context.schedule((Event)event, 1L);
            } else if (this.interruptCycle == this.cycleCount) {
                --this.interruptCycle;
            }
        });
        this.Register_Accumulator = 0;
        this.Register_X = 0;
        this.Register_Y = 0;
        this.Cycle_EffectiveAddress = 0;
        this.Cycle_Data = 0;
        this.buildInstr();
    }

    private void buildInstr() {
        Runnable wastedStealable = () -> {};
        Runnable throwAwayReadStealable = () -> this.cpuRead.apply(this.Cycle_HighByteWrongEffectiveAddress);
        Runnable writeToEffectiveAddress = () -> this.PutEffAddrDataByte();
        for (int i = 0; i < 256; ++i) {
            int buildCycle = i << 3;
            AccessMode access = AccessMode.WRITE;
            boolean legalMode = true;
            boolean legalInstr = true;
            switch (i) {
                case 8: 
                case 10: 
                case 24: 
                case 26: 
                case 40: 
                case 42: 
                case 56: 
                case 58: 
                case 72: 
                case 74: 
                case 88: 
                case 90: 
                case 104: 
                case 106: 
                case 120: 
                case 122: 
                case 136: 
                case 138: 
                case 152: 
                case 154: 
                case 168: 
                case 170: 
                case 184: 
                case 186: 
                case 200: 
                case 202: 
                case 216: 
                case 218: 
                case 232: 
                case 234: 
                case 248: 
                case 250: {
                    this.instrTable[buildCycle++] = () -> this.cpuRead.apply(this.Register_ProgramCounter);
                    break;
                }
                case 0: 
                case 9: 
                case 11: 
                case 16: 
                case 41: 
                case 43: 
                case 48: 
                case 64: 
                case 73: 
                case 75: 
                case 80: 
                case 96: 
                case 105: 
                case 107: 
                case 112: 
                case 128: 
                case 130: 
                case 137: 
                case 139: 
                case 144: 
                case 160: 
                case 162: 
                case 169: 
                case 171: 
                case 176: 
                case 192: 
                case 194: 
                case 201: 
                case 203: 
                case 208: 
                case 224: 
                case 226: 
                case 233: 
                case 235: 
                case 240: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = this.cpuRead.apply(this.Register_ProgramCounter);
                        if (this.flagB) {
                            this.Register_ProgramCounter = this.Register_ProgramCounter + 1 & 0xFFFF;
                        }
                    };
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 228: 
                case 229: 
                case 230: 
                case 231: {
                    access = AccessMode.READ;
                }
                case 132: 
                case 133: 
                case 134: 
                case 135: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 180: 
                case 181: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 244: 
                case 245: 
                case 246: 
                case 247: {
                    access = AccessMode.READ;
                }
                case 148: 
                case 149: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddrX();
                    this.instrTable[buildCycle++] = wastedStealable;
                    break;
                }
                case 182: 
                case 183: {
                    access = AccessMode.READ;
                }
                case 150: 
                case 151: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddrY();
                    this.instrTable[buildCycle++] = wastedStealable;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 77: 
                case 78: 
                case 79: 
                case 109: 
                case 110: 
                case 111: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    access = AccessMode.READ;
                }
                case 76: 
                case 140: 
                case 141: 
                case 142: 
                case 143: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighAddr();
                    break;
                }
                case 32: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    break;
                }
                case 28: 
                case 29: 
                case 60: 
                case 61: 
                case 92: 
                case 93: 
                case 124: 
                case 125: 
                case 188: 
                case 189: 
                case 220: 
                case 221: 
                case 252: 
                case 253: {
                    access = AccessMode.READ;
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> {
                        this.FetchHighAddrX();
                        if (this.Cycle_EffectiveAddress == this.Cycle_HighByteWrongEffectiveAddress) {
                            ++this.cycleCount;
                        }
                    };
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 30: 
                case 31: 
                case 62: 
                case 63: 
                case 94: 
                case 95: 
                case 126: 
                case 127: 
                case 222: 
                case 223: 
                case 254: 
                case 255: {
                    access = AccessMode.READ;
                }
                case 156: 
                case 157: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighAddrX();
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 121: {
                    access = AccessMode.READ;
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> {
                        this.FetchHighAddrY();
                        if (this.Cycle_EffectiveAddress == this.Cycle_HighByteWrongEffectiveAddress || this.EOD) {
                            ++this.cycleCount;
                        }
                    };
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 25: 
                case 57: 
                case 89: 
                case 185: 
                case 187: 
                case 190: 
                case 191: 
                case 217: 
                case 249: {
                    access = AccessMode.READ;
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> {
                        this.FetchHighAddrY();
                        if (this.Cycle_EffectiveAddress == this.Cycle_HighByteWrongEffectiveAddress) {
                            ++this.cycleCount;
                        }
                    };
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 27: 
                case 59: 
                case 91: 
                case 123: 
                case 219: 
                case 251: {
                    access = AccessMode.READ;
                }
                case 153: 
                case 155: 
                case 158: 
                case 159: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighAddrY();
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 108: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowPointer();
                    this.instrTable[buildCycle++] = () -> this.FetchHighPointer();
                    this.instrTable[buildCycle++] = () -> this.FetchLowEffAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighEffAddr();
                    break;
                }
                case 1: 
                case 3: 
                case 33: 
                case 35: 
                case 65: 
                case 67: 
                case 97: 
                case 99: 
                case 161: 
                case 163: 
                case 193: 
                case 195: 
                case 225: 
                case 227: {
                    access = AccessMode.READ;
                }
                case 129: 
                case 131: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowPointer();
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Pointer = this.Cycle_Pointer + this.Register_X & 0xFF;
                    };
                    this.instrTable[buildCycle++] = () -> this.FetchLowEffAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighEffAddr();
                    break;
                }
                case 17: 
                case 49: 
                case 81: 
                case 113: 
                case 177: 
                case 179: 
                case 209: 
                case 241: {
                    access = AccessMode.READ;
                    this.instrTable[buildCycle++] = () -> this.FetchLowPointer();
                    this.instrTable[buildCycle++] = () -> this.FetchLowEffAddr();
                    this.instrTable[buildCycle++] = () -> {
                        this.FetchHighEffAddrY();
                        if (this.Cycle_EffectiveAddress == this.Cycle_HighByteWrongEffectiveAddress) {
                            ++this.cycleCount;
                        }
                    };
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 19: 
                case 51: 
                case 83: 
                case 115: 
                case 211: 
                case 243: {
                    access = AccessMode.READ;
                }
                case 145: 
                case 147: {
                    this.instrTable[buildCycle++] = () -> this.FetchLowPointer();
                    this.instrTable[buildCycle++] = () -> this.FetchLowEffAddr();
                    this.instrTable[buildCycle++] = () -> this.FetchHighEffAddrY();
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                default: {
                    legalMode = false;
                }
            }
            if (access == AccessMode.READ) {
                this.instrTable[buildCycle++] = () -> {
                    this.Cycle_Data = this.cpuRead.apply(this.Cycle_EffectiveAddress);
                };
            }
            switch (i) {
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 125: {
                    this.instrTable[buildCycle++] = () -> {
                        this.doADC();
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 11: 
                case 43: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.flagC = this.flagN;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 33: 
                case 37: 
                case 41: 
                case 45: 
                case 49: 
                case 53: 
                case 57: 
                case 61: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 139: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)((this.Register_Accumulator | 0xEE) & this.Register_X & this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 107: {
                    this.instrTable[buildCycle++] = () -> {
                        int data = this.Cycle_Data & this.Register_Accumulator & 0xFF;
                        this.Register_Accumulator = (byte)(data >> 1);
                        if (this.flagC) {
                            this.Register_Accumulator = (byte)(this.Register_Accumulator | 0x80);
                        }
                        if (this.flagD) {
                            this.flagN = this.flagC;
                            this.flagZ = this.Register_Accumulator == 0;
                            this.flagV = this.v.apply(((data ^ this.Register_Accumulator) & 0x40) != 0);
                            if ((data & 0xF) + (data & 1) > 5) {
                                this.Register_Accumulator = (byte)(this.Register_Accumulator & 0xF0 | this.Register_Accumulator + 6 & 0xF);
                            }
                            boolean bl = this.flagC = data >= 80;
                            if (this.flagC) {
                                this.Register_Accumulator = (byte)(this.Register_Accumulator + 96 & 0xFF);
                            }
                        } else {
                            this.setFlagsNZ(this.Register_Accumulator);
                            this.flagC = (this.Register_Accumulator & 0x40) != 0;
                            this.flagV = this.v.apply((this.Register_Accumulator & 0x40 ^ (this.Register_Accumulator & 0x20) << 1) != 0);
                        }
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 10: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagC = this.Register_Accumulator < 0;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator << 1);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 6: 
                case 14: 
                case 22: 
                case 30: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.flagC = this.Cycle_Data < 0;
                        this.Cycle_Data = (byte)(this.Cycle_Data << 1);
                        this.setFlagsNZ(this.Cycle_Data);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 75: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & this.Cycle_Data);
                        this.flagC = (this.Register_Accumulator & 1) != 0;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator >> 1);
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & 0x7F);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 16: 
                case 48: 
                case 80: 
                case 112: 
                case 144: 
                case 176: 
                case 208: 
                case 240: {
                    int _i = i;
                    this.instrTable[buildCycle++] = () -> {
                        boolean condition;
                        switch (_i) {
                            case 176: {
                                condition = this.flagC;
                                break;
                            }
                            case 144: {
                                condition = !this.flagC;
                                break;
                            }
                            case 240: {
                                condition = this.flagZ;
                                break;
                            }
                            case 208: {
                                condition = !this.flagZ;
                                break;
                            }
                            case 48: {
                                condition = this.flagN;
                                break;
                            }
                            case 16: {
                                condition = !this.flagN;
                                break;
                            }
                            case 80: {
                                this.v.apply(this.flagV);
                                condition = !this.flagV;
                                break;
                            }
                            case 112: {
                                this.v.apply(this.flagV);
                                condition = this.flagV;
                                break;
                            }
                            default: {
                                throw new RuntimeException("non-branch opcode: " + _i);
                            }
                        }
                        if (condition) {
                            this.cpuRead.apply(this.Register_ProgramCounter);
                            this.Cycle_HighByteWrongEffectiveAddress = this.Register_ProgramCounter & 0xFF00 | this.Register_ProgramCounter + this.Cycle_Data & 0xFF;
                            this.Cycle_EffectiveAddress = this.Register_ProgramCounter + this.Cycle_Data & 0xFFFF;
                            if (this.Cycle_EffectiveAddress == this.Cycle_HighByteWrongEffectiveAddress) {
                                ++this.cycleCount;
                                if (this.interruptCycle >> 3 == this.cycleCount >> 3) {
                                    this.interruptCycle += 2;
                                }
                            }
                            this.Register_ProgramCounter = this.Cycle_EffectiveAddress;
                        } else {
                            this.interruptsAndNextOpcode();
                        }
                    };
                    this.instrTable[buildCycle++] = throwAwayReadStealable;
                    break;
                }
                case 36: 
                case 44: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagZ = (this.Register_Accumulator & this.Cycle_Data) == 0;
                        this.flagN = this.Cycle_Data < 0;
                        this.flagV = this.v.apply((this.Cycle_Data & 0x40) != 0);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 0: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> this.PushHighPC();
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PushLowPC();
                        this.Cycle_EffectiveAddress = this.rstFlag ? 65532 : (this.nmiFlag ? 65530 : 65534);
                        this.rstFlag = false;
                        this.nmiFlag = false;
                        this.calculateInterruptTriggerCycle();
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PushSR();
                        this.flagB = true;
                        this.flagI = true;
                    };
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_ProgramCounter = this.cpuRead.apply(this.Cycle_EffectiveAddress) & 0xFF;
                    };
                    this.instrTable[buildCycle++] = () -> this.Register_ProgramCounter |= (this.cpuRead.apply(this.Cycle_EffectiveAddress + 1) & 0xFF) << 8;
                    this.instrTable[buildCycle++] = () -> this.fetchNextOpcode();
                    break;
                }
                case 24: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagC = false;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 216: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagD = false;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 88: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagI = false;
                        this.calculateInterruptTriggerCycle();
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 184: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagV = this.v.apply(false);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 193: 
                case 197: 
                case 201: 
                case 205: 
                case 209: 
                case 213: 
                case 217: 
                case 221: {
                    this.instrTable[buildCycle++] = () -> {
                        this.setFlagsNZ((byte)(this.Register_Accumulator - this.Cycle_Data));
                        this.flagC = (this.Register_Accumulator & 0xFF) >= (this.Cycle_Data & 0xFF);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 224: 
                case 228: 
                case 236: {
                    this.instrTable[buildCycle++] = () -> {
                        this.setFlagsNZ((byte)(this.Register_X - this.Cycle_Data));
                        this.flagC = (this.Register_X & 0xFF) >= (this.Cycle_Data & 0xFF);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 192: 
                case 196: 
                case 204: {
                    this.instrTable[buildCycle++] = () -> {
                        this.setFlagsNZ((byte)(this.Register_Y - this.Cycle_Data));
                        this.flagC = (this.Register_Y & 0xFF) >= (this.Cycle_Data & 0xFF);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 195: 
                case 199: 
                case 207: 
                case 211: 
                case 215: 
                case 219: 
                case 223: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data - 1);
                        this.setFlagsNZ((byte)(this.Register_Accumulator - this.Cycle_Data));
                        this.flagC = (this.Register_Accumulator & 0xFF) >= (this.Cycle_Data & 0xFF);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 198: 
                case 206: 
                case 214: 
                case 222: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data - 1);
                        this.setFlagsNZ(this.Cycle_Data);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 202: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = (byte)(this.Register_X - 1);
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 136: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Y = (byte)(this.Register_Y - 1);
                        this.setFlagsNZ(this.Register_Y);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 65: 
                case 69: 
                case 73: 
                case 77: 
                case 81: 
                case 85: 
                case 89: 
                case 93: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)(this.Register_Accumulator ^ this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 230: 
                case 238: 
                case 246: 
                case 254: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data + 1);
                        this.setFlagsNZ(this.Cycle_Data);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 232: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = (byte)(this.Register_X + 1);
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 200: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Y = (byte)(this.Register_Y + 1);
                        this.setFlagsNZ(this.Register_Y);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 227: 
                case 231: 
                case 239: 
                case 243: 
                case 247: 
                case 251: 
                case 255: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data + 1);
                        this.setFlagsNZ(this.Cycle_Data);
                        this.doSBC();
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 32: {
                    this.instrTable[buildCycle++] = wastedStealable;
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> this.PushHighPC();
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> this.PushLowPC();
                    this.instrTable[buildCycle++] = () -> this.FetchHighAddr();
                }
                case 76: 
                case 108: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_ProgramCounter = this.Cycle_EffectiveAddress;
                        if (this.jmpJsr != null) {
                            this.jmpJsr.accept(this.Register_ProgramCounter);
                        }
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 187: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = (byte)(this.Cycle_Data & this.Register_StackPointer);
                        this.setFlagsNZ(this.Cycle_Data);
                        this.Register_Accumulator = this.Cycle_Data;
                        this.Register_X = this.Cycle_Data;
                        this.Register_StackPointer = this.Cycle_Data;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 163: 
                case 167: 
                case 175: 
                case 179: 
                case 183: 
                case 191: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = this.Register_X = this.Cycle_Data;
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 161: 
                case 165: 
                case 169: 
                case 173: 
                case 177: 
                case 181: 
                case 185: 
                case 189: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = this.Cycle_Data;
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 162: 
                case 166: 
                case 174: 
                case 182: 
                case 190: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = this.Cycle_Data;
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 160: 
                case 164: 
                case 172: 
                case 180: 
                case 188: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Y = this.Cycle_Data;
                        this.setFlagsNZ(this.Register_Y);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 74: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagC = (this.Register_Accumulator & 1) != 0;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator >> 1);
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & 0x7F);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 70: 
                case 78: 
                case 86: 
                case 94: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.flagC = (this.Cycle_Data & 1) != 0;
                        this.Cycle_Data = (byte)(this.Cycle_Data >> 1);
                        this.Cycle_Data = (byte)(this.Cycle_Data & 0x7F);
                        this.setFlagsNZ(this.Cycle_Data);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 4: 
                case 12: 
                case 20: 
                case 26: 
                case 28: 
                case 52: 
                case 58: 
                case 60: 
                case 68: 
                case 84: 
                case 90: 
                case 92: 
                case 100: 
                case 116: 
                case 122: 
                case 124: 
                case 128: 
                case 130: 
                case 137: 
                case 194: 
                case 212: 
                case 218: 
                case 220: 
                case 226: 
                case 234: 
                case 244: 
                case 250: 
                case 252: {
                    break;
                }
                case 171: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = this.Register_Accumulator = (byte)(this.Cycle_Data & (this.Register_Accumulator | 0xEE));
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 1: 
                case 5: 
                case 9: 
                case 13: 
                case 17: 
                case 21: 
                case 25: 
                case 29: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = (byte)(this.Register_Accumulator | this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 72: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.cpuWrite.accept(0x100 | this.Register_StackPointer & 0xFF, this.Register_Accumulator);
                        this.Register_StackPointer = (byte)(this.Register_StackPointer - 1);
                    };
                    break;
                }
                case 8: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> this.PushSR();
                    break;
                }
                case 104: {
                    this.instrTable[buildCycle++] = wastedStealable;
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_StackPointer = (byte)(this.Register_StackPointer + 1);
                        this.Register_Accumulator = this.cpuRead.apply(0x100 | this.Register_StackPointer & 0xFF);
                        this.setFlagsNZ(this.Register_Accumulator);
                    };
                    break;
                }
                case 40: {
                    this.instrTable[buildCycle++] = wastedStealable;
                    this.instrTable[buildCycle++] = () -> {
                        this.PopSR();
                        this.calculateInterruptTriggerCycle();
                    };
                    this.instrTable[buildCycle++] = () -> this.interruptsAndNextOpcode();
                    break;
                }
                case 35: 
                case 39: 
                case 47: 
                case 51: 
                case 55: 
                case 59: 
                case 63: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = this.Cycle_Data < 0;
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data << 1);
                        if (this.flagC) {
                            this.Cycle_Data = (byte)(this.Cycle_Data | 1);
                        }
                        this.flagC = newC;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator & this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 42: {
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = this.Register_Accumulator < 0;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator << 1);
                        if (this.flagC) {
                            this.Register_Accumulator = (byte)(this.Register_Accumulator | 1);
                        }
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.flagC = newC;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 38: 
                case 46: 
                case 54: 
                case 62: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = this.Cycle_Data < 0;
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data << 1);
                        if (this.flagC) {
                            this.Cycle_Data = (byte)(this.Cycle_Data | 1);
                        }
                        this.setFlagsNZ(this.Cycle_Data);
                        this.flagC = newC;
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 106: {
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = (this.Register_Accumulator & 1) != 0;
                        this.Register_Accumulator = (byte)(this.Register_Accumulator >> 1);
                        this.Register_Accumulator = this.flagC ? (byte)(this.Register_Accumulator | 0x80) : (byte)(this.Register_Accumulator & 0x7F);
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.flagC = newC;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 102: 
                case 110: 
                case 118: 
                case 126: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = (this.Cycle_Data & 1) != 0;
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data >> 1);
                        this.Cycle_Data = this.flagC ? (byte)(this.Cycle_Data | 0x80) : (byte)(this.Cycle_Data & 0x7F);
                        this.setFlagsNZ(this.Cycle_Data);
                        this.flagC = newC;
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 99: 
                case 103: 
                case 111: 
                case 115: 
                case 119: 
                case 123: 
                case 127: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        boolean newC = (this.Cycle_Data & 1) != 0;
                        this.PutEffAddrDataByte();
                        this.Cycle_Data = (byte)(this.Cycle_Data >> 1);
                        this.Cycle_Data = this.flagC ? (byte)(this.Cycle_Data | 0x80) : (byte)(this.Cycle_Data & 0x7F);
                        this.flagC = newC;
                        this.doADC();
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 64: {
                    this.instrTable[buildCycle++] = wastedStealable;
                    this.instrTable[buildCycle++] = () -> {
                        this.PopSR();
                        this.calculateInterruptTriggerCycle();
                    };
                    this.instrTable[buildCycle++] = () -> this.PopLowPC();
                    this.instrTable[buildCycle++] = () -> this.PopHighPC();
                    this.instrTable[buildCycle++] = () -> this.interruptEnd();
                    break;
                }
                case 96: {
                    this.instrTable[buildCycle++] = wastedStealable;
                    this.instrTable[buildCycle++] = () -> this.PopLowPC();
                    this.instrTable[buildCycle++] = () -> this.PopHighPC();
                    this.instrTable[buildCycle++] = () -> {
                        this.cpuRead.apply(this.Cycle_EffectiveAddress);
                        this.Register_ProgramCounter = this.Cycle_EffectiveAddress + 1 & 0xFFFF;
                    };
                    break;
                }
                case 131: 
                case 135: 
                case 143: 
                case 151: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = (byte)(this.Register_Accumulator & this.Register_X);
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 225: 
                case 229: 
                case 233: 
                case 235: 
                case 237: 
                case 241: 
                case 245: 
                case 249: 
                case 253: {
                    this.instrTable[buildCycle++] = () -> {
                        this.doSBC();
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 203: {
                    this.instrTable[buildCycle++] = () -> {
                        int tmp = (this.Register_X & this.Register_Accumulator & 0xFF) - (this.Cycle_Data & 0xFF);
                        this.Register_X = (byte)tmp;
                        this.setFlagsNZ(this.Register_X);
                        this.flagC = tmp >= 0;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 56: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagC = true;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 248: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagD = true;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 120: {
                    this.instrTable[buildCycle++] = () -> {
                        this.flagI = true;
                        this.interruptsAndNextOpcode();
                        if (!this.rstFlag && !this.nmiFlag && this.interruptCycle != 65536) {
                            this.interruptCycle = 65536;
                        }
                    };
                    break;
                }
                case 147: 
                case 159: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = (byte)(this.Register_X & this.Register_Accumulator & (this.Cycle_EffectiveAddress >> 8) + 1);
                        if (this.Cycle_HighByteWrongEffectiveAddress != this.Cycle_EffectiveAddress) {
                            this.Cycle_EffectiveAddress = (this.Cycle_Data & 0xFF) << 8 | this.Cycle_EffectiveAddress & 0xFF;
                        }
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 155: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_StackPointer = (byte)(this.Register_Accumulator & this.Register_X);
                        this.Cycle_Data = (byte)((this.Cycle_EffectiveAddress >> 8) + 1 & this.Register_StackPointer & 0xFF);
                        if (this.Cycle_HighByteWrongEffectiveAddress != this.Cycle_EffectiveAddress) {
                            this.Cycle_EffectiveAddress = (this.Cycle_Data & 0xFF) << 8 | this.Cycle_EffectiveAddress & 0xFF;
                        }
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 158: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = (byte)(this.Register_X & (this.Cycle_EffectiveAddress >> 8) + 1);
                        if (this.Cycle_HighByteWrongEffectiveAddress != this.Cycle_EffectiveAddress) {
                            this.Cycle_EffectiveAddress = (this.Cycle_Data & 0xFF) << 8 | this.Cycle_EffectiveAddress & 0xFF;
                        }
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 156: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = (byte)(this.Register_Y & (this.Cycle_EffectiveAddress >> 8) + 1);
                        if (this.Cycle_HighByteWrongEffectiveAddress != this.Cycle_EffectiveAddress) {
                            this.Cycle_EffectiveAddress = (this.Cycle_Data & 0xFF) << 8 | this.Cycle_EffectiveAddress & 0xFF;
                        }
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 3: 
                case 7: 
                case 15: 
                case 19: 
                case 23: 
                case 27: 
                case 31: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.flagC = this.Cycle_Data < 0;
                        this.Cycle_Data = (byte)(this.Cycle_Data << 1);
                        this.Register_Accumulator = (byte)(this.Register_Accumulator | this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 67: 
                case 71: 
                case 79: 
                case 83: 
                case 87: 
                case 91: 
                case 95: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.PutEffAddrDataByte();
                        this.flagC = (this.Cycle_Data & 1) != 0;
                        this.Cycle_Data = (byte)(this.Cycle_Data >> 1);
                        this.Cycle_Data = (byte)(this.Cycle_Data & 0x7F);
                        this.Register_Accumulator = (byte)(this.Register_Accumulator ^ this.Cycle_Data);
                        this.setFlagsNZ(this.Register_Accumulator);
                    };
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = writeToEffectiveAddress;
                    break;
                }
                case 129: 
                case 133: 
                case 141: 
                case 145: 
                case 149: 
                case 153: 
                case 157: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = this.Register_Accumulator;
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 134: 
                case 142: 
                case 150: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = this.Register_X;
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 132: 
                case 140: 
                case 148: {
                    this.processorCycleNoSteal[buildCycle] = true;
                    this.instrTable[buildCycle++] = () -> {
                        this.Cycle_Data = this.Register_Y;
                        this.PutEffAddrDataByte();
                    };
                    break;
                }
                case 170: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = this.Register_Accumulator;
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 168: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Y = this.Register_Accumulator;
                        this.setFlagsNZ(this.Register_Y);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 186: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_X = this.Register_StackPointer;
                        this.setFlagsNZ(this.Register_X);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 138: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = this.Register_X;
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 154: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_StackPointer = this.Register_X;
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                case 152: {
                    this.instrTable[buildCycle++] = () -> {
                        this.Register_Accumulator = this.Register_Y;
                        this.setFlagsNZ(this.Register_Accumulator);
                        this.interruptsAndNextOpcode();
                    };
                    break;
                }
                default: {
                    legalInstr = false;
                }
            }
            if (!legalMode || !legalInstr) {
                this.instrTable[buildCycle++] = () -> --this.cycleCount;
            }
            this.instrTable[buildCycle++] = () -> this.interruptsAndNextOpcode();
        }
    }

    public void forcedJump(int address) {
        this.cycleCount = 1873;
        this.Cycle_EffectiveAddress = this.Register_ProgramCounter = address;
    }

    public static String credits() {
        return "MOS6510 (CPU)\n\t(\u00a9) 2000 Simon A. White\n\t(\u00a9) 2008-2010 Antti S. Lankila\n";
    }

    public final void setRDY(boolean rdy) {
        this.rdy = rdy;
        if (rdy) {
            this.context.cancel(this.eventWithSteals);
            this.context.schedule(this.eventWithoutSteals, 0L, Event.Phase.PHI2);
        } else {
            this.context.cancel(this.eventWithoutSteals);
            this.context.schedule(this.eventWithSteals, 0L, Event.Phase.PHI2);
        }
    }

    public final void triggerRST() {
        this.Initialise();
        this.cycleCount = 0;
        this.rstFlag = true;
        this.calculateInterruptTriggerCycle();
    }

    public final void triggerNMI() {
        this.nmiFlag = true;
        this.calculateInterruptTriggerCycle();
        if (!this.rdy) {
            this.context.cancel(this.eventWithSteals);
            this.context.schedule(this.eventWithSteals, 0L, Event.Phase.PHI2);
        }
    }

    public final void triggerIRQ() {
        this.irqAssertedOnPin = true;
        this.calculateInterruptTriggerCycle();
        if (!this.rdy && this.interruptCycle == this.cycleCount) {
            this.context.cancel(this.eventWithSteals);
            this.context.schedule(this.eventWithSteals, 0L, Event.Phase.PHI2);
        }
    }

    public final void clearIRQ() {
        this.irqAssertedOnPin = false;
        this.calculateInterruptTriggerCycle();
    }

    protected final void setFlagsNZ(byte value) {
        this.flagZ = value == 0;
        this.flagN = value < 0;
    }

    private byte getStatusRegister() {
        byte sr = 0;
        if (this.flagN) {
            sr = (byte)(sr | 0x80);
        }
        this.v.apply(this.flagV);
        if (this.flagV) {
            sr = (byte)(sr | 0x40);
        }
        if (this.flagU) {
            sr = (byte)(sr | 0x20);
        }
        if (this.flagB) {
            sr = (byte)(sr | 0x10);
        }
        if (this.flagD) {
            sr = (byte)(sr | 8);
        }
        if (this.flagI) {
            sr = (byte)(sr | 4);
        }
        if (this.flagZ) {
            sr = (byte)(sr | 2);
        }
        if (this.flagC) {
            sr = (byte)(sr | 1);
        }
        return sr;
    }

    private void setStatusRegister(byte sr) {
        this.flagC = (sr & 1) != 0;
        this.flagZ = (sr & 2) != 0;
        this.flagI = (sr & 4) != 0;
        this.flagD = (sr & 8) != 0;
        this.flagB = (sr & 0x10) != 0;
        this.flagU = (sr & 0x20) != 0;
        this.flagV = this.v.apply((sr & 0x40) != 0);
        this.flagN = (sr & 0x80) != 0;
    }

    public final byte getStalledOnByte() {
        return this.cpuRead.apply(this.Register_ProgramCounter);
    }

    public final EventScheduler getEventScheduler() {
        return this.context;
    }

    public void setEODHack(boolean hack) {
        this.EOD = hack;
    }

    private static enum AccessMode {
        WRITE,
        READ;

    }
}

