/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Engine;
import libsidplay.common.SidReads;
import libsidplay.common.StereoMode;
import libsidplay.common.Ultimate64Mode;
import libsidplay.config.IDeviceMapping;

public interface IEmulationSection {
    public static final String EMULATION_SECTION_BUNDLE = "sidplay.ini.IniEmulationSection";

    public Engine getEngine();

    public void setEngine(Engine var1);

    public Emulation getDefaultEmulation();

    public void setDefaultEmulation(Emulation var1);

    public Emulation getUserEmulation();

    public void setUserEmulation(Emulation var1);

    public Emulation getStereoEmulation();

    public void setStereoEmulation(Emulation var1);

    public Emulation getThirdEmulation();

    public void setThirdEmulation(Emulation var1);

    public CPUClock getDefaultClockSpeed();

    public void setDefaultClockSpeed(CPUClock var1);

    public CPUClock getUserClockSpeed();

    public void setUserClockSpeed(CPUClock var1);

    public ChipModel getDefaultSidModel();

    public void setDefaultSidModel(ChipModel var1);

    public ChipModel getUserSidModel();

    public void setUserSidModel(ChipModel var1);

    public ChipModel getStereoSidModel();

    public void setStereoSidModel(ChipModel var1);

    public ChipModel getThirdSIDModel();

    public void setThirdSIDModel(ChipModel var1);

    public int getHardsid6581();

    public void setHardsid6581(int var1);

    public int getHardsid8580();

    public void setHardsid8580(int var1);

    public List<? extends IDeviceMapping> getSidBlasterDeviceList();

    public int getSidBlasterWriteBufferSize();

    public void setSidBlasterWriteBufferSize(int var1);

    public String getSidBlasterSerialNumber();

    public void setSidBlasterSerialNumber(String var1);

    public boolean isSidBlasterRead();

    public void setSidBlasterRead(boolean var1);

    public short getSidBlasterLatencyTimer();

    public void setSidBlasterLatencyTimer(short var1);

    public boolean isExsidFakeStereo();

    public void setExsidFakeStereo(boolean var1);

    public String getNetSIDDevHost();

    public void setNetSIDDevHost(String var1);

    public int getNetSIDDevPort();

    public void setNetSIDDevPort(int var1);

    public Ultimate64Mode getUltimate64Mode();

    public void setUltimate64Mode(Ultimate64Mode var1);

    public String getUltimate64Host();

    public void setUltimate64Host(String var1);

    public int getUltimate64Port();

    public void setUltimate64Port(int var1);

    public int getUltimate64SyncDelay();

    public void setUltimate64SyncDelay(int var1);

    public boolean isFilter();

    public void setFilter(boolean var1);

    public boolean isStereoFilter();

    public void setStereoFilter(boolean var1);

    public boolean isThirdSIDFilter();

    public void setThirdSIDFilter(boolean var1);

    public String getNetSIDFilter6581();

    public String getNetSIDStereoFilter6581();

    public String getNetSIDThirdSIDFilter6581();

    public void setNetSIDFilter6581(String var1);

    public void setNetSIDStereoFilter6581(String var1);

    public void setNetSIDThirdSIDFilter6581(String var1);

    public String getNetSIDFilter8580();

    public String getNetSIDStereoFilter8580();

    public String getNetSIDThirdSIDFilter8580();

    public void setNetSIDFilter8580(String var1);

    public void setNetSIDStereoFilter8580(String var1);

    public void setNetSIDThirdSIDFilter8580(String var1);

    public String getFilter6581();

    public void setFilter6581(String var1);

    public String getStereoFilter6581();

    public void setStereoFilter6581(String var1);

    public String getThirdSIDFilter6581();

    public void setThirdSIDFilter6581(String var1);

    public String getFilter8580();

    public void setFilter8580(String var1);

    public String getStereoFilter8580();

    public void setStereoFilter8580(String var1);

    public String getThirdSIDFilter8580();

    public void setThirdSIDFilter8580(String var1);

    public String getReSIDfpFilter6581();

    public void setReSIDfpFilter6581(String var1);

    public String getReSIDfpStereoFilter6581();

    public void setReSIDfpStereoFilter6581(String var1);

    public String getReSIDfpThirdSIDFilter6581();

    public void setReSIDfpThirdSIDFilter6581(String var1);

    public String getReSIDfpFilter8580();

    public void setReSIDfpFilter8580(String var1);

    public String getReSIDfpStereoFilter8580();

    public void setReSIDfpStereoFilter8580(String var1);

    public String getReSIDfpThirdSIDFilter8580();

    public void setReSIDfpThirdSIDFilter8580(String var1);

    public boolean isDigiBoosted8580();

    public void setDigiBoosted8580(boolean var1);

    public int getDualSidBase();

    public int getThirdSIDBase();

    public void setDualSidBase(int var1);

    public void setThirdSIDBase(int var1);

    public SidReads getSidToRead();

    public void setSidToRead(SidReads var1);

    public boolean isFakeStereo();

    public void setFakeStereo(boolean var1);

    public boolean isForceStereoTune();

    public void setForceStereoTune(boolean var1);

    public boolean isForce3SIDTune();

    public void setForce3SIDTune(boolean var1);

    public boolean isMuteVoice1();

    public void setMuteVoice1(boolean var1);

    public boolean isMuteVoice2();

    public void setMuteVoice2(boolean var1);

    public boolean isMuteVoice3();

    public void setMuteVoice3(boolean var1);

    public boolean isMuteVoice4();

    public void setMuteVoice4(boolean var1);

    public boolean isMuteStereoVoice1();

    public void setMuteStereoVoice1(boolean var1);

    public boolean isMuteStereoVoice2();

    public void setMuteStereoVoice2(boolean var1);

    public boolean isMuteStereoVoice3();

    public void setMuteStereoVoice3(boolean var1);

    public boolean isMuteStereoVoice4();

    public void setMuteStereoVoice4(boolean var1);

    public boolean isMuteThirdSIDVoice1();

    public void setMuteThirdSIDVoice1(boolean var1);

    public boolean isMuteThirdSIDVoice2();

    public void setMuteThirdSIDVoice2(boolean var1);

    public boolean isMuteThirdSIDVoice3();

    public void setMuteThirdSIDVoice3(boolean var1);

    public boolean isMuteThirdSIDVoice4();

    public void setMuteThirdSIDVoice4(boolean var1);

    public OverrideSection getOverrideSection();

    public boolean isDetectPSID64ChipModel();

    public void setDetectPSID64ChipModel(boolean var1);

    @JsonIgnore
    default public StereoMode getStereoMode() {
        if (this.isForceStereo(2)) {
            return StereoMode.THREE_SID;
        }
        if (this.isForceStereo(1)) {
            return StereoMode.STEREO;
        }
        return StereoMode.AUTO;
    }

    @JsonIgnore
    default public void setStereoMode(StereoMode stereoMode) {
        switch (stereoMode) {
            case THREE_SID: {
                this.setForceStereo(1, true);
                this.setForceStereo(2, true);
                break;
            }
            case STEREO: {
                this.setForceStereo(1, true);
                this.setForceStereo(2, false);
                break;
            }
            default: {
                this.setForceStereo(1, false);
                this.setForceStereo(2, false);
            }
        }
    }

    @JsonIgnore
    default public Map<String, ChipModel> getSidBlasterDeviceMap() {
        return this.getSidBlasterDeviceList().stream().filter(IDeviceMapping::isUsed).collect(Collectors.toMap(deviceMapping -> deviceMapping.getSerialNum(), tokens -> tokens.getChipModel()));
    }

    default public boolean isForceStereo(int sidNum) {
        switch (sidNum) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isForceStereoTune();
            }
            case 2: {
                return this.isForce3SIDTune();
            }
        }
        throw new RuntimeException("Maximum supported SIDS exceeded!");
    }

    default public void setForceStereo(int sidNum, boolean forceStereo) {
        switch (sidNum) {
            case 0: {
                break;
            }
            case 1: {
                this.setForceStereoTune(forceStereo);
                break;
            }
            case 2: {
                this.setForce3SIDTune(forceStereo);
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
    }

    default public Emulation getForcedEmulation(int sidNum) {
        switch (sidNum) {
            case 0: {
                return this.getUserEmulation();
            }
            case 1: {
                return this.getStereoEmulation();
            }
            case 2: {
                return this.getThirdEmulation();
            }
        }
        throw new RuntimeException("Maximum supported SIDS exceeded!");
    }

    default public void setForcedEmulation(int sidNum, Emulation emulation) {
        switch (sidNum) {
            case 0: {
                this.setUserEmulation(emulation);
                break;
            }
            case 1: {
                this.setStereoEmulation(emulation);
                break;
            }
            case 2: {
                this.setThirdEmulation(emulation);
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
    }

    default public ChipModel getForcedSidModel(int sidNum) {
        switch (sidNum) {
            case 0: {
                return this.getUserSidModel();
            }
            case 1: {
                return this.getStereoSidModel();
            }
            case 2: {
                return this.getThirdSIDModel();
            }
        }
        throw new RuntimeException("Maximum supported SIDS exceeded!");
    }

    default public void setForcedSidModel(int sidNum, ChipModel chipModel) {
        switch (sidNum) {
            case 0: {
                this.setUserSidModel(chipModel);
                break;
            }
            case 1: {
                this.setStereoSidModel(chipModel);
                break;
            }
            case 2: {
                this.setThirdSIDModel(chipModel);
                break;
            }
            default: {
                throw new RuntimeException("Maximum supported SIDS exceeded!");
            }
        }
    }

    default public boolean isFilterEnable(int sidNum) {
        switch (sidNum) {
            case 0: {
                return this.isFilter();
            }
            case 1: {
                return this.isStereoFilter();
            }
            case 2: {
                return this.isThirdSIDFilter();
            }
        }
        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
    }

    default public void setFilterEnable(int sidNum, boolean enable) {
        switch (sidNum) {
            case 0: {
                this.setFilter(enable);
                break;
            }
            case 1: {
                this.setStereoFilter(enable);
                break;
            }
            case 2: {
                this.setThirdSIDFilter(enable);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
            }
        }
    }

    default public String getFilterName(int sidNum, Engine engine, Emulation emulation, ChipModel chipModel) {
        switch (chipModel) {
            case MOS6581: {
                switch (engine) {
                    case EMULATION: 
                    case HARDSID: 
                    case SIDBLASTER: 
                    case EXSID: 
                    case USBSID: 
                    case HARDSID_DLL: {
                        switch (emulation) {
                            case RESID: {
                                switch (sidNum) {
                                    case 0: {
                                        return this.getFilter6581();
                                    }
                                    case 1: {
                                        return this.getStereoFilter6581();
                                    }
                                    case 2: {
                                        return this.getThirdSIDFilter6581();
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                            case RESIDFP: {
                                switch (sidNum) {
                                    case 0: {
                                        return this.getReSIDfpFilter6581();
                                    }
                                    case 1: {
                                        return this.getReSIDfpStereoFilter6581();
                                    }
                                    case 2: {
                                        return this.getReSIDfpThirdSIDFilter6581();
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                        }
                        throw new RuntimeException(String.format("Unknown emulation type: %s!", new Object[]{emulation}));
                    }
                    case NETSID: {
                        switch (sidNum) {
                            case 0: {
                                return this.getNetSIDFilter6581();
                            }
                            case 1: {
                                return this.getNetSIDStereoFilter6581();
                            }
                            case 2: {
                                return this.getNetSIDThirdSIDFilter6581();
                            }
                        }
                        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                    }
                }
                throw new RuntimeException(String.format("Unknown engine: %s", new Object[]{engine}));
            }
            case MOS8580: {
                switch (engine) {
                    case EMULATION: 
                    case HARDSID: 
                    case SIDBLASTER: 
                    case EXSID: 
                    case USBSID: 
                    case HARDSID_DLL: {
                        switch (emulation) {
                            case RESID: {
                                switch (sidNum) {
                                    case 0: {
                                        return this.getFilter8580();
                                    }
                                    case 1: {
                                        return this.getStereoFilter8580();
                                    }
                                    case 2: {
                                        return this.getThirdSIDFilter8580();
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                            case RESIDFP: {
                                switch (sidNum) {
                                    case 0: {
                                        return this.getReSIDfpFilter8580();
                                    }
                                    case 1: {
                                        return this.getReSIDfpStereoFilter8580();
                                    }
                                    case 2: {
                                        return this.getReSIDfpThirdSIDFilter8580();
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                        }
                        throw new RuntimeException(String.format("Unknown emulation type: %s!", new Object[]{emulation}));
                    }
                    case NETSID: {
                        switch (sidNum) {
                            case 0: {
                                return this.getNetSIDFilter8580();
                            }
                            case 1: {
                                return this.getNetSIDStereoFilter8580();
                            }
                            case 2: {
                                return this.getNetSIDThirdSIDFilter8580();
                            }
                        }
                        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                    }
                }
                throw new RuntimeException(String.format("Unknown engine: %s!", new Object[]{engine}));
            }
        }
        throw new RuntimeException(String.format("Unknown chip model: %s!", new Object[]{chipModel}));
    }

    default public void setFilterName(int sidNum, Engine engine, Emulation emulation, ChipModel chipModel, String filterName) {
        block0 : switch (chipModel) {
            case MOS6581: {
                switch (engine) {
                    case EMULATION: 
                    case HARDSID: 
                    case SIDBLASTER: 
                    case EXSID: 
                    case USBSID: 
                    case HARDSID_DLL: {
                        switch (emulation) {
                            case RESID: {
                                switch (sidNum) {
                                    case 0: {
                                        this.setFilter6581(filterName);
                                        break block0;
                                    }
                                    case 1: {
                                        this.setStereoFilter6581(filterName);
                                        break block0;
                                    }
                                    case 2: {
                                        this.setThirdSIDFilter6581(filterName);
                                        break block0;
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                            case RESIDFP: {
                                switch (sidNum) {
                                    case 0: {
                                        this.setReSIDfpFilter6581(filterName);
                                        break block0;
                                    }
                                    case 1: {
                                        this.setReSIDfpStereoFilter6581(filterName);
                                        break block0;
                                    }
                                    case 2: {
                                        this.setReSIDfpThirdSIDFilter6581(filterName);
                                        break block0;
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                        }
                        throw new RuntimeException(String.format("Unknown emulation type: %s!", new Object[]{emulation}));
                    }
                    case NETSID: {
                        switch (sidNum) {
                            case 0: {
                                this.setNetSIDFilter6581(filterName);
                                break block0;
                            }
                            case 1: {
                                this.setNetSIDStereoFilter6581(filterName);
                                break block0;
                            }
                            case 2: {
                                this.setNetSIDThirdSIDFilter6581(filterName);
                                break block0;
                            }
                        }
                        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                    }
                }
                throw new RuntimeException(String.format("Unknown engine: %s!", new Object[]{engine}));
            }
            case MOS8580: {
                switch (engine) {
                    case EMULATION: 
                    case HARDSID: 
                    case SIDBLASTER: 
                    case EXSID: 
                    case USBSID: 
                    case HARDSID_DLL: {
                        switch (emulation) {
                            case RESID: {
                                switch (sidNum) {
                                    case 0: {
                                        this.setFilter8580(filterName);
                                        break block0;
                                    }
                                    case 1: {
                                        this.setStereoFilter8580(filterName);
                                        break block0;
                                    }
                                    case 2: {
                                        this.setThirdSIDFilter8580(filterName);
                                        break block0;
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                            case RESIDFP: {
                                switch (sidNum) {
                                    case 0: {
                                        this.setReSIDfpFilter8580(filterName);
                                        break block0;
                                    }
                                    case 1: {
                                        this.setReSIDfpStereoFilter8580(filterName);
                                        break block0;
                                    }
                                    case 2: {
                                        this.setReSIDfpThirdSIDFilter8580(filterName);
                                        break block0;
                                    }
                                }
                                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                            }
                        }
                        throw new RuntimeException(String.format("Unknown emulation type: %s!", new Object[]{emulation}));
                    }
                    case NETSID: {
                        switch (sidNum) {
                            case 0: {
                                this.setNetSIDFilter8580(filterName);
                                break block0;
                            }
                            case 1: {
                                this.setNetSIDStereoFilter8580(filterName);
                                break block0;
                            }
                            case 2: {
                                this.setNetSIDThirdSIDFilter8580(filterName);
                                break block0;
                            }
                        }
                        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
                    }
                }
                throw new RuntimeException(String.format("Unknown engine: %s!", new Object[]{engine}));
            }
            default: {
                throw new RuntimeException(String.format("Unknown chip model: %s!", new Object[]{chipModel}));
            }
        }
    }

    default public boolean isMuteVoice(int sidNum, int voice) {
        switch (sidNum) {
            case 0: {
                switch (voice) {
                    case 0: {
                        return this.isMuteVoice1();
                    }
                    case 1: {
                        return this.isMuteVoice2();
                    }
                    case 2: {
                        return this.isMuteVoice3();
                    }
                    case 3: {
                        return this.isMuteVoice4();
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
            case 1: {
                switch (voice) {
                    case 0: {
                        return this.isMuteStereoVoice1();
                    }
                    case 1: {
                        return this.isMuteStereoVoice2();
                    }
                    case 2: {
                        return this.isMuteStereoVoice3();
                    }
                    case 3: {
                        return this.isMuteStereoVoice4();
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
            case 2: {
                switch (voice) {
                    case 0: {
                        return this.isMuteThirdSIDVoice1();
                    }
                    case 1: {
                        return this.isMuteThirdSIDVoice2();
                    }
                    case 2: {
                        return this.isMuteThirdSIDVoice3();
                    }
                    case 3: {
                        return this.isMuteThirdSIDVoice4();
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
        }
        throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
    }

    default public void setMuteVoice(int sidNum, int voice, boolean value) {
        block0 : switch (sidNum) {
            case 0: {
                switch (voice) {
                    case 0: {
                        this.setMuteVoice1(value);
                        break block0;
                    }
                    case 1: {
                        this.setMuteVoice2(value);
                        break block0;
                    }
                    case 2: {
                        this.setMuteVoice3(value);
                        break block0;
                    }
                    case 3: {
                        this.setMuteVoice4(value);
                        break block0;
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
            case 1: {
                switch (voice) {
                    case 0: {
                        this.setMuteStereoVoice1(value);
                        break block0;
                    }
                    case 1: {
                        this.setMuteStereoVoice2(value);
                        break block0;
                    }
                    case 2: {
                        this.setMuteStereoVoice3(value);
                        break block0;
                    }
                    case 3: {
                        this.setMuteStereoVoice4(value);
                        break block0;
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
            case 2: {
                switch (voice) {
                    case 0: {
                        this.setMuteThirdSIDVoice1(value);
                        break block0;
                    }
                    case 1: {
                        this.setMuteThirdSIDVoice2(value);
                        break block0;
                    }
                    case 2: {
                        this.setMuteThirdSIDVoice3(value);
                        break block0;
                    }
                    case 3: {
                        this.setMuteThirdSIDVoice4(value);
                        break block0;
                    }
                }
                throw new RuntimeException(String.format("Unknown voice: %d!", voice));
            }
            default: {
                throw new RuntimeException(String.format("Maximum SIDs exceeded: %d!", sidNum));
            }
        }
    }

    public static class OverrideSection {
        private ChipModel[] sidModel = new ChipModel[3];
        private int[] sidBase = new int[3];

        public ChipModel[] getSidModel() {
            return this.sidModel;
        }

        public int[] getSidBase() {
            return this.sidBase;
        }

        public void reset() {
            for (int sidNum = 0; sidNum < 3; ++sidNum) {
                this.sidModel[sidNum] = null;
                this.sidBase[sidNum] = 0;
            }
        }
    }
}

