/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.cruncher;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import libsidutils.assembler.KickAssembler;
import libsidutils.assembler.KickAssemblerResult;
import libsidutils.cruncher.Decruncher;

public class PUCrunch {
    private static final int FIXF_C64 = 1;
    private static final int FIXF_MACHMASK = 255;
    private static final int FIXF_WRAP = 256;
    private static final int FIXF_DLZ = 512;
    private static final int FIXF_BASIC = 1024;
    private static final int FIXF_FAST = 2048;
    private static final int FIXF_SHORT = 4096;
    private static final int FIXF_MUSTMASK = 1792;
    private static final Decruncher[] DECRUNCHERS = new Decruncher[]{new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64.asm", "C64", 1), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64S.asm", "C64 short", 4097), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64SB.asm", "C64 short basic", 5121), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64SW.asm", "C64 short wrap", 4353), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64D.asm", "C64 delta", 513), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64F.asm", "C64 fast", 2049), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64W.asm", "C64 wrap", 257), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64WD.asm", "C64 wrap delta", 769), new Decruncher("/libsidutils/cruncher/PUCrunch_headerC64WF.asm", "C64 fast wrap", 2305)};
    private static final int F_AUTO = 4;
    private static final int F_NOOPT = 8;
    private static final int F_AUTOEX = 16;
    private static final int F_2MHZ = 64;
    private static final int LITERAL = 0;
    private static final int LZ77 = 1;
    private static final int RLE = 2;
    private static final int DLZ = 3;
    private static final int MMARK = 4;
    private static final int F_NORLE = 512;
    private static final int OUT_SIZE = 2000000;
    private int maxGamma = 7;
    private int reservedBytes = 2;
    private int escBits = 2;
    private int escMask = 192;
    private int extraLZPosBits = 0;
    private int rleUsed = 15;
    private int memConfig = 55;
    private int cliConfig = 88;
    private int lrange = ((2 << this.maxGamma) - 3) * 256;
    private int maxlzlen = 2 << this.maxGamma;
    private int maxrlelen = ((2 << this.maxGamma) - 2) * 256;
    private int size = 0;
    private int bitMask = 128;
    private int timesDLz = 0;
    private int inlen;
    private int lzopt = 0;
    private byte[] outBuffer = new byte[2000000];
    private byte[] indata;
    private byte[] newesc;
    private byte[] rleValues = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] lenValue = new int[256];
    private int[] rleHist = new int[256];
    private int[] rleLen = new int[256];
    private int[][] lenStat = new int[8][4];
    private int[] rle;
    private int[] elr;
    private int[] lzlen;
    private int[] lzpos;
    private int[] lzmlen;
    private int[] lzmpos;
    private int[] lzlen2;
    private int[] lzpos2;
    private int[] mode;
    private int[] backSkip;
    private int[] length;
    private boolean verbose = false;

    private Decruncher BestMatch(int type2) {
        Decruncher best = null;
        for (Decruncher dc : DECRUNCHERS) {
            if ((dc.getFlags() & 0xFF) != (type2 & 0xFF) || (dc.getFlags() & type2 & 0x700) != (type2 & 0x700)) continue;
            if (null == best || (type2 & 0x100) == (dc.getFlags() & 0x100) && (0 == (type2 & 0x1800) || (dc.getFlags() & type2 & 0x1800) != 0)) {
                best = dc;
            }
            if ((type2 & 0x1800) != (dc.getFlags() & 0x1800)) continue;
            return dc;
        }
        if (null == best) {
            throw new RuntimeException("No matching decompressor found\n");
        }
        return best;
    }

    private void SavePack(int type2, PrintStream fp, int start, int exec, int escape, int endAddr, int progEnd, boolean enable2MHz, int memStart, int memEnd) {
        int overlap = 0;
        if (endAddr > memEnd) {
            overlap = endAddr - memEnd;
            endAddr = memEnd;
            if (overlap > 22) {
                System.err.printf("Warning: data overlap is %d, but only 22 is totally safe!\n", overlap);
                System.err.printf("The data from $61 to $%02x is overwritten.\n", 75 + overlap);
            }
        }
        type2 = overlap != 0 ? (type2 |= 0x100) : (type2 &= 0xFFFFFEFF);
        Decruncher dc = this.BestMatch(type2);
        HashMap<String, String> globals = new HashMap<String, String>();
        globals.put("pc", String.valueOf(memStart));
        globals.put("ftFastDisable", String.valueOf(enable2MHz ? 1 : 0));
        globals.put("ftOverlap", String.valueOf(overlap != 0 ? overlap - 1 : 0));
        globals.put("ftOverlapAddr", String.valueOf(this.rleUsed - 15 + this.size - overlap));
        globals.put("ftSizePages", String.valueOf((this.size >> 8) + 1));
        globals.put("ftSizeAddr", String.valueOf(this.rleUsed - 15 + this.size - 256 - overlap));
        globals.put("ftEndAddr", String.valueOf(endAddr - 256));
        globals.put("ftEscBits", String.valueOf(this.escBits));
        globals.put("ftEscValue", String.valueOf(escape >> 8 - this.escBits));
        globals.put("ftOutposAddr", String.valueOf(start));
        globals.put("ftMaxGamma", String.valueOf(this.maxGamma));
        globals.put("ftExtraBits", String.valueOf(this.extraLZPosBits));
        globals.put("ftMemConfig", String.valueOf(this.memConfig));
        globals.put("ftCli", String.valueOf(this.cliConfig));
        globals.put("ftExec", String.valueOf(exec));
        globals.put("ftInpos", String.valueOf(endAddr + overlap - this.size));
        globals.put("ftBEndAddr", String.valueOf(progEnd));
        for (int i = 1; i <= 15; ++i) {
            globals.put("rleValue" + i, String.valueOf(this.rleValues[i]));
        }
        InputStream asm = PUCrunch.class.getResourceAsStream(dc.getResourceName());
        KickAssemblerResult kickAssemblerResult = KickAssembler.assemble(dc.getResourceName(), asm, globals);
        byte[] header = kickAssemblerResult.getData();
        Map<String, Integer> labels = kickAssemblerResult.getResolvedSymbols();
        int stackUsed = labels.get("ftStackSize");
        int ibufferUsed = labels.get("ftIBufferSize") != null ? labels.get("ftIBufferSize") : 0;
        fp.write(header, 0, header.length + this.rleUsed - 15);
        fp.write(this.outBuffer, 0, this.size);
        this.printCrunchingResult(stackUsed, ibufferUsed, start, endAddr, memStart, overlap, dc, header);
    }

    private void FlushBits() {
        if (this.bitMask != 128) {
            ++this.size;
        }
    }

    private void PutBit(int bit) {
        if (bit != 0 && this.size < 2000000) {
            int n = this.size;
            this.outBuffer[n] = (byte)(this.outBuffer[n] | this.bitMask);
        }
        this.bitMask >>= 1;
        if (0 == this.bitMask) {
            this.bitMask = 128;
            ++this.size;
        }
    }

    private void PutValue(int value) {
        int bits = 0;
        int count = 0;
        while (value > 1) {
            bits = bits << 1 | value & 1;
            value >>= 1;
            ++count;
            this.PutBit(1);
        }
        if (count < this.maxGamma) {
            this.PutBit(0);
        }
        while (count-- != 0) {
            this.PutBit(bits & 1);
            bits >>= 1;
        }
    }

    private int RealLenValue(int value) {
        int count = 0;
        if (value < 2) {
            count = 0;
        } else if (value < 4) {
            count = 1;
        } else if (value < 8) {
            count = 2;
        } else if (value < 16) {
            count = 3;
        } else if (value < 32) {
            count = 4;
        } else if (value < 64) {
            count = 5;
        } else if (value < 128) {
            count = 6;
        } else if (value < 256) {
            count = 7;
        }
        if (count < this.maxGamma) {
            return 2 * count + 1;
        }
        return 2 * count;
    }

    private void initValueLen() {
        for (int i = 1; i < 256; ++i) {
            this.lenValue[i] = this.RealLenValue(i);
        }
    }

    private void PutNBits(int b, int bits) {
        while (bits-- != 0) {
            this.PutBit(b & 1 << bits);
        }
    }

    private int OutputNormal(int esc, byte[] data, int dataPos, int newesc) {
        if ((data[dataPos + 0] & this.escMask) == esc) {
            this.PutNBits(esc >> 8 - this.escBits, this.escBits);
            this.PutValue(1);
            this.PutBit(1);
            this.PutBit(0);
            esc = newesc;
            this.PutNBits(esc >> 8 - this.escBits, this.escBits);
            this.PutNBits(data[dataPos + 0] & 0xFF, 8 - this.escBits);
            return newesc;
        }
        this.PutNBits(data[dataPos + 0] & 0xFF, 8);
        return esc;
    }

    private void OutputEof(int esc) {
        this.PutNBits(esc >> 8 - this.escBits, this.escBits);
        this.PutValue(2);
        this.PutValue((2 << this.maxGamma) - 1);
        this.FlushBits();
    }

    private void PutRleByte(int data) {
        for (int index = 1; index < 16; ++index) {
            if (data != (this.rleValues[index] & 0xFF)) continue;
            if (index == 1) {
                int[] nArray = this.lenStat[0];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 3) {
                int[] nArray = this.lenStat[1];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 7) {
                int[] nArray = this.lenStat[2];
                nArray[3] = nArray[3] + 1;
            } else if (index <= 15) {
                int[] nArray = this.lenStat[3];
                nArray[3] = nArray[3] + 1;
            }
            this.PutValue(index);
            return;
        }
        this.PutValue(16 + (data >> 4));
        this.PutNBits(data, 4);
        int[] nArray = this.lenStat[4];
        nArray[3] = nArray[3] + 1;
    }

    private void InitRleLen() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.rleLen[i] = this.lenValue[16] + 4;
        }
        for (i = 1; i < 16; ++i) {
            this.rleLen[this.rleValues[i] & 0xFF] = this.lenValue[i];
        }
    }

    private int LenRle(int len, int data) {
        int out = 0;
        do {
            if (len == 1) {
                out += this.escBits + 3 + 8;
                len = 0;
                continue;
            }
            if (len <= 1 << this.maxGamma) {
                out += this.escBits + 3 + this.lenValue[len - 1] + this.rleLen[data];
                len = 0;
                continue;
            }
            int tmp = Math.min(len, this.maxrlelen);
            out += this.escBits + 3 + this.maxGamma + 8 + this.lenValue[(tmp - 1 >> 8) + 1] + this.rleLen[data];
            len -= tmp;
        } while (len != 0);
        return out;
    }

    private int OutputRle(int esc, byte[] data, int dataPos, int rlelen) {
        int len = rlelen;
        while (len != 0) {
            if (len >= 2 && len <= 1 << this.maxGamma) {
                if (len == 2) {
                    int[] nArray = this.lenStat[0];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 4) {
                    int[] nArray = this.lenStat[1];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 8) {
                    int[] nArray = this.lenStat[2];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 16) {
                    int[] nArray = this.lenStat[3];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 32) {
                    int[] nArray = this.lenStat[4];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 64) {
                    int[] nArray = this.lenStat[5];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 128) {
                    int[] nArray = this.lenStat[6];
                    nArray[2] = nArray[2] + 1;
                } else if (len <= 256) {
                    int[] nArray = this.lenStat[6];
                    nArray[2] = nArray[2] + 1;
                }
                this.PutNBits(esc >> 8 - this.escBits, this.escBits);
                this.PutValue(1);
                this.PutBit(1);
                this.PutBit(1);
                this.PutValue(len - 1);
                this.PutRleByte(data[dataPos] & 0xFF);
                return esc;
            }
            if (len < 3) {
                while (len-- != 0) {
                    esc = this.OutputNormal(esc, data, dataPos, esc);
                }
                return esc;
            }
            if (len <= this.maxrlelen) {
                this.PutNBits(esc >> 8 - this.escBits, this.escBits);
                this.PutValue(1);
                this.PutBit(1);
                this.PutBit(1);
                this.PutValue((1 << this.maxGamma) + ((len - 1 & 0xFF) >> 8 - this.maxGamma));
                this.PutNBits(len - 1, 8 - this.maxGamma);
                this.PutValue((len - 1 >> 8) + 1);
                this.PutRleByte(data[dataPos] & 0xFF);
                return esc;
            }
            this.PutNBits(esc >> 8 - this.escBits, this.escBits);
            this.PutValue(1);
            this.PutBit(1);
            this.PutBit(1);
            this.PutValue((1 << this.maxGamma) + ((this.maxrlelen - 1 & 0xFF) >> 8 - this.maxGamma));
            this.PutNBits(this.maxrlelen - 1 & 0xFF, 8 - this.maxGamma);
            this.PutValue((this.maxrlelen - 1 >> 8) + 1);
            this.PutRleByte(data[dataPos]);
            len -= this.maxrlelen;
            dataPos += this.maxrlelen;
        }
        return esc;
    }

    private int LenDLz(int lzlen, int lzpos) {
        return this.escBits + 2 * this.maxGamma + 8 + 8 + this.lenValue[lzlen - 1];
    }

    private void OutputDLz(int esc, int lzlen, int lzpos, int add) {
        this.PutNBits(esc >> 8 - this.escBits, this.escBits);
        this.PutValue(lzlen - 1);
        this.PutValue((2 << this.maxGamma) - 1);
        this.PutNBits(add, 8);
        this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
        ++this.timesDLz;
    }

    private int LenLz(int lzlen, int lzpos) {
        if (lzlen == 2) {
            if (lzpos <= 256) {
                return this.escBits + 2 + 8;
            }
            return 100000;
        }
        return this.escBits + 8 + this.extraLZPosBits + this.lenValue[(lzpos - 1 >> 8 + this.extraLZPosBits) + 1] + lzlen < 257 ? this.lenValue[lzlen - 1] : 50;
    }

    private void OutputLz(int esc, int lzlen, int lzpos, byte[] data, int dataPos, int curpos) {
        if (lzlen == 2) {
            int[] nArray = this.lenStat[0];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 4) {
            int[] nArray = this.lenStat[1];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 8) {
            int[] nArray = this.lenStat[2];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 16) {
            int[] nArray = this.lenStat[3];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 32) {
            int[] nArray = this.lenStat[4];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 64) {
            int[] nArray = this.lenStat[5];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 128) {
            int[] nArray = this.lenStat[6];
            nArray[1] = nArray[1] + 1;
        } else if (lzlen <= 256) {
            int[] nArray = this.lenStat[7];
            nArray[1] = nArray[1] + 1;
        }
        if (lzlen >= 2 && lzlen <= this.maxlzlen) {
            this.PutNBits(esc >> 8 - this.escBits, this.escBits);
            int tmp = (lzpos - 1 >> 8 + this.extraLZPosBits) + 2;
            if (tmp == 2) {
                int[] nArray = this.lenStat[0];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 4) {
                int[] nArray = this.lenStat[1];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 8) {
                int[] nArray = this.lenStat[2];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 16) {
                int[] nArray = this.lenStat[3];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 32) {
                int[] nArray = this.lenStat[4];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 64) {
                int[] nArray = this.lenStat[5];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 128) {
                int[] nArray = this.lenStat[6];
                nArray[0] = nArray[0] + 1;
            } else if (tmp <= 256) {
                int[] nArray = this.lenStat[6];
                nArray[0] = nArray[0] + 1;
            }
            if (lzlen == 2) {
                this.PutValue(lzlen - 1);
                this.PutBit(0);
                if (lzpos > 256) {
                    System.err.printf("Error at %d: lzpos too long (%d) for lzlen==2\n", curpos, lzpos);
                }
                this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
            } else {
                this.PutValue(lzlen - 1);
                this.PutValue((lzpos - 1 >> 8 + this.extraLZPosBits) + 1);
                this.PutNBits(lzpos - 1 >> 8, this.extraLZPosBits);
                this.PutNBits(lzpos - 1 & 0xFF ^ 0xFF, 8);
            }
            return;
        }
        System.err.printf("Error: lzlen too short/long (%d)\n", lzlen);
    }

    private int OptimizeLength(int optimize) {
        this.length[this.inlen] = 0;
        for (int i = this.inlen - 1; i >= 0; --i) {
            int ii;
            int minv;
            int mini;
            int v;
            int r2;
            int r1 = 8 + this.length[i + 1];
            if (0 == this.lzlen[i] && 0 == this.rle[i] && (null == this.lzlen2 || 0 == this.lzlen2[i])) {
                this.length[i] = r1;
                this.mode[i] = 0;
                continue;
            }
            if (this.rle[i] > this.maxlzlen && this.elr[i] > 1) {
                int z = this.elr[i];
                i -= this.elr[i];
                r2 = this.LenRle(this.rle[i], this.indata[i] & 0xFF) + this.length[i + this.rle[i]];
                if (optimize != 0) {
                    int mini2 = this.rle[i];
                    int minv2 = r2;
                    int bot = this.rle[i] - (1 << this.maxGamma);
                    if (bot < 2) {
                        bot = 2;
                    }
                    for (int ii2 = mini2 - 1; ii2 >= bot; --ii2) {
                        v = this.LenRle(ii2, this.indata[i] & 0xFF) + this.length[i + ii2];
                        if (v >= minv2) continue;
                        minv2 = v;
                        mini2 = ii2;
                    }
                    if (minv2 != r2) {
                        this.lzopt += r2 - minv2;
                        this.rle[i] = mini2;
                        r2 = minv2;
                    }
                }
                this.length[i] = r2;
                this.mode[i] = 2;
                while (z >= 0) {
                    this.length[i + z] = r2;
                    this.mode[i + z] = 2;
                    --z;
                }
                continue;
            }
            int r3 = r2 = r1 + 1000;
            if (this.rle[i] != 0) {
                r2 = this.LenRle(this.rle[i], this.indata[i] & 0xFF) + this.length[i + this.rle[i]];
                if (optimize != 0) {
                    mini = this.rle[i];
                    minv = r2;
                    for (ii = 2; this.rle[i] > ii; ii <<= 1) {
                        int v2 = this.LenRle(ii, this.indata[i] & 0xFF) + this.length[i + ii];
                        if (v2 >= minv) continue;
                        minv = v2;
                        mini = ii;
                    }
                    if (minv != r2) {
                        this.lzopt += r2 - minv;
                        this.rle[i] = mini;
                        r2 = minv;
                    }
                }
            }
            if (this.lzlen[i] != 0) {
                r3 = this.LenLz(this.lzlen[i], this.lzpos[i]) + this.length[i + this.lzlen[i]];
                if (optimize != 0 && this.lzlen[i] > 2) {
                    mini = this.lzlen[i];
                    minv = r3;
                    int mino = this.lzpos[i];
                    int topLen = this.LenLz(this.lzlen[i], this.lzpos[i]) - this.lenValue[this.lzlen[i] - 1];
                    for (ii = 4; this.lzlen[i] > ii; ii <<= 1) {
                        v = topLen + this.lenValue[ii - 1] + this.length[i + ii];
                        if (v >= minv) continue;
                        minv = v;
                        mini = ii;
                    }
                    for (ii = 3; this.lzmlen[i] >= ii; ++ii) {
                        v = this.LenLz(ii, this.lzmpos[i]) + this.length[i + ii];
                        if (v >= minv) continue;
                        minv = v;
                        mini = ii;
                        mino = this.lzmpos[i];
                    }
                    if (this.backSkip[i] != 0 && this.backSkip[i] <= 256 && (v = this.LenLz(2, this.backSkip[i]) + this.length[i + 2]) < minv) {
                        minv = v;
                        this.lzlen[i] = mini = 2;
                        r3 = minv;
                        this.lzpos[i] = this.backSkip[i];
                    }
                    if (minv != r3 && minv < r2) {
                        this.lzopt += r3 - minv;
                        this.lzlen[i] = mini;
                        this.lzpos[i] = mino;
                        r3 = minv;
                    }
                }
            }
            if (r2 <= r1) {
                if (r2 <= r3) {
                    this.length[i] = r2;
                    this.mode[i] = 2;
                } else {
                    this.length[i] = r3;
                    this.mode[i] = 1;
                }
            } else if (r3 <= r1) {
                this.length[i] = r3;
                this.mode[i] = 1;
            } else {
                this.length[i] = r1;
                this.mode[i] = 0;
            }
            if (this.lzlen2 == null || this.lzlen2[i] <= 3 || (r3 = this.LenDLz(this.lzlen2[i], this.lzpos2[i]) + this.length[i + this.lzlen2[i]]) >= this.length[i]) continue;
            this.length[i] = r3;
            this.mode[i] = 3;
        }
        return this.length[0];
    }

    private int OptimizeEscape(IntContainer startEscape, IntContainer nonNormal) {
        int i;
        int states = 1 << this.escBits;
        int minp = 0;
        int minv = 0;
        int other = 0;
        int[] a = new int[256];
        int[] b = new int[256];
        int esc8 = 8 - this.escBits;
        for (i = 0; i < 256; ++i) {
            a[i] = -1;
            b[i] = -1;
        }
        if (states > 256) {
            System.err.printf("Escape optimize: only 256 states (%d)!\n", states);
            return 0;
        }
        i = 0;
        block6: while (i < this.inlen) {
            switch (this.mode[i]) {
                case 3: {
                    ++other;
                    i += this.lzlen2[i];
                    continue block6;
                }
                case 1: {
                    ++other;
                    i += this.lzlen[i];
                    continue block6;
                }
                case 2: {
                    ++other;
                    i += this.rle[i];
                    continue block6;
                }
            }
            this.mode[i++] = 4;
        }
        block7: for (i = this.inlen - 1; i >= 0; --i) {
            if (this.mode[i] != 4) continue;
            int k = (this.indata[i] & 0xFF) >> esc8;
            this.mode[i] = 0;
            this.newesc[i] = (byte)(minp << esc8);
            a[k] = minv + 1;
            b[k] = b[minp] + 1;
            if (k != minp) continue;
            ++minv;
            for (k = states - 1; k >= 0; --k) {
                if (a[k] >= minv) continue;
                minv = a[k];
                minp = k;
                continue block7;
            }
        }
        if (startEscape != null) {
            i = this.inlen;
            for (int j = states - 1; j >= 0; --j) {
                if (a[j] > i) continue;
                startEscape.intVal = j << esc8;
                i = a[j];
            }
        }
        if (nonNormal != null) {
            nonNormal.intVal = other;
        }
        return b[startEscape != null ? startEscape.intVal >> esc8 : 0];
    }

    private void InitRle(int flags) {
        for (int i = 1; i < 16; ++i) {
            int mr = -1;
            int mv = 0;
            for (int j = 0; j < 256; ++j) {
                if (this.rleHist[j] <= mv) continue;
                mv = this.rleHist[j];
                mr = j;
            }
            if (mv <= 0) break;
            this.rleValues[i] = (byte)mr;
            this.rleHist[mr] = -1;
        }
        this.InitRleLen();
    }

    private void OptimizeRle(int flags) {
        int i;
        int p;
        if ((flags & 0x200) != 0) {
            this.rleUsed = 0;
            return;
        }
        for (p = 0; p < 256; ++p) {
            this.rleHist[p] = 0;
        }
        p = 0;
        block6: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 3: {
                    p += this.lzlen2[p];
                    continue block6;
                }
                case 1: {
                    p += this.lzlen[p];
                    continue block6;
                }
                case 2: {
                    int n = this.indata[p] & 0xFF;
                    this.rleHist[n] = this.rleHist[n] + 1;
                    p += this.rle[p];
                    continue block6;
                }
            }
            ++p;
        }
        for (i = 1; i < 16; ++i) {
            int mr = -1;
            int mv = 0;
            for (int p2 = 0; p2 < 256; ++p2) {
                if (this.rleHist[p2] <= mv) continue;
                mv = this.rleHist[p2];
                mr = p2;
            }
            if (mv <= 0) break;
            this.rleValues[i] = (byte)mr;
            this.rleHist[mr] = -1;
        }
        this.rleUsed = i - 1;
        this.InitRleLen();
    }

    private int PackLz77(int lzsz, int flags, int endAddr, int memEnd, int type2) {
        int rlep;
        int p;
        int escape = 0;
        if (lzsz < 0 || lzsz > this.lrange) {
            System.err.printf("LZ range must be from 0 to %d (was %d). Set to %d.\n", this.lrange, lzsz, this.lrange);
            lzsz = this.lrange;
        }
        if (lzsz > 65535) {
            System.err.printf("LZ range must be from 0 to 65535 (was %d). Set to 65535.\n", lzsz);
            lzsz = 65535;
        }
        if (0 == lzsz) {
            System.err.printf("Warning: zero LZ range. Only RLE packing used.\n", new Object[0]);
        }
        this.InitRleLen();
        this.length = new int[this.inlen + 1];
        this.mode = new int[this.inlen];
        this.rle = new int[this.inlen];
        this.elr = new int[this.inlen];
        this.lzlen = new int[this.inlen];
        this.lzpos = new int[this.inlen];
        this.lzmlen = new int[this.inlen];
        this.lzmpos = new int[this.inlen];
        if ((type2 & 0x200) != 0) {
            this.lzlen2 = new int[this.inlen];
            this.lzpos2 = new int[this.inlen];
        } else {
            this.lzpos2 = null;
            this.lzlen2 = null;
        }
        this.newesc = new byte[this.inlen];
        this.backSkip = new int[this.inlen];
        int[] hashValue = new int[this.inlen];
        int[] lastPair = new int[65536];
        int i = 0;
        int j = 0;
        int a = this.inlen;
        for (p = this.inlen - 1; p >= 0; --p) {
            int k = j;
            j = i;
            i = this.indata[--a] & 0xFF;
            hashValue[p] = i * 3 + j * 5 + k * 7;
        }
        for (p = 0; p < this.inlen; ++p) {
            int tmppos;
            int tmplen;
            int topindex;
            int b;
            int valueCompare;
            if (this.rle[p] <= 0) {
                int rlelen;
                a = p;
                int val = this.indata[a++] & 0xFF;
                int top = this.inlen - p;
                for (rlelen = 1; rlelen < top && (this.indata[a++] & 0xFF) == val; ++rlelen) {
                }
                if (rlelen >= 2) {
                    int n = this.indata[p] & 0xFF;
                    this.rleHist[n] = this.rleHist[n] + 1;
                    for (i = rlelen - 1; i >= 0; --i) {
                        this.rle[p + i] = rlelen - i;
                        this.elr[p + i] = i;
                    }
                }
            }
            if (p + this.rle[p] + 1 < this.inlen) {
                int bot = p - lzsz;
                int rlep2 = this.rle[p];
                valueCompare = 0;
                int hashCompare = hashValue[p];
                if (rlep2 <= 0) {
                    rlep2 = 1;
                }
                if (bot < 0) {
                    bot = 0;
                }
                if ((i = lastPair[(this.indata[p] & 0xFF) << 8 | this.indata[p + 1] & 0xFF] - 1) >= 0 && i >= (bot += rlep2 - 1)) {
                    int maxval = 2;
                    int maxpos = p - i;
                    for (i = lastPair[(this.indata[p + rlep2 - 1] & 0xFF) << 8 | this.indata[p + rlep2] & 0xFF] - 1; i >= bot; i -= this.backSkip[i]) {
                        if (!(0 != rlep2 - 1 && this.rle[i - (rlep2 - 1)] != rlep2 || hashValue[i + maxval - rlep2 - 1] != hashCompare && (this.indata[i + maxval - rlep2 + 1] & 0xFF) != valueCompare)) {
                            a = i + 2;
                            b = p + rlep2 - 1 + 2;
                            topindex = this.inlen - (p + rlep2 - 1);
                            for (j = 2; j < topindex && this.indata[a++] == this.indata[b++]; ++j) {
                            }
                            if (j + rlep2 - 1 > maxval) {
                                tmplen = j + rlep2 - 1;
                                tmppos = p - i + rlep2 - 1;
                                if (tmplen > this.maxlzlen) {
                                    tmplen = this.maxlzlen;
                                }
                                if (this.lzmlen[p] < tmplen) {
                                    this.lzmlen[p] = tmplen;
                                    this.lzmpos[p] = tmppos;
                                }
                                if (tmplen * 8 - this.LenLz(tmplen, tmppos) > maxval * 8 - this.LenLz(maxval, maxpos)) {
                                    maxval = tmplen;
                                    maxpos = tmppos;
                                    hashCompare = hashValue[p + maxval - 2];
                                }
                                if (maxval == this.maxlzlen) break;
                            }
                        }
                        if (0 == this.backSkip[i]) break;
                    }
                    if (p != 0 && this.rle[p - 1] > maxval) {
                        maxval = this.rle[p - 1] - 1;
                        maxpos = 1;
                    }
                    if (maxval < this.maxlzlen && rlep2 > maxval) {
                        bot = p - lzsz;
                        if (bot < 0) {
                            bot = 0;
                        }
                        for (i = lastPair[(this.indata[p] & 0xFF) * 257] - 1; i >= bot; i -= this.backSkip[i]) {
                            if (this.elr[i] + 2 > maxval) {
                                maxval = Math.min(this.elr[i] + 2, rlep2);
                                maxpos = p - i + maxval - 2;
                                if (maxval == rlep2) break;
                            }
                            if (0 == this.backSkip[i -= this.elr[i]]) break;
                        }
                    }
                    if (p + maxval > this.inlen) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d - exceeds inlen\n", p, maxval, maxpos);
                        maxval = this.inlen - p;
                    }
                    if (this.lzmlen[p] < maxval) {
                        this.lzmlen[p] = maxval;
                        this.lzmpos[p] = maxpos;
                    }
                    if (maxpos <= 256 || maxval > 2) {
                        if (maxpos < 0) {
                            System.err.printf("Error @ %d, lzlen %d, pos %d\n", p, maxval, maxpos);
                        }
                        this.lzlen[p] = maxval < this.maxlzlen ? maxval : this.maxlzlen;
                        this.lzpos[p] = maxpos;
                    }
                }
            }
            if ((type2 & 0x200) != 0 && p + this.rle[p] + 1 < this.inlen) {
                for (int rot = 1; rot < 255; ++rot) {
                    int bot = p - 256;
                    rlep = this.rle[p];
                    valueCompare = (this.indata[p + 2] & 0xFF) + rot & 0xFF;
                    if (rlep <= 0) {
                        rlep = 1;
                    }
                    if (bot < 0) {
                        bot = 0;
                    }
                    if ((i = lastPair[((this.indata[p] & 0xFF) + rot & 0xFF) << 8 | (this.indata[p + 1] & 0xFF) + rot & 0xFF] - 1) < 0 || i < (bot += rlep - 1)) continue;
                    int maxval = 2;
                    int maxpos = p - i;
                    for (i = lastPair[((this.indata[p + rlep - 1] & 0xFF) + rot & 0xFF) << 8 | (this.indata[p + rlep] & 0xFF) + rot & 0xFF] - 1; i >= bot; i -= this.backSkip[i]) {
                        if ((0 == rlep - 1 || this.rle[i - (rlep - 1)] == rlep) && (this.indata[i + maxval - rlep + 1] & 0xFF) == valueCompare) {
                            a = i + 2;
                            b = p + rlep - 1 + 2;
                            topindex = this.inlen - (p + rlep - 1);
                            for (j = 2; j < topindex && (this.indata[a++] & 0xFF) == ((this.indata[b++] & 0xFF) + rot & 0xFF); ++j) {
                            }
                            if (j + rlep - 1 > maxval) {
                                tmplen = j + rlep - 1;
                                tmppos = p - i + rlep - 1;
                                if (tmplen > this.maxlzlen) {
                                    tmplen = this.maxlzlen;
                                }
                                if (tmplen * 8 - this.LenLz(tmplen, tmppos) > maxval * 8 - this.LenLz(maxval, maxpos)) {
                                    maxval = tmplen;
                                    maxpos = tmppos;
                                    valueCompare = (this.indata[p + maxval] & 0xFF) + rot & 0xFF;
                                }
                                if (maxval == this.maxlzlen) break;
                            }
                        }
                        if (0 == this.backSkip[i]) break;
                    }
                    if (p + maxval > this.inlen) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d - exceeds inlen\n", p, maxval, maxpos);
                        maxval = this.inlen - p;
                    }
                    if (maxval <= 3 || maxpos > 256 || maxval <= this.lzlen2[p] && (maxval != this.lzlen2[p] || maxpos >= this.lzpos2[p])) continue;
                    if (maxpos < 0) {
                        System.err.printf("Error @ %d, lzlen %d, pos %d\n", p, maxval, maxpos);
                    }
                    this.lzlen2[p] = maxval < this.maxlzlen ? maxval : this.maxlzlen;
                    this.lzpos2[p] = maxpos;
                }
                if (this.lzlen2[p] <= this.lzlen[p] || this.lzlen2[p] <= this.rle[p]) {
                    this.lzpos2[p] = 0;
                    this.lzlen2[p] = 0;
                }
            }
            if (p + 1 >= this.inlen) continue;
            int index = (this.indata[p] & 0xFF) << 8 | this.indata[p + 1] & 0xFF;
            int ptr = p - (lastPair[index] - 1);
            if (ptr > p || ptr > 65535) {
                ptr = 0;
            }
            this.backSkip[p] = ptr;
            lastPair[index] = p + 1;
        }
        if ((flags & 0x200) != 0) {
            for (p = 1; p < this.inlen; ++p) {
                if (this.rle[p - 1] - 1 <= this.lzlen[p]) continue;
                this.lzlen[p] = this.rle[p] < this.maxlzlen ? this.rle[p] : this.maxlzlen;
                this.lzpos[p] = 1;
            }
            for (p = 0; p < this.inlen; ++p) {
                this.rle[p] = 0;
            }
        }
        this.InitRle(flags);
        if ((flags & 4) != 0) {
            int escaped;
            int mb = 0;
            int mv = 16000000;
            this.escBits = 1;
            while (this.escBits < 9) {
                int other = 0;
                this.escMask = 65280 >> this.escBits & 0xFF;
                this.OptimizeLength(0);
                IntContainer escapeCont = new IntContainer(escape);
                IntContainer otherCont = new IntContainer(other);
                escaped = this.OptimizeEscape(escapeCont, otherCont);
                escape = escapeCont.intVal;
                other = otherCont.intVal;
                int c = (this.escBits + 3) * escaped + other * this.escBits;
                if (c >= mv) break;
                mb = this.escBits++;
                mv = c;
            }
            if (mb == 1) {
                this.escBits = 0;
                this.escMask = 0;
                this.OptimizeLength(0);
                IntContainer escapeCont = new IntContainer(escape);
                escaped = this.OptimizeEscape(escapeCont, null);
                escape = escapeCont.intVal;
                if (3 * escaped < mv) {
                    mb = 0;
                }
            }
            this.escBits = mb;
            this.escMask = 65280 >> this.escBits & 0xFF;
        }
        this.OptimizeLength((flags & 8) != 0 ? 0 : 1);
        if ((flags & 0x10) != 0) {
            int[] lzstat = new int[]{0, 0, 0, 0, 0};
            int cur = 0;
            int old = this.extraLZPosBits;
            p = 0;
            block35: while (p < this.inlen) {
                switch (this.mode[p]) {
                    case 1: {
                        this.extraLZPosBits = 0;
                        lzstat[0] = lzstat[0] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 1;
                        lzstat[1] = lzstat[1] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 2;
                        lzstat[2] = lzstat[2] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 3;
                        lzstat[3] = lzstat[3] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        this.extraLZPosBits = 4;
                        lzstat[4] = lzstat[4] + this.LenLz(this.lzlen[p], this.lzpos[p]);
                        p += this.lzlen[p];
                        continue block35;
                    }
                    case 3: {
                        p += this.lzlen2[p];
                        continue block35;
                    }
                    case 2: {
                        p += this.rle[p];
                        continue block35;
                    }
                }
                ++p;
            }
            for (i = 0; i < 5; ++i) {
                if (lzstat[i] >= lzstat[cur]) continue;
                cur = i;
            }
            int n = this.extraLZPosBits = (flags & 0x10) != 0 ? cur : old;
            if (this.extraLZPosBits != old) {
                this.OptimizeLength((flags & 8) != 0 ? 0 : 1);
            }
        }
        int[] stat = new int[]{0, 0, 0, 0};
        p = 0;
        block37: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 1: {
                    if ((this.lzpos[p] >> 8) + 1 > 1 << this.maxGamma) {
                        stat[3] = stat[3] + 1;
                    }
                    if (this.lzlen[p] > 1 << this.maxGamma) {
                        stat[0] = stat[0] + 1;
                    }
                    p += this.lzlen[p];
                    continue block37;
                }
                case 2: {
                    if (this.rle[p] > 1 << this.maxGamma - 1 && this.rle[p] <= 1 << this.maxGamma) {
                        stat[1] = stat[1] + 1;
                    }
                    p += this.rle[p];
                    continue block37;
                }
                case 3: {
                    p += this.lzlen2[p];
                    continue block37;
                }
            }
            ++p;
        }
        IntContainer escapeCont = new IntContainer(escape);
        this.OptimizeEscape(escapeCont, null);
        int startEscape = escape = escapeCont.intVal;
        this.OptimizeRle(flags);
        int esc = escape;
        p = 0;
        block38: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 0: {
                    if ((this.indata[p] & this.escMask) == esc) {
                        esc = this.newesc[p] & 0xFF;
                    }
                    ++p;
                    continue block38;
                }
                case 3: {
                    p += this.lzlen2[p];
                    continue block38;
                }
                case 1: {
                    if (this.lzopt != 0 && this.lzlen[p] > 2) {
                        int bot = p - this.lzpos[p] + 1;
                        rlep = this.rle[p];
                        if (0 == rlep) {
                            rlep = 1;
                        }
                        if (bot < 0) {
                            bot = 0;
                        }
                        bot += rlep - 1;
                        for (i = p - this.backSkip[p]; i >= bot; i -= this.backSkip[i]) {
                            if (rlep == 1 || this.rle[i - rlep + 1] == rlep) {
                                a = i + 1;
                                int b = p + rlep - 1 + 1;
                                int topindex = this.inlen - (p + rlep - 1);
                                for (j = 1; j < topindex && this.indata[a++] == this.indata[b++]; ++j) {
                                }
                                if (j + rlep - 1 >= this.lzlen[p]) {
                                    int tmppos;
                                    this.lzpos[p] = tmppos = p - i + rlep - 1;
                                    break;
                                }
                            }
                            if (0 == this.backSkip[i]) break;
                        }
                    }
                    p += this.lzlen[p];
                    continue block38;
                }
                case 2: {
                    p += this.rle[p];
                    continue block38;
                }
            }
            System.err.printf("Internal error: mode %d\n", this.mode[p]);
            ++p;
        }
        p = 0;
        block41: while (p < this.inlen) {
            switch (this.mode[p]) {
                case 0: {
                    this.length[p] = this.size;
                    escape = this.OutputNormal(escape, this.indata, p, this.newesc[p] & 0xFF);
                    ++p;
                    continue block41;
                }
                case 3: {
                    for (i = 0; i < this.lzlen2[p]; ++i) {
                        this.length[p + i] = this.size;
                    }
                    this.OutputDLz(escape, this.lzlen2[p], this.lzpos2[p], (this.indata[p] & 0xFF) - (this.indata[p - this.lzpos2[p]] & 0xFF) & 0xFF);
                    p += this.lzlen2[p];
                    continue block41;
                }
                case 1: {
                    for (i = 0; i < this.lzlen[p]; ++i) {
                        this.length[p + i] = this.size;
                    }
                    this.OutputLz(escape, this.lzlen[p], this.lzpos[p], this.indata, p - this.lzpos[p], p);
                    p += this.lzlen[p];
                    continue block41;
                }
                case 2: {
                    for (i = 0; i < this.rle[p]; ++i) {
                        this.length[p + i] = this.size;
                    }
                    escape = this.OutputRle(escape, this.indata, p, this.rle[p]);
                    p += this.rle[p];
                    continue block41;
                }
            }
            System.err.printf("Internal error: mode %d\n", this.mode[p]);
            ++p;
        }
        this.OutputEof(escape);
        i = this.inlen;
        for (p = 0; p < this.inlen; ++p) {
            int pos = this.inlen - this.size + this.length[p] - p;
            i = Math.min(i, pos);
        }
        this.reservedBytes = i < 0 ? -i + 2 : 0;
        return startEscape;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private int getSYSAddr(int offset) {
        int execAddr = -1;
        if (0 <= offset) {
            for (int i = offset; i < offset + 60; ++i) {
                if (this.indata[i] != -98) continue;
                execAddr = 0;
                ++i;
                while (this.indata[i] == 40 || this.indata[i] == 32) {
                    ++i;
                }
                while (this.indata[i] >= 48 && this.indata[i] <= 57) {
                    execAddr = execAddr * 10 + this.indata[i++] - 48;
                }
                break;
            }
        }
        return execAddr;
    }

    private void printCrunchInput(String input, int startAddr, int memStart, int execAddr) {
        if (this.verbose) {
            System.out.println("Crunching " + input);
            System.out.printf("Load address 0x%04x, End address 0x%04x\n", startAddr, startAddr + this.inlen - 1);
            System.out.printf("Exec address 0x%04x\n", execAddr);
            System.out.printf("New load address 0x%04x\n", memStart);
            System.out.printf("Interrupts %s and memory config set to $%02x after decompression\n", this.cliConfig == 88 ? "enabled" : "disabled", this.memConfig);
        }
    }

    private void printCrunchingResult(int stackUsed, int ibufferUsed, int start, int endAddr, int memStart, int overlap, Decruncher dc, byte[] header) {
        if (this.verbose) {
            System.out.printf("Saving %s\n", dc.getName());
            if ((dc.getFlags() & 0x1000) != 0) {
                System.out.printf("Uses the memory $2d-$30, ", new Object[0]);
            } else {
                System.out.printf("Uses the memory $2d/$2e, ", new Object[0]);
            }
            if (overlap != 0) {
                System.out.printf("$4b-$%02x, ", 75 + overlap);
            } else if ((dc.getFlags() & 0x100) != 0) {
                System.out.printf("$4b, ", new Object[0]);
            }
            if (stackUsed != 0) {
                System.out.printf("$f7-$%x, ", 247 + stackUsed);
            }
            if (ibufferUsed != 0) {
                System.out.printf("$200-$%x, ", 512 + ibufferUsed);
            }
            System.out.printf("and $%04x-$%04x.\n", start < memStart + 1 ? start : memStart + 1, endAddr - 1);
            System.out.printf("Uncompressed %d bytes, Compressed %d bytes\n", this.inlen, header.length + this.rleUsed - 15 + this.size);
        }
    }

    public void crunch(String input, String output) throws IOException {
        try (DataInputStream infp = new DataInputStream(new FileInputStream(input));
             PrintStream outfp = new PrintStream(output);){
            int endAddr;
            this.initValueLen();
            int startAddr = (infp.read() & 0xFF) + 256 * (infp.read() & 0xFF);
            this.indata = new byte[this.lrange];
            int count = 0;
            while (this.inlen < this.lrange && (count = infp.read(this.indata, this.inlen, this.lrange - this.inlen)) >= 0) {
                this.inlen += count;
            }
            if (startAddr < 600 || startAddr + this.inlen - 1 > 65535) {
                throw new RuntimeException("Only programs from 0x0258 to 0xffff can be compressed");
            }
            int type2 = 1281;
            int memStart = 2049;
            int memEnd = 65536;
            int execAddr = this.getSYSAddr(memStart - startAddr);
            if (execAddr < startAddr || execAddr >= startAddr + this.inlen) {
                if ((type2 & 0x400) != 0) {
                    execAddr = 42926;
                } else {
                    throw new RuntimeException("Note: The execution address was not detected correctly!");
                }
            }
            this.printCrunchInput(input, startAddr, memStart, execAddr);
            int flags = 84;
            int startEscape = this.PackLz77(this.lrange, flags, startAddr + this.inlen, memEnd, type2);
            int progEnd = endAddr = startAddr + this.inlen;
            int maxDecruncherLen = 512;
            if (endAddr - (this.size + 255 & 0xFFFFFF00) < memStart + maxDecruncherLen + 3) {
                endAddr = memStart + maxDecruncherLen + 3 + (this.size + 255 & 0xFFFFFF00);
            }
            endAddr += 3 + this.reservedBytes;
            if (0 == this.timesDLz) {
                type2 &= 0xFFFFFDFF;
            }
            if ((memStart & 0xFF) != 1) {
                throw new RuntimeException(String.format("Misaligned basic start 0x%04x\n", memStart));
            }
            if (memStart > 9999) {
                throw new RuntimeException(String.format("Too high basic start 0x%04x\n", memStart));
            }
            this.SavePack(type2, outfp, startAddr, execAddr, startEscape, endAddr, progEnd, (flags & 0x40) != 0, memStart, memEnd);
        }
    }

    private static class IntContainer {
        private int intVal;

        public IntContainer(int v) {
            this.intVal = v;
        }
    }
}

