/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import libsidplay.components.cart.Cartridge;
import libsidutils.directory.Directory;

public class CartridgeDirectory
extends Directory {
    public CartridgeDirectory(File file) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            byte[] header = new byte[64];
            dis.readFully(header);
            Cartridge.CRTType type2 = Cartridge.CRTType.getType(header);
            this.title = type2.toString().replace('_', '-').getBytes(StandardCharsets.ISO_8859_1);
            this.id = String.valueOf(file.length() >> 10).getBytes(StandardCharsets.ISO_8859_1);
        }
    }
}

