/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.disassembler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import libsidutils.disassembler.CPUCommand;
import libsidutils.disassembler.IMOS6510Disassembler;

public class SimpleDisassembler
implements IMOS6510Disassembler {
    private static HashMap<Integer, CPUCommand> cpuCommands = new HashMap();
    private static SimpleDisassembler theInstance;

    public static Map<Integer, CPUCommand> getCpuCommands() {
        return Collections.unmodifiableMap(cpuCommands);
    }

    public static final SimpleDisassembler getInstance() {
        if (theInstance == null) {
            theInstance = new SimpleDisassembler();
        }
        return theInstance;
    }

    public String getDisassembly(byte[] ram, int instrAddress) {
        CPUCommand cmd = cpuCommands.get(ram[instrAddress] & 0xFF);
        String base = cmd.getCmd();
        if (cmd.getByteCount() == 2) {
            base = base + ":";
            int nextByte = ram[instrAddress + 1 & 0xFFFF] & 0xFF;
            base = (cmd.getOpCode() & 0x1F) == 16 ? base + String.format(cmd.getFormat(), nextByte, instrAddress + cmd.getByteCount() + (byte)nextByte & 0xFFFF) : base + String.format(cmd.getFormat(), nextByte);
        } else if (cmd.getByteCount() == 3) {
            base = base + ":";
            base = base + String.format(cmd.getFormat(), (ram[instrAddress + 2 & 0xFFFF] & 0xFF) << 8 | ram[instrAddress + 1 & 0xFFFF] & 0xFF);
        }
        return base;
    }

    @Override
    public String disassemble(int opcode, int operand, int address) {
        CPUCommand cmd = cpuCommands.get(opcode);
        String base = cmd.getCmd() + cmd.getAddressing();
        if (cmd.getByteCount() == 2) {
            base = (cmd.getOpCode() & 0x1F) == 16 ? base + String.format(cmd.getFormat(), operand & 0xFF, address) : base + " " + String.format(cmd.getFormat(), operand & 0xFF);
        } else if (cmd.getByteCount() == 3) {
            base = base + " " + String.format(cmd.getFormat(), operand);
        }
        return base;
    }

    private static void parse() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SimpleDisassembler.class.getResourceAsStream("cpu.properties")));){
            String line;
            while (null != (line = reader.readLine())) {
                String[] args = line.split(":");
                int opCode = Integer.parseInt(args[0], 16);
                String cmd = args[1];
                String addressing = args[2];
                String format = args[3];
                int byteCount = Integer.parseInt(args[4]);
                String cycles = args.length < 5 ? "" : args[4];
                CPUCommand cpuCmd = new CPUCommand(opCode, cmd, addressing, format, byteCount, cycles);
                cpuCommands.put(opCode, cpuCmd);
            }
        }
    }

    static {
        try {
            SimpleDisassembler.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

