/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import libsidplay.common.SamplingRate;
import libsidutils.AudioUtils;
import libsidutils.fingerprinting.IFingerprintInserter;
import libsidutils.fingerprinting.IFingerprintMatcher;
import libsidutils.fingerprinting.Index;
import libsidutils.fingerprinting.fingerprint.Fingerprint;
import libsidutils.fingerprinting.ini.IFingerprintConfig;
import libsidutils.fingerprinting.model.SongMatch;
import libsidutils.fingerprinting.rest.FingerPrintingDataSource;
import libsidutils.fingerprinting.rest.beans.IdBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.fingerprinting.rest.beans.SongNoBean;
import libsidutils.fingerprinting.rest.beans.WAVBean;

public class FingerPrinting
implements IFingerprintMatcher,
IFingerprintInserter {
    private static final int MIN_HIT = 15;
    private IFingerprintConfig config;
    private FingerPrintingDataSource fingerPrintingDataSource;

    public FingerPrinting(IFingerprintConfig config, FingerPrintingDataSource fingerPrintingDataSource) {
        this.config = config;
        this.fingerPrintingDataSource = fingerPrintingDataSource;
    }

    @Override
    public void insert(MusicInfoBean musicInfoBean, WAVBean wavBean) throws IOException {
        if (wavBean != null && wavBean.getWav().length > 0 && !this.fingerPrintingDataSource.tuneExists(musicInfoBean)) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(wavBean.getWav());){
                Fingerprint fingerprint = new Fingerprint(this.config, AudioUtils.convertToMonoWithSampleRate(is, wavBean.getMaxSeconds(), SamplingRate.VERY_LOW));
                musicInfoBean.setAudioLength(fingerprint.getAudioLength());
                IdBean id = this.fingerPrintingDataSource.insertTune(musicInfoBean);
                this.fingerPrintingDataSource.insertHashes(fingerprint.toHashBeans(id));
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MusicInfoWithConfidenceBean match(WAVBean wavBean) throws IOException {
        if (wavBean == null) return null;
        if (wavBean.getWav().length <= 0) return null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(wavBean.getWav());){
            Fingerprint fingerprint = new Fingerprint(this.config, AudioUtils.convertToMonoWithSampleRate(is, wavBean.getMaxSeconds(), SamplingRate.VERY_LOW));
            Index index = new Index();
            index.setFingerPrintingClient(this.fingerPrintingDataSource);
            SongMatch songMatch = index.search(fingerprint, 15);
            if (songMatch == null) return null;
            if (songMatch.getIdSong() == -1) return null;
            SongNoBean songNoBean = new SongNoBean();
            songNoBean.setSongNo(songMatch.getIdSong());
            MusicInfoBean musicInfoBean = this.fingerPrintingDataSource.findTune(songNoBean);
            if (musicInfoBean == null) return null;
            MusicInfoWithConfidenceBean result = new MusicInfoWithConfidenceBean();
            result.setMusicInfo(musicInfoBean);
            result.setConfidence(songMatch.getCount());
            result.setRelativeConfidence((double)songMatch.getCount() / (double)fingerprint.getLinkList().size() * 100.0);
            result.setOffset(songMatch.getTime());
            result.setOffsetSeconds((double)songMatch.getTime() * 0.03225806451612903);
            MusicInfoWithConfidenceBean musicInfoWithConfidenceBean = result;
            return musicInfoWithConfidenceBean;
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
    }
}

