/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.sidid;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import libsidutils.sidid.SidIdBase;

public class SidIdInfo
extends SidIdBase {
    private static final String COMMENT_TOKEN = "  COMMENT: ";
    private static final String REFERENCE_TOKEN = "REFERENCE: ";
    private static final String RELEASED_TOKEN = " RELEASED: ";
    private static final String AUTHOR_TOKEN = "   AUTHOR: ";
    private static final String NAME_TOKEN = "     NAME: ";
    public static final String SID_ID_PKG = "libsidutils/sidid/";
    public static final String FNAME = "sidid.nfo";
    private List<PlayerInfoSection> playerInfoList;

    public void readconfig() throws IOException {
        this.playerInfoList = new ArrayList<PlayerInfoSection>();
        PlayerInfoSection playerInfoSection = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.readConfiguration(FNAME, SID_ID_PKG)), StandardCharsets.ISO_8859_1));){
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer stok = new StringTokenizer(line, "\n");
                while (stok.hasMoreTokens()) {
                    String token = stok.nextToken();
                    if (token.length() <= 0) continue;
                    if (token.startsWith(NAME_TOKEN)) {
                        playerInfoSection.setName(token.substring(NAME_TOKEN.length()));
                        continue;
                    }
                    if (token.startsWith(AUTHOR_TOKEN)) {
                        playerInfoSection.setAuthor(token.substring(AUTHOR_TOKEN.length()));
                        continue;
                    }
                    if (token.startsWith(RELEASED_TOKEN)) {
                        playerInfoSection.setReleased(token.substring(RELEASED_TOKEN.length()));
                        continue;
                    }
                    if (token.startsWith(COMMENT_TOKEN)) {
                        playerInfoSection.setComment(token.substring(COMMENT_TOKEN.length()).trim());
                        continue;
                    }
                    if (token.startsWith(REFERENCE_TOKEN)) {
                        playerInfoSection.setReference(token.substring(REFERENCE_TOKEN.length()));
                        continue;
                    }
                    if (token.startsWith(" ")) {
                        playerInfoSection.setComment(playerInfoSection.getComment() + "\n" + token);
                        continue;
                    }
                    playerInfoSection = new PlayerInfoSection(token);
                    this.playerInfoList.add(playerInfoSection);
                }
            }
        }
    }

    public PlayerInfoSection getPlayerInfo(String playerName) {
        for (PlayerInfoSection playerInfo : this.playerInfoList) {
            if (!playerInfo.playerName.equals(playerName)) continue;
            return playerInfo;
        }
        return null;
    }

    public void writeconfig(List<PlayerInfoSection> playerInfoList) {
        for (PlayerInfoSection playerInfoSection2 : playerInfoList) {
            System.out.println(playerInfoSection2.toString());
        }
    }

    public static void main(String[] args) throws IOException {
        SidIdInfo sidIdInfo = new SidIdInfo();
        sidIdInfo.readconfig();
        sidIdInfo.writeconfig(sidIdInfo.playerInfoList);
    }

    public static class PlayerInfoSection {
        private final String playerName;
        private String name;
        private String author;
        private String released;
        private String reference;
        private String comment;

        public PlayerInfoSection(String name) {
            this.playerName = name;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAuthor() {
            return this.author;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getReleased() {
            return this.released;
        }

        public final void setReleased(String released) {
            this.released = released;
        }

        public final String getReference() {
            return this.reference;
        }

        public final void setReference(String reference) {
            this.reference = reference;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.playerName).append('\n');
            if (this.name != null) {
                stringBuilder.append(SidIdInfo.NAME_TOKEN + this.name).append('\n');
            }
            if (this.author != null) {
                stringBuilder.append(SidIdInfo.AUTHOR_TOKEN + this.author).append('\n');
            }
            if (this.released != null) {
                stringBuilder.append(SidIdInfo.RELEASED_TOKEN + this.released).append('\n');
            }
            if (this.comment != null) {
                stringBuilder.append(SidIdInfo.COMMENT_TOKEN + this.comment).append('\n');
            }
            if (this.reference != null) {
                stringBuilder.append(SidIdInfo.REFERENCE_TOKEN + this.reference).append('\n');
            }
            stringBuilder.append('\n');
            return stringBuilder.toString();
        }
    }
}

