/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common;

import jakarta.servlet.ServletContext;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import server.restful.common.IServletSystemProperties;
import ui.common.util.VersionUtil;

public class ServletUtil {
    public static boolean isSecured(ServletSecurity servletSecurity) {
        HttpConstraint httpConstraint = servletSecurity != null ? servletSecurity.value() : null;
        return httpConstraint != null && (httpConstraint.rolesAllowed().length > 0 || ServletSecurity.EmptyRoleSemantic.DENY.equals((Object)httpConstraint.value()));
    }

    public static Map<String, String> createReplacements(Boolean useDevTools) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("baseUrl", IServletSystemProperties.JSIDPlay2Server.BASE_URL);
        replacements.put("version", VersionUtil.VERSION);
        replacements.put("year", String.valueOf(LocalDate.now().getYear()));
        replacements.put("devtools", String.valueOf(Boolean.TRUE.equals(useDevTools)));
        replacements.put("min", Boolean.TRUE.equals(useDevTools) ? "" : ".min");
        replacements.put("prod", Boolean.TRUE.equals(useDevTools) ? "" : ".prod");
        replacements.put("lib", Boolean.TRUE.equals(useDevTools) ? "lib" : "lib-minified");
        replacements.put("staticPath", "/static");
        return replacements;
    }

    public static void info(ServletContext servletContext, String msg, Thread ... parentThreads) {
        servletContext.log(ServletUtil.threads(parentThreads) + ServletUtil.thread() + msg);
    }

    public static void warn(ServletContext servletContext, String msg, Thread ... parentThreads) {
        servletContext.log(ServletUtil.threads(parentThreads) + ServletUtil.thread() + msg, null);
    }

    public static void error(ServletContext servletContext, Throwable t, Thread ... parentThreads) {
        servletContext.log(ServletUtil.threads(parentThreads) + ServletUtil.thread() + t.getMessage(), t);
    }

    public static void uncaughtExceptionHandler(ServletContext servletContext, Throwable t, Thread thread, Thread ... parentThreads) {
        servletContext.log(ServletUtil.threads(parentThreads) + ServletUtil.thread(thread) + t.getMessage(), IServletSystemProperties.JSIDPlay2Server.UNCAUGHT_EXCEPTION_HANDLER_EXCEPTIONS ? t : null);
    }

    public static StringBuilder threads(Thread ... threads) {
        return Stream.of(threads).map(ServletUtil::thread).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
    }

    public static String thread() {
        return ServletUtil.thread(Thread.currentThread());
    }

    private static String thread(Thread thread) {
        StringBuilder result = new StringBuilder();
        result.append(thread.getName());
        result.append(" (");
        result.append(thread.getId());
        result.append(")");
        result.append(": ");
        return result.toString();
    }
}

