/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@WebFilter(filterName="CounterBasedRateLimiterFilter", displayName="CounterBasedRateLimiterFilter", servletNames={"SpeechToTextServlet"}, description="Ensure a maximum number of requests in parallel (server overload protection)")
public final class CounterBasedRateLimiterFilter
extends HttpFilter {
    public static final String FILTER_PARAMETER_MAX_REQUESTS_PER_SERVLET = "maxRequestsPerServlet";
    private final AtomicInteger atomicServletRequestCounter = new AtomicInteger();
    private int maxRequestsPerServlet;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.maxRequestsPerServlet = Integer.parseInt(Optional.ofNullable(filterConfig.getInitParameter(FILTER_PARAMETER_MAX_REQUESTS_PER_SERVLET)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_MAX_REQUESTS_PER_SERVLET)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (this.atomicServletRequestCounter.getAndIncrement() < this.maxRequestsPerServlet) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(429, "Too Many Requests");
            }
        }
        finally {
            this.atomicServletRequestCounter.getAndDecrement();
        }
    }
}

