/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import libsidutils.IOUtils;
import server.restful.common.ServletUtil;
import server.restful.common.log.MonitoringThread;

@WebFilter(filterName="RequestLogFilter", displayName="RequestLogFilter", servletNames={"OnKeepAliveServlet", "ProxyServlet", "InsertNextCartServlet", "InsertNextDiskServlet", "JoystickServlet", "OnPlayDoneServlet", "OnPlayServlet", "PressKeyServlet", "SetDefaultEmulationReSidFpServlet", "SetDefaultEmulationReSidServlet", "SetSidModel6581Servlet", "SetSidModel8580Servlet", "ExSIDMappingServlet", "HardSIDMappingServlet", "SIDBlasterMappingServlet", "USBSIDMappingServlet", "FindHashServlet", "FindTuneServlet", "InsertHashesServlet", "InsertTuneServlet", "TuneExistsServlet", "WhatsSidServlet", "ConvertServlet", "DirectoryServlet", "DiskDirectoryServlet", "DownloadServlet", "FavoritesNamesServlet", "FavoritesServlet", "FiltersServlet", "LogsServlet", "PhotoServlet", "QRCodeServlet", "RandomHVSCServlet", "SongLengthServlet", "SpeechToTextServlet", "StartPageServlet", "StaticServlet", "STILServlet", "TuneInfoServlet", "UploadServlet", "WebJarsServlet"}, description="Log request and response")
public final class RequestLogFilter
extends HttpFilter {
    private static final Logger LOG = Logger.getLogger(RequestLogFilter.class.getName());
    public static final String FILTER_PARAMETER_SERVLET_NAME = "servletName";
    @Inject
    protected MonitoringThread monitoringThread;
    private ServletContext servletContext;
    private String servletName;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.servletName = Optional.ofNullable(filterConfig.getInitParameter(FILTER_PARAMETER_SERVLET_NAME)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_SERVLET_NAME));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log(ServletUtil.thread() + this.user(request) + this.remoteAddr(request) + this.localAddr(request) + this.request(request) + this.memory() + this.cpu());
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        this.log(ServletUtil.thread() + this.response(response) + this.memory() + this.cpu());
    }

    private String remoteAddr(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append("from ");
        result.append(request.getRemoteAddr());
        result.append(" (");
        result.append(request.getRemotePort());
        result.append(") ");
        return result.toString();
    }

    private String localAddr(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append("to ");
        result.append(request.getLocalAddr());
        result.append(" (");
        result.append(request.getLocalPort());
        result.append("), ");
        return result.toString();
    }

    private String user(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append("user ");
        result.append(Optional.ofNullable(request.getRemoteUser()).orElse("<anonymous>"));
        result.append(", ");
        return result.toString();
    }

    private String request(HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append("REQUEST: ");
        result.append(request.getMethod());
        result.append(" ");
        result.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            result.append("?");
            result.append(request.getQueryString());
        }
        if (LOG.isLoggable(Level.FINEST)) {
            result.append(" ");
            Enumeration headerNamesEnumeration = request.getHeaderNames();
            while (headerNamesEnumeration.hasMoreElements()) {
                String headerName = (String)headerNamesEnumeration.nextElement();
                result.append(headerName + "=" + request.getHeader(headerName));
                if (!headerNamesEnumeration.hasMoreElements()) continue;
                result.append(", ");
            }
        } else {
            if (request.getContentType() != null) {
                result.append(" ");
                result.append("Content-Type");
                result.append("=");
                result.append(request.getContentType());
            }
            if (request.getContentLengthLong() != -1L) {
                result.append(", ");
                result.append("Content-Length");
                result.append("=");
                result.append(IOUtils.getPhysicalSize(request.getContentLengthLong()));
            }
        }
        result.append(", ");
        return result.toString();
    }

    private String response(HttpServletResponse response) {
        StringBuilder result = new StringBuilder();
        result.append("RESPONSE: STATUS=");
        result.append(response.getStatus());
        if (LOG.isLoggable(Level.FINEST)) {
            result.append(" ");
            result.append(response.getHeaderNames().stream().map(headerName -> headerName + "=" + response.getHeader(headerName)).collect(Collectors.joining(", ")));
        } else if (response.getContentType() != null) {
            result.append(" ");
            result.append("Content-Type");
            result.append("=");
            result.append(response.getContentType());
        }
        result.append(", ");
        return result.toString();
    }

    private String memory() {
        StringBuilder result = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        result.append(IOUtils.getPhysicalSize(runtime.totalMemory() - runtime.freeMemory()));
        result.append("/");
        result.append(IOUtils.getPhysicalSize(runtime.maxMemory()));
        result.append(", ");
        return result.toString();
    }

    private String cpu() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("CPU %d%%", (int)(this.monitoringThread.getAvarageUsagePerCPU() * 100.0) / 100));
        return result.toString();
    }

    public void log(String message) {
        this.servletContext.log(this.servletName + ": " + message);
    }
}

