/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

@WebFilter(filterName="TimeBasedRateLimiterFilter", displayName="TimeBasedRateLimiterFilter", servletNames={"StartPageServlet"}, description="Ensure a maximum number of requests per minute (server overload protection)")
public class TimeBasedRateLimiterFilter
extends HttpFilter {
    public static final String FILTER_PARAMETER_MAX_REQUESTS_PER_MINUTE = "maxRequestsPerMinute";
    private ConcurrentHashMap<String, RequestTimer> requestTimers = new ConcurrentHashMap();
    private int maxRequestsPerMinute;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.maxRequestsPerMinute = Integer.parseInt(Optional.ofNullable(filterConfig.getInitParameter(FILTER_PARAMETER_MAX_REQUESTS_PER_MINUTE)).orElseThrow(() -> new UnavailableException(FILTER_PARAMETER_MAX_REQUESTS_PER_MINUTE)));
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestTimer timer = this.requestTimers.computeIfAbsent(request.getRemoteAddr(), x$0 -> new RequestTimer((String)x$0));
        if (timer.increment() < this.maxRequestsPerMinute) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendError(429, "Too Many Requests");
        }
    }

    public void destroy() {
        this.requestTimers.values().forEach(RequestTimer::cancel);
    }

    private final class RequestTimer {
        private final Timer timer;
        private int count;

        private RequestTimer(final String clientIp) {
            this.timer = new Timer(TimeBasedRateLimiterFilter.class.getSimpleName() + "-Timer-" + clientIp, false);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    this.cancel();
                }

                @Override
                public boolean cancel() {
                    TimeBasedRateLimiterFilter.this.requestTimers.remove(clientIp);
                    return super.cancel();
                }
            }, TimeUnit.MINUTES.toMillis(1L));
        }

        public int increment() {
            return this.count++;
        }

        public void cancel() {
            this.timer.cancel();
        }
    }
}

