/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.processor;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessCommandUsageFormatter
extends DefaultUsageFormatter {
    private JCommander commander;
    private List<String> arguments = new ArrayList<String>();

    public ProcessCommandUsageFormatter(JCommander commander) {
        super(commander);
        this.commander = commander;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void appendMainLine(StringBuilder out, boolean hasOptions, boolean hasCommands, int indentCount, String indent) {
        this.arguments.addAll(Arrays.asList(this.commander.getProgramDisplayName().split(" ")));
    }

    public void appendAllParametersDetails(StringBuilder out, int indentCount, String indent, List<ParameterDescription> sortedParameters) {
        try {
            this.createCmdLineArguments();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void createCmdLineArguments() throws MalformedURLException, URISyntaxException {
        for (ParameterDescription def : this.commander.getFields().values().stream().filter(pd -> !pd.getParameter().hidden() && pd.getDefault() != null).sorted(this.commander.getParameterDescriptionComparator()).collect(Collectors.toList())) {
            this.arguments.add(this.getParameterName(def.getNames()));
            Class type2 = def.getParameterized().getType();
            if ((type2.equals(Boolean.TYPE) || type2.equals(Boolean.class)) && def.getParameter().arity() <= 0) continue;
            this.arguments.add(def.getParameter().password() ? "********" : String.valueOf(def.getDefault()));
        }
        if (this.commander.getMainParameter() != null && this.commander.getMainParameterValue() != null) {
            this.arguments.add(String.valueOf(this.commander.getMainParameterValue().getDefault()));
        }
    }

    private String getParameterName(String names) {
        return Arrays.asList(names.split(", ")).stream().max(Comparator.comparingInt(String::length)).orElse("");
    }
}

