/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.zxing.WriterException;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.QrCode;
import server.restful.common.ServletUtil;
import server.restful.common.converter.Base64ParameterConverter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;

@WebServlet(name="QRCodeServlet", displayName="QRCodeServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/qrcode"}, description="Create QR Code for url")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class QRCodeServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            QRCodeServletParameters servletParameters = new QRCodeServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            String contents = servletParameters.getContents();
            ContentTypeAndFileExtensions ct = servletParameters.getContentType().toContentTypeAndFileExtension();
            int width = servletParameters.getWidth();
            int height = servletParameters.getHeight();
            String qrCodeImgTag = this.createQrCodeImgTag(contents, "UTF-8", "png", width, height);
            this.setOutput(ct, response, qrCodeImgTag);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private String createQrCodeImgTag(String data, String charset, String imgFormat, int width, int height) throws IOException, WriterException {
        try {
            ByteArrayOutputStream qrCodeImgData = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)QrCode.createBarCodeImage(data, charset, width, height), imgFormat, qrCodeImgData);
            return String.format("<img src='data:image/%s;base64,%s'>", imgFormat, DatatypeConverter.printBase64Binary((byte[])qrCodeImgData.toByteArray()));
        }
        catch (WriterException e) {
            return String.format("<img src='data:image/%s;base64,%s'>", imgFormat, DatatypeConverter.printBase64Binary((byte[])new byte[0]));
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.QRCodeServletParameters")
    public static class QRCodeServletParameters
    extends UsageParameter {
        private ContentType contentType = ContentType.MIME_TYPE_HTML;
        private int width = 320;
        private int height = 320;
        private String contents = "";

        public ContentType getContentType() {
            return this.contentType;
        }

        @Parameter(names={"--contentType"}, descriptionKey="CONTENT_TYPE", order=-2147483647)
        public void setContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        public int getWidth() {
            return this.width;
        }

        @Parameter(names={"--width"}, descriptionKey="WIDTH", order=-2147483646)
        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        @Parameter(names={"--height"}, descriptionKey="HEIGHT", order=-2147483645)
        public void setHeight(int height) {
            this.height = height;
        }

        public String getContents() {
            return this.contents;
        }

        @Parameter(names={"--contents"}, descriptionKey="CONTENTS", converter=Base64ParameterConverter.class, required=true, order=-2147483644)
        public void setContentS(String contents) {
            this.contents = contents;
        }

        private static enum ContentType {
            MIME_TYPE_HTML,
            MIME_TYPE_JSON;


            private ContentTypeAndFileExtensions toContentTypeAndFileExtension() {
                return ContentTypeAndFileExtensions.valueOf(this.name());
            }
        }
    }
}

